/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
import $protobuf from "protobufjs/minimal.js";

// Common aliases
const $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
const $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

export const proto = $root.proto = (() => {

    /**
     * Namespace proto.
     * @exports proto
     * @namespace
     */
    const proto = {};

    proto.ADVDeviceIdentity = (function() {

        /**
         * Properties of a ADVDeviceIdentity.
         * @memberof proto
         * @interface IADVDeviceIdentity
         * @property {number|null} [rawId] ADVDeviceIdentity rawId
         * @property {number|Long|null} [timestamp] ADVDeviceIdentity timestamp
         * @property {number|null} [keyIndex] ADVDeviceIdentity keyIndex
         * @property {proto.ADVEncryptionType|null} [accountType] ADVDeviceIdentity accountType
         * @property {proto.ADVEncryptionType|null} [deviceType] ADVDeviceIdentity deviceType
         */

        /**
         * Constructs a new ADVDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVDeviceIdentity.
         * @implements IADVDeviceIdentity
         * @constructor
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         */
        function ADVDeviceIdentity(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVDeviceIdentity rawId.
         * @member {number|null|undefined} rawId
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.rawId = null;

        /**
         * ADVDeviceIdentity timestamp.
         * @member {number|Long|null|undefined} timestamp
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.timestamp = null;

        /**
         * ADVDeviceIdentity keyIndex.
         * @member {number|null|undefined} keyIndex
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.keyIndex = null;

        /**
         * ADVDeviceIdentity accountType.
         * @member {proto.ADVEncryptionType|null|undefined} accountType
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.accountType = null;

        /**
         * ADVDeviceIdentity deviceType.
         * @member {proto.ADVEncryptionType|null|undefined} deviceType
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.deviceType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_keyIndex", {
            get: $util.oneOfGetter($oneOfFields = ["keyIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVDeviceIdentity.prototype, "_deviceType", {
            get: $util.oneOfGetter($oneOfFields = ["deviceType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity instance
         */
        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.keyIndex != null && Object.hasOwnProperty.call(message, "keyIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.keyIndex);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.accountType);
            if (message.deviceType != null && Object.hasOwnProperty.call(message, "deviceType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.deviceType);
            return writer;
        };

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVDeviceIdentity();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.rawId = reader.uint32();
                        break;
                    }
                case 2: {
                        message.timestamp = reader.uint64();
                        break;
                    }
                case 3: {
                        message.keyIndex = reader.uint32();
                        break;
                    }
                case 4: {
                        message.accountType = reader.int32();
                        break;
                    }
                case 5: {
                        message.deviceType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.rawId != null && message.hasOwnProperty("rawId")) {
                properties._rawId = 1;
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                properties._timestamp = 1;
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            }
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex")) {
                properties._keyIndex = 1;
                if (!$util.isInteger(message.keyIndex))
                    return "keyIndex: integer expected";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                properties._accountType = 1;
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.deviceType != null && message.hasOwnProperty("deviceType")) {
                properties._deviceType = 1;
                switch (message.deviceType) {
                default:
                    return "deviceType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         */
        ADVDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVDeviceIdentity)
                return object;
            let message = new $root.proto.ADVDeviceIdentity();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.keyIndex != null)
                message.keyIndex = object.keyIndex >>> 0;
            switch (object.accountType) {
            default:
                if (typeof object.accountType === "number") {
                    message.accountType = object.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                message.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                message.accountType = 1;
                break;
            }
            switch (object.deviceType) {
            default:
                if (typeof object.deviceType === "number") {
                    message.deviceType = object.deviceType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                message.deviceType = 0;
                break;
            case "HOSTED":
            case 1:
                message.deviceType = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.ADVDeviceIdentity} message ADVDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.rawId != null && message.hasOwnProperty("rawId")) {
                object.rawId = message.rawId;
                if (options.oneofs)
                    object._rawId = "rawId";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
                if (options.oneofs)
                    object._timestamp = "timestamp";
            }
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex")) {
                object.keyIndex = message.keyIndex;
                if (options.oneofs)
                    object._keyIndex = "keyIndex";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                object.accountType = options.enums === String ? $root.proto.ADVEncryptionType[message.accountType] === undefined ? message.accountType : $root.proto.ADVEncryptionType[message.accountType] : message.accountType;
                if (options.oneofs)
                    object._accountType = "accountType";
            }
            if (message.deviceType != null && message.hasOwnProperty("deviceType")) {
                object.deviceType = options.enums === String ? $root.proto.ADVEncryptionType[message.deviceType] === undefined ? message.deviceType : $root.proto.ADVEncryptionType[message.deviceType] : message.deviceType;
                if (options.oneofs)
                    object._deviceType = "deviceType";
            }
            return object;
        };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ADVDeviceIdentity
         * @function getTypeUrl
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ADVDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVDeviceIdentity";
        };

        return ADVDeviceIdentity;
    })();

    /**
     * ADVEncryptionType enum.
     * @name proto.ADVEncryptionType
     * @enum {number}
     * @property {number} E2EE=0 E2EE value
     * @property {number} HOSTED=1 HOSTED value
     */
    proto.ADVEncryptionType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "E2EE"] = 0;
        values[valuesById[1] = "HOSTED"] = 1;
        return values;
    })();

    proto.ADVKeyIndexList = (function() {

        /**
         * Properties of a ADVKeyIndexList.
         * @memberof proto
         * @interface IADVKeyIndexList
         * @property {number|null} [rawId] ADVKeyIndexList rawId
         * @property {number|Long|null} [timestamp] ADVKeyIndexList timestamp
         * @property {number|null} [currentIndex] ADVKeyIndexList currentIndex
         * @property {Array.<number>|null} [validIndexes] ADVKeyIndexList validIndexes
         * @property {proto.ADVEncryptionType|null} [accountType] ADVKeyIndexList accountType
         */

        /**
         * Constructs a new ADVKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVKeyIndexList.
         * @implements IADVKeyIndexList
         * @constructor
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         */
        function ADVKeyIndexList(properties) {
            this.validIndexes = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVKeyIndexList rawId.
         * @member {number|null|undefined} rawId
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.rawId = null;

        /**
         * ADVKeyIndexList timestamp.
         * @member {number|Long|null|undefined} timestamp
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.timestamp = null;

        /**
         * ADVKeyIndexList currentIndex.
         * @member {number|null|undefined} currentIndex
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.currentIndex = null;

        /**
         * ADVKeyIndexList validIndexes.
         * @member {Array.<number>} validIndexes
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;

        /**
         * ADVKeyIndexList accountType.
         * @member {proto.ADVEncryptionType|null|undefined} accountType
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.accountType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_rawId", {
            get: $util.oneOfGetter($oneOfFields = ["rawId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_currentIndex", {
            get: $util.oneOfGetter($oneOfFields = ["currentIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVKeyIndexList.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList instance
         */
        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.currentIndex);
            if (message.validIndexes != null && message.validIndexes.length) {
                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                for (let i = 0; i < message.validIndexes.length; ++i)
                    writer.uint32(message.validIndexes[i]);
                writer.ldelim();
            }
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVKeyIndexList();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.rawId = reader.uint32();
                        break;
                    }
                case 2: {
                        message.timestamp = reader.uint64();
                        break;
                    }
                case 3: {
                        message.currentIndex = reader.uint32();
                        break;
                    }
                case 4: {
                        if (!(message.validIndexes && message.validIndexes.length))
                            message.validIndexes = [];
                        if ((tag & 7) === 2) {
                            let end2 = reader.uint32() + reader.pos;
                            while (reader.pos < end2)
                                message.validIndexes.push(reader.uint32());
                        } else
                            message.validIndexes.push(reader.uint32());
                        break;
                    }
                case 5: {
                        message.accountType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVKeyIndexList message.
         * @function verify
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.rawId != null && message.hasOwnProperty("rawId")) {
                properties._rawId = 1;
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                properties._timestamp = 1;
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            }
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex")) {
                properties._currentIndex = 1;
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            }
            if (message.validIndexes != null && message.hasOwnProperty("validIndexes")) {
                if (!Array.isArray(message.validIndexes))
                    return "validIndexes: array expected";
                for (let i = 0; i < message.validIndexes.length; ++i)
                    if (!$util.isInteger(message.validIndexes[i]))
                        return "validIndexes: integer[] expected";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                properties._accountType = 1;
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         */
        ADVKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVKeyIndexList)
                return object;
            let message = new $root.proto.ADVKeyIndexList();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.validIndexes) {
                if (!Array.isArray(object.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                message.validIndexes = [];
                for (let i = 0; i < object.validIndexes.length; ++i)
                    message.validIndexes[i] = object.validIndexes[i] >>> 0;
            }
            switch (object.accountType) {
            default:
                if (typeof object.accountType === "number") {
                    message.accountType = object.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                message.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                message.accountType = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.ADVKeyIndexList} message ADVKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.validIndexes = [];
            if (message.rawId != null && message.hasOwnProperty("rawId")) {
                object.rawId = message.rawId;
                if (options.oneofs)
                    object._rawId = "rawId";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
                if (options.oneofs)
                    object._timestamp = "timestamp";
            }
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex")) {
                object.currentIndex = message.currentIndex;
                if (options.oneofs)
                    object._currentIndex = "currentIndex";
            }
            if (message.validIndexes && message.validIndexes.length) {
                object.validIndexes = [];
                for (let j = 0; j < message.validIndexes.length; ++j)
                    object.validIndexes[j] = message.validIndexes[j];
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                object.accountType = options.enums === String ? $root.proto.ADVEncryptionType[message.accountType] === undefined ? message.accountType : $root.proto.ADVEncryptionType[message.accountType] : message.accountType;
                if (options.oneofs)
                    object._accountType = "accountType";
            }
            return object;
        };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ADVKeyIndexList
         * @function getTypeUrl
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ADVKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVKeyIndexList";
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentity.
         * @memberof proto
         * @interface IADVSignedDeviceIdentity
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentity details
         * @property {Uint8Array|null} [accountSignatureKey] ADVSignedDeviceIdentity accountSignatureKey
         * @property {Uint8Array|null} [accountSignature] ADVSignedDeviceIdentity accountSignature
         * @property {Uint8Array|null} [deviceSignature] ADVSignedDeviceIdentity deviceSignature
         */

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentity.
         * @implements IADVSignedDeviceIdentity
         * @constructor
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentity(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentity details.
         * @member {Uint8Array|null|undefined} details
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.details = null;

        /**
         * ADVSignedDeviceIdentity accountSignatureKey.
         * @member {Uint8Array|null|undefined} accountSignatureKey
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = null;

        /**
         * ADVSignedDeviceIdentity accountSignature.
         * @member {Uint8Array|null|undefined} accountSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignature = null;

        /**
         * ADVSignedDeviceIdentity deviceSignature.
         * @member {Uint8Array|null|undefined} deviceSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.deviceSignature = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentity.prototype, "_deviceSignature", {
            get: $util.oneOfGetter($oneOfFields = ["deviceSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity instance
         */
        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignatureKey != null && Object.hasOwnProperty.call(message, "accountSignatureKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignatureKey);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.accountSignature);
            if (message.deviceSignature != null && Object.hasOwnProperty.call(message, "deviceSignature"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.deviceSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentity();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.details = reader.bytes();
                        break;
                    }
                case 2: {
                        message.accountSignatureKey = reader.bytes();
                        break;
                    }
                case 3: {
                        message.accountSignature = reader.bytes();
                        break;
                    }
                case 4: {
                        message.deviceSignature = reader.bytes();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                properties._details = 1;
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            }
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey")) {
                properties._accountSignatureKey = 1;
                if (!(message.accountSignatureKey && typeof message.accountSignatureKey.length === "number" || $util.isString(message.accountSignatureKey)))
                    return "accountSignatureKey: buffer expected";
            }
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature")) {
                properties._accountSignature = 1;
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            }
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature")) {
                properties._deviceSignature = 1;
                if (!(message.deviceSignature && typeof message.deviceSignature.length === "number" || $util.isString(message.deviceSignature)))
                    return "deviceSignature: buffer expected";
            }
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         */
        ADVSignedDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentity)
                return object;
            let message = new $root.proto.ADVSignedDeviceIdentity();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length >= 0)
                    message.details = object.details;
            if (object.accountSignatureKey != null)
                if (typeof object.accountSignatureKey === "string")
                    $util.base64.decode(object.accountSignatureKey, message.accountSignatureKey = $util.newBuffer($util.base64.length(object.accountSignatureKey)), 0);
                else if (object.accountSignatureKey.length >= 0)
                    message.accountSignatureKey = object.accountSignatureKey;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length >= 0)
                    message.accountSignature = object.accountSignature;
            if (object.deviceSignature != null)
                if (typeof object.deviceSignature === "string")
                    $util.base64.decode(object.deviceSignature, message.deviceSignature = $util.newBuffer($util.base64.length(object.deviceSignature)), 0);
                else if (object.deviceSignature.length >= 0)
                    message.deviceSignature = object.deviceSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.ADVSignedDeviceIdentity} message ADVSignedDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
                if (options.oneofs)
                    object._details = "details";
            }
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey")) {
                object.accountSignatureKey = options.bytes === String ? $util.base64.encode(message.accountSignatureKey, 0, message.accountSignatureKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignatureKey) : message.accountSignatureKey;
                if (options.oneofs)
                    object._accountSignatureKey = "accountSignatureKey";
            }
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature")) {
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
                if (options.oneofs)
                    object._accountSignature = "accountSignature";
            }
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature")) {
                object.deviceSignature = options.bytes === String ? $util.base64.encode(message.deviceSignature, 0, message.deviceSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceSignature) : message.deviceSignature;
                if (options.oneofs)
                    object._deviceSignature = "deviceSignature";
            }
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ADVSignedDeviceIdentity
         * @function getTypeUrl
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ADVSignedDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentity";
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @interface IADVSignedDeviceIdentityHMAC
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentityHMAC details
         * @property {Uint8Array|null} [hmac] ADVSignedDeviceIdentityHMAC hmac
         * @property {proto.ADVEncryptionType|null} [accountType] ADVSignedDeviceIdentityHMAC accountType
         */

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentityHMAC.
         * @implements IADVSignedDeviceIdentityHMAC
         * @constructor
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentityHMAC(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentityHMAC details.
         * @member {Uint8Array|null|undefined} details
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.details = null;

        /**
         * ADVSignedDeviceIdentityHMAC hmac.
         * @member {Uint8Array|null|undefined} hmac
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.hmac = null;

        /**
         * ADVSignedDeviceIdentityHMAC accountType.
         * @member {proto.ADVEncryptionType|null|undefined} accountType
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.accountType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_hmac", {
            get: $util.oneOfGetter($oneOfFields = ["hmac"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedDeviceIdentityHMAC.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC instance
         */
        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.hmac != null && Object.hasOwnProperty.call(message, "hmac"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.hmac);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.details = reader.bytes();
                        break;
                    }
                case 2: {
                        message.hmac = reader.bytes();
                        break;
                    }
                case 3: {
                        message.accountType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentityHMAC.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                properties._details = 1;
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            }
            if (message.hmac != null && message.hasOwnProperty("hmac")) {
                properties._hmac = 1;
                if (!(message.hmac && typeof message.hmac.length === "number" || $util.isString(message.hmac)))
                    return "hmac: buffer expected";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                properties._accountType = 1;
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         */
        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return object;
            let message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length >= 0)
                    message.details = object.details;
            if (object.hmac != null)
                if (typeof object.hmac === "string")
                    $util.base64.decode(object.hmac, message.hmac = $util.newBuffer($util.base64.length(object.hmac)), 0);
                else if (object.hmac.length >= 0)
                    message.hmac = object.hmac;
            switch (object.accountType) {
            default:
                if (typeof object.accountType === "number") {
                    message.accountType = object.accountType;
                    break;
                }
                break;
            case "E2EE":
            case 0:
                message.accountType = 0;
                break;
            case "HOSTED":
            case 1:
                message.accountType = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.ADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentityHMAC.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
                if (options.oneofs)
                    object._details = "details";
            }
            if (message.hmac != null && message.hasOwnProperty("hmac")) {
                object.hmac = options.bytes === String ? $util.base64.encode(message.hmac, 0, message.hmac.length) : options.bytes === Array ? Array.prototype.slice.call(message.hmac) : message.hmac;
                if (options.oneofs)
                    object._hmac = "hmac";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                object.accountType = options.enums === String ? $root.proto.ADVEncryptionType[message.accountType] === undefined ? message.accountType : $root.proto.ADVEncryptionType[message.accountType] : message.accountType;
                if (options.oneofs)
                    object._accountType = "accountType";
            }
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ADVSignedDeviceIdentityHMAC
         * @function getTypeUrl
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ADVSignedDeviceIdentityHMAC.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentityHMAC";
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        /**
         * Properties of a ADVSignedKeyIndexList.
         * @memberof proto
         * @interface IADVSignedKeyIndexList
         * @property {Uint8Array|null} [details] ADVSignedKeyIndexList details
         * @property {Uint8Array|null} [accountSignature] ADVSignedKeyIndexList accountSignature
         * @property {Uint8Array|null} [accountSignatureKey] ADVSignedKeyIndexList accountSignatureKey
         */

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVSignedKeyIndexList.
         * @implements IADVSignedKeyIndexList
         * @constructor
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         */
        function ADVSignedKeyIndexList(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedKeyIndexList details.
         * @member {Uint8Array|null|undefined} details
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.details = null;

        /**
         * ADVSignedKeyIndexList accountSignature.
         * @member {Uint8Array|null|undefined} accountSignature
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.accountSignature = null;

        /**
         * ADVSignedKeyIndexList accountSignatureKey.
         * @member {Uint8Array|null|undefined} accountSignatureKey
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.accountSignatureKey = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_details", {
            get: $util.oneOfGetter($oneOfFields = ["details"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignature", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignature"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ADVSignedKeyIndexList.prototype, "_accountSignatureKey", {
            get: $util.oneOfGetter($oneOfFields = ["accountSignatureKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList instance
         */
        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignature);
            if (message.accountSignatureKey != null && Object.hasOwnProperty.call(message, "accountSignatureKey"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.accountSignatureKey);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedKeyIndexList();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.details = reader.bytes();
                        break;
                    }
                case 2: {
                        message.accountSignature = reader.bytes();
                        break;
                    }
                case 3: {
                        message.accountSignatureKey = reader.bytes();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @function verify
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                properties._details = 1;
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            }
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature")) {
                properties._accountSignature = 1;
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            }
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey")) {
                properties._accountSignatureKey = 1;
                if (!(message.accountSignatureKey && typeof message.accountSignatureKey.length === "number" || $util.isString(message.accountSignatureKey)))
                    return "accountSignatureKey: buffer expected";
            }
            return null;
        };

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         */
        ADVSignedKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedKeyIndexList)
                return object;
            let message = new $root.proto.ADVSignedKeyIndexList();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length >= 0)
                    message.details = object.details;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length >= 0)
                    message.accountSignature = object.accountSignature;
            if (object.accountSignatureKey != null)
                if (typeof object.accountSignatureKey === "string")
                    $util.base64.decode(object.accountSignatureKey, message.accountSignatureKey = $util.newBuffer($util.base64.length(object.accountSignatureKey)), 0);
                else if (object.accountSignatureKey.length >= 0)
                    message.accountSignatureKey = object.accountSignatureKey;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.ADVSignedKeyIndexList} message ADVSignedKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.details != null && message.hasOwnProperty("details")) {
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
                if (options.oneofs)
                    object._details = "details";
            }
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature")) {
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
                if (options.oneofs)
                    object._accountSignature = "accountSignature";
            }
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey")) {
                object.accountSignatureKey = options.bytes === String ? $util.base64.encode(message.accountSignatureKey, 0, message.accountSignatureKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignatureKey) : message.accountSignatureKey;
                if (options.oneofs)
                    object._accountSignatureKey = "accountSignatureKey";
            }
            return object;
        };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ADVSignedKeyIndexList
         * @function getTypeUrl
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ADVSignedKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedKeyIndexList";
        };

        return ADVSignedKeyIndexList;
    })();

    proto.AIQueryFanout = (function() {

        /**
         * Properties of a AIQueryFanout.
         * @memberof proto
         * @interface IAIQueryFanout
         * @property {proto.IMessageKey|null} [messageKey] AIQueryFanout messageKey
         * @property {proto.IMessage|null} [message] AIQueryFanout message
         * @property {number|Long|null} [timestamp] AIQueryFanout timestamp
         */

        /**
         * Constructs a new AIQueryFanout.
         * @memberof proto
         * @classdesc Represents a AIQueryFanout.
         * @implements IAIQueryFanout
         * @constructor
         * @param {proto.IAIQueryFanout=} [properties] Properties to set
         */
        function AIQueryFanout(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AIQueryFanout messageKey.
         * @member {proto.IMessageKey|null|undefined} messageKey
         * @memberof proto.AIQueryFanout
         * @instance
         */
        AIQueryFanout.prototype.messageKey = null;

        /**
         * AIQueryFanout message.
         * @member {proto.IMessage|null|undefined} message
         * @memberof proto.AIQueryFanout
         * @instance
         */
        AIQueryFanout.prototype.message = null;

        /**
         * AIQueryFanout timestamp.
         * @member {number|Long|null|undefined} timestamp
         * @memberof proto.AIQueryFanout
         * @instance
         */
        AIQueryFanout.prototype.timestamp = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_messageKey", {
            get: $util.oneOfGetter($oneOfFields = ["messageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_message", {
            get: $util.oneOfGetter($oneOfFields = ["message"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIQueryFanout.prototype, "_timestamp", {
            get: $util.oneOfGetter($oneOfFields = ["timestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new AIQueryFanout instance using the specified properties.
         * @function create
         * @memberof proto.AIQueryFanout
         * @static
         * @param {proto.IAIQueryFanout=} [properties] Properties to set
         * @returns {proto.AIQueryFanout} AIQueryFanout instance
         */
        AIQueryFanout.create = function create(properties) {
            return new AIQueryFanout(properties);
        };

        /**
         * Encodes the specified AIQueryFanout message. Does not implicitly {@link proto.AIQueryFanout.verify|verify} messages.
         * @function encode
         * @memberof proto.AIQueryFanout
         * @static
         * @param {proto.IAIQueryFanout} message AIQueryFanout message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AIQueryFanout.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageKey != null && Object.hasOwnProperty.call(message, "messageKey"))
                $root.proto.MessageKey.encode(message.messageKey, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.Message.encode(message.message, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified AIQueryFanout message, length delimited. Does not implicitly {@link proto.AIQueryFanout.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AIQueryFanout
         * @static
         * @param {proto.IAIQueryFanout} message AIQueryFanout message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AIQueryFanout.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a AIQueryFanout message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AIQueryFanout
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AIQueryFanout} AIQueryFanout
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AIQueryFanout.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIQueryFanout();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.messageKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        message.message = $root.proto.Message.decode(reader, reader.uint32());
                        break;
                    }
                case 3: {
                        message.timestamp = reader.int64();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a AIQueryFanout message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AIQueryFanout
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AIQueryFanout} AIQueryFanout
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AIQueryFanout.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a AIQueryFanout message.
         * @function verify
         * @memberof proto.AIQueryFanout
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AIQueryFanout.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.messageKey != null && message.hasOwnProperty("messageKey")) {
                properties._messageKey = 1;
                {
                    let error = $root.proto.MessageKey.verify(message.messageKey);
                    if (error)
                        return "messageKey." + error;
                }
            }
            if (message.message != null && message.hasOwnProperty("message")) {
                properties._message = 1;
                {
                    let error = $root.proto.Message.verify(message.message);
                    if (error)
                        return "message." + error;
                }
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                properties._timestamp = 1;
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            }
            return null;
        };

        /**
         * Creates a AIQueryFanout message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AIQueryFanout
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AIQueryFanout} AIQueryFanout
         */
        AIQueryFanout.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AIQueryFanout)
                return object;
            let message = new $root.proto.AIQueryFanout();
            if (object.messageKey != null) {
                if (typeof object.messageKey !== "object")
                    throw TypeError(".proto.AIQueryFanout.messageKey: object expected");
                message.messageKey = $root.proto.MessageKey.fromObject(object.messageKey);
            }
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.AIQueryFanout.message: object expected");
                message.message = $root.proto.Message.fromObject(object.message);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a AIQueryFanout message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AIQueryFanout
         * @static
         * @param {proto.AIQueryFanout} message AIQueryFanout
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AIQueryFanout.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.messageKey != null && message.hasOwnProperty("messageKey")) {
                object.messageKey = $root.proto.MessageKey.toObject(message.messageKey, options);
                if (options.oneofs)
                    object._messageKey = "messageKey";
            }
            if (message.message != null && message.hasOwnProperty("message")) {
                object.message = $root.proto.Message.toObject(message.message, options);
                if (options.oneofs)
                    object._message = "message";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
                if (options.oneofs)
                    object._timestamp = "timestamp";
            }
            return object;
        };

        /**
         * Converts this AIQueryFanout to JSON.
         * @function toJSON
         * @memberof proto.AIQueryFanout
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AIQueryFanout.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for AIQueryFanout
         * @function getTypeUrl
         * @memberof proto.AIQueryFanout
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        AIQueryFanout.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIQueryFanout";
        };

        return AIQueryFanout;
    })();

    proto.AIRichResponseMessage = (function() {

        /**
         * Properties of a AIRichResponseMessage.
         * @memberof proto
         * @interface IAIRichResponseMessage
         * @property {proto.AIRichResponseMessage.AIRichResponseMessageType|null} [messageType] AIRichResponseMessage messageType
         * @property {Array.<proto.AIRichResponseMessage.IAIRichResponseSubMessage>|null} [submessages] AIRichResponseMessage submessages
         * @property {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse|null} [unifiedResponse] AIRichResponseMessage unifiedResponse
         */

        /**
         * Constructs a new AIRichResponseMessage.
         * @memberof proto
         * @classdesc Represents a AIRichResponseMessage.
         * @implements IAIRichResponseMessage
         * @constructor
         * @param {proto.IAIRichResponseMessage=} [properties] Properties to set
         */
        function AIRichResponseMessage(properties) {
            this.submessages = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AIRichResponseMessage messageType.
         * @member {proto.AIRichResponseMessage.AIRichResponseMessageType|null|undefined} messageType
         * @memberof proto.AIRichResponseMessage
         * @instance
         */
        AIRichResponseMessage.prototype.messageType = null;

        /**
         * AIRichResponseMessage submessages.
         * @member {Array.<proto.AIRichResponseMessage.IAIRichResponseSubMessage>} submessages
         * @memberof proto.AIRichResponseMessage
         * @instance
         */
        AIRichResponseMessage.prototype.submessages = $util.emptyArray;

        /**
         * AIRichResponseMessage unifiedResponse.
         * @member {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse|null|undefined} unifiedResponse
         * @memberof proto.AIRichResponseMessage
         * @instance
         */
        AIRichResponseMessage.prototype.unifiedResponse = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_messageType", {
            get: $util.oneOfGetter($oneOfFields = ["messageType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AIRichResponseMessage.prototype, "_unifiedResponse", {
            get: $util.oneOfGetter($oneOfFields = ["unifiedResponse"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new AIRichResponseMessage instance using the specified properties.
         * @function create
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {proto.IAIRichResponseMessage=} [properties] Properties to set
         * @returns {proto.AIRichResponseMessage} AIRichResponseMessage instance
         */
        AIRichResponseMessage.create = function create(properties) {
            return new AIRichResponseMessage(properties);
        };

        /**
         * Encodes the specified AIRichResponseMessage message. Does not implicitly {@link proto.AIRichResponseMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {proto.IAIRichResponseMessage} message AIRichResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AIRichResponseMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageType != null && Object.hasOwnProperty.call(message, "messageType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.messageType);
            if (message.submessages != null && message.submessages.length)
                for (let i = 0; i < message.submessages.length; ++i)
                    $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.encode(message.submessages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.unifiedResponse != null && Object.hasOwnProperty.call(message, "unifiedResponse"))
                $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.encode(message.unifiedResponse, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AIRichResponseMessage message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {proto.IAIRichResponseMessage} message AIRichResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AIRichResponseMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a AIRichResponseMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AIRichResponseMessage} AIRichResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AIRichResponseMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.messageType = reader.int32();
                        break;
                    }
                case 2: {
                        if (!(message.submessages && message.submessages.length))
                            message.submessages = [];
                        message.submessages.push($root.proto.AIRichResponseMessage.AIRichResponseSubMessage.decode(reader, reader.uint32()));
                        break;
                    }
                case 3: {
                        message.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.decode(reader, reader.uint32());
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a AIRichResponseMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AIRichResponseMessage} AIRichResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AIRichResponseMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a AIRichResponseMessage message.
         * @function verify
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AIRichResponseMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.messageType != null && message.hasOwnProperty("messageType")) {
                properties._messageType = 1;
                switch (message.messageType) {
                default:
                    return "messageType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.submessages != null && message.hasOwnProperty("submessages")) {
                if (!Array.isArray(message.submessages))
                    return "submessages: array expected";
                for (let i = 0; i < message.submessages.length; ++i) {
                    let error = $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.verify(message.submessages[i]);
                    if (error)
                        return "submessages." + error;
                }
            }
            if (message.unifiedResponse != null && message.hasOwnProperty("unifiedResponse")) {
                properties._unifiedResponse = 1;
                {
                    let error = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.verify(message.unifiedResponse);
                    if (error)
                        return "unifiedResponse." + error;
                }
            }
            return null;
        };

        /**
         * Creates a AIRichResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AIRichResponseMessage} AIRichResponseMessage
         */
        AIRichResponseMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AIRichResponseMessage)
                return object;
            let message = new $root.proto.AIRichResponseMessage();
            switch (object.messageType) {
            default:
                if (typeof object.messageType === "number") {
                    message.messageType = object.messageType;
                    break;
                }
                break;
            case "AI_RICH_RESPONSE_TYPE_UNKNOWN":
            case 0:
                message.messageType = 0;
                break;
            case "AI_RICH_RESPONSE_TYPE_STANDARD":
            case 1:
                message.messageType = 1;
                break;
            }
            if (object.submessages) {
                if (!Array.isArray(object.submessages))
                    throw TypeError(".proto.AIRichResponseMessage.submessages: array expected");
                message.submessages = [];
                for (let i = 0; i < object.submessages.length; ++i) {
                    if (typeof object.submessages[i] !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.submessages: object expected");
                    message.submessages[i] = $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.fromObject(object.submessages[i]);
                }
            }
            if (object.unifiedResponse != null) {
                if (typeof object.unifiedResponse !== "object")
                    throw TypeError(".proto.AIRichResponseMessage.unifiedResponse: object expected");
                message.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.fromObject(object.unifiedResponse);
            }
            return message;
        };

        /**
         * Creates a plain object from a AIRichResponseMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {proto.AIRichResponseMessage} message AIRichResponseMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AIRichResponseMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.submessages = [];
            if (message.messageType != null && message.hasOwnProperty("messageType")) {
                object.messageType = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseMessageType[message.messageType] === undefined ? message.messageType : $root.proto.AIRichResponseMessage.AIRichResponseMessageType[message.messageType] : message.messageType;
                if (options.oneofs)
                    object._messageType = "messageType";
            }
            if (message.submessages && message.submessages.length) {
                object.submessages = [];
                for (let j = 0; j < message.submessages.length; ++j)
                    object.submessages[j] = $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.toObject(message.submessages[j], options);
            }
            if (message.unifiedResponse != null && message.hasOwnProperty("unifiedResponse")) {
                object.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.toObject(message.unifiedResponse, options);
                if (options.oneofs)
                    object._unifiedResponse = "unifiedResponse";
            }
            return object;
        };

        /**
         * Converts this AIRichResponseMessage to JSON.
         * @function toJSON
         * @memberof proto.AIRichResponseMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AIRichResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for AIRichResponseMessage
         * @function getTypeUrl
         * @memberof proto.AIRichResponseMessage
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        AIRichResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseMessage";
        };

        AIRichResponseMessage.AIRichResponseCodeMetadata = (function() {

            /**
             * Properties of a AIRichResponseCodeMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseCodeMetadata
             * @property {string|null} [codeLanguage] AIRichResponseCodeMetadata codeLanguage
             * @property {Array.<proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock>|null} [codeBlocks] AIRichResponseCodeMetadata codeBlocks
             */

            /**
             * Constructs a new AIRichResponseCodeMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseCodeMetadata.
             * @implements IAIRichResponseCodeMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata=} [properties] Properties to set
             */
            function AIRichResponseCodeMetadata(properties) {
                this.codeBlocks = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseCodeMetadata codeLanguage.
             * @member {string|null|undefined} codeLanguage
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @instance
             */
            AIRichResponseCodeMetadata.prototype.codeLanguage = null;

            /**
             * AIRichResponseCodeMetadata codeBlocks.
             * @member {Array.<proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock>} codeBlocks
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @instance
             */
            AIRichResponseCodeMetadata.prototype.codeBlocks = $util.emptyArray;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseCodeMetadata.prototype, "_codeLanguage", {
                get: $util.oneOfGetter($oneOfFields = ["codeLanguage"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseCodeMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata} AIRichResponseCodeMetadata instance
             */
            AIRichResponseCodeMetadata.create = function create(properties) {
                return new AIRichResponseCodeMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseCodeMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata} message AIRichResponseCodeMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseCodeMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.codeLanguage != null && Object.hasOwnProperty.call(message, "codeLanguage"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.codeLanguage);
                if (message.codeBlocks != null && message.codeBlocks.length)
                    for (let i = 0; i < message.codeBlocks.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.encode(message.codeBlocks[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseCodeMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata} message AIRichResponseCodeMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseCodeMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseCodeMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata} AIRichResponseCodeMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseCodeMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.codeLanguage = reader.string();
                            break;
                        }
                    case 2: {
                            if (!(message.codeBlocks && message.codeBlocks.length))
                                message.codeBlocks = [];
                            message.codeBlocks.push($root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseCodeMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata} AIRichResponseCodeMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseCodeMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseCodeMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseCodeMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.codeLanguage != null && message.hasOwnProperty("codeLanguage")) {
                    properties._codeLanguage = 1;
                    if (!$util.isString(message.codeLanguage))
                        return "codeLanguage: string expected";
                }
                if (message.codeBlocks != null && message.hasOwnProperty("codeBlocks")) {
                    if (!Array.isArray(message.codeBlocks))
                        return "codeBlocks: array expected";
                    for (let i = 0; i < message.codeBlocks.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.verify(message.codeBlocks[i]);
                        if (error)
                            return "codeBlocks." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseCodeMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata} AIRichResponseCodeMetadata
             */
            AIRichResponseCodeMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata();
                if (object.codeLanguage != null)
                    message.codeLanguage = String(object.codeLanguage);
                if (object.codeBlocks) {
                    if (!Array.isArray(object.codeBlocks))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseCodeMetadata.codeBlocks: array expected");
                    message.codeBlocks = [];
                    for (let i = 0; i < object.codeBlocks.length; ++i) {
                        if (typeof object.codeBlocks[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseCodeMetadata.codeBlocks: object expected");
                        message.codeBlocks[i] = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.fromObject(object.codeBlocks[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseCodeMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata} message AIRichResponseCodeMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseCodeMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.codeBlocks = [];
                if (message.codeLanguage != null && message.hasOwnProperty("codeLanguage")) {
                    object.codeLanguage = message.codeLanguage;
                    if (options.oneofs)
                        object._codeLanguage = "codeLanguage";
                }
                if (message.codeBlocks && message.codeBlocks.length) {
                    object.codeBlocks = [];
                    for (let j = 0; j < message.codeBlocks.length; ++j)
                        object.codeBlocks[j] = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.toObject(message.codeBlocks[j], options);
                }
                return object;
            };

            /**
             * Converts this AIRichResponseCodeMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseCodeMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseCodeMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseCodeMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata";
            };

            AIRichResponseCodeMetadata.AIRichResponseCodeBlock = (function() {

                /**
                 * Properties of a AIRichResponseCodeBlock.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
                 * @interface IAIRichResponseCodeBlock
                 * @property {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType|null} [highlightType] AIRichResponseCodeBlock highlightType
                 * @property {string|null} [codeContent] AIRichResponseCodeBlock codeContent
                 */

                /**
                 * Constructs a new AIRichResponseCodeBlock.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata
                 * @classdesc Represents a AIRichResponseCodeBlock.
                 * @implements IAIRichResponseCodeBlock
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock=} [properties] Properties to set
                 */
                function AIRichResponseCodeBlock(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseCodeBlock highlightType.
                 * @member {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType|null|undefined} highlightType
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @instance
                 */
                AIRichResponseCodeBlock.prototype.highlightType = null;

                /**
                 * AIRichResponseCodeBlock codeContent.
                 * @member {string|null|undefined} codeContent
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @instance
                 */
                AIRichResponseCodeBlock.prototype.codeContent = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseCodeBlock.prototype, "_highlightType", {
                    get: $util.oneOfGetter($oneOfFields = ["highlightType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseCodeBlock.prototype, "_codeContent", {
                    get: $util.oneOfGetter($oneOfFields = ["codeContent"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseCodeBlock instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock} AIRichResponseCodeBlock instance
                 */
                AIRichResponseCodeBlock.create = function create(properties) {
                    return new AIRichResponseCodeBlock(properties);
                };

                /**
                 * Encodes the specified AIRichResponseCodeBlock message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock} message AIRichResponseCodeBlock message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseCodeBlock.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.highlightType != null && Object.hasOwnProperty.call(message, "highlightType"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.highlightType);
                    if (message.codeContent != null && Object.hasOwnProperty.call(message, "codeContent"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.codeContent);
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseCodeBlock message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock} message AIRichResponseCodeBlock message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseCodeBlock.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseCodeBlock message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock} AIRichResponseCodeBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseCodeBlock.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.highlightType = reader.int32();
                                break;
                            }
                        case 2: {
                                message.codeContent = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseCodeBlock message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock} AIRichResponseCodeBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseCodeBlock.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseCodeBlock message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseCodeBlock.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.highlightType != null && message.hasOwnProperty("highlightType")) {
                        properties._highlightType = 1;
                        switch (message.highlightType) {
                        default:
                            return "highlightType: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                            break;
                        }
                    }
                    if (message.codeContent != null && message.hasOwnProperty("codeContent")) {
                        properties._codeContent = 1;
                        if (!$util.isString(message.codeContent))
                            return "codeContent: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseCodeBlock message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock} AIRichResponseCodeBlock
                 */
                AIRichResponseCodeBlock.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                    switch (object.highlightType) {
                    default:
                        if (typeof object.highlightType === "number") {
                            message.highlightType = object.highlightType;
                            break;
                        }
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT":
                    case 0:
                        message.highlightType = 0;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD":
                    case 1:
                        message.highlightType = 1;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD":
                    case 2:
                        message.highlightType = 2;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING":
                    case 3:
                        message.highlightType = 3;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER":
                    case 4:
                        message.highlightType = 4;
                        break;
                    case "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT":
                    case 5:
                        message.highlightType = 5;
                        break;
                    }
                    if (object.codeContent != null)
                        message.codeContent = String(object.codeContent);
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseCodeBlock message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock} message AIRichResponseCodeBlock
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseCodeBlock.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.highlightType != null && message.hasOwnProperty("highlightType")) {
                        object.highlightType = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[message.highlightType] === undefined ? message.highlightType : $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType[message.highlightType] : message.highlightType;
                        if (options.oneofs)
                            object._highlightType = "highlightType";
                    }
                    if (message.codeContent != null && message.hasOwnProperty("codeContent")) {
                        object.codeContent = message.codeContent;
                        if (options.oneofs)
                            object._codeContent = "codeContent";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseCodeBlock to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseCodeBlock.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseCodeBlock
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseCodeBlock.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock";
                };

                return AIRichResponseCodeBlock;
            })();

            /**
             * AIRichResponseCodeHighlightType enum.
             * @name proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType
             * @enum {number}
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT=0 AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT value
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD=1 AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD value
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD=2 AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD value
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING=3 AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING value
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER=4 AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER value
             * @property {number} AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT=5 AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT value
             */
            AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD"] = 2;
                values[valuesById[3] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING"] = 3;
                values[valuesById[4] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER"] = 4;
                values[valuesById[5] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT"] = 5;
                return values;
            })();

            return AIRichResponseCodeMetadata;
        })();

        AIRichResponseMessage.AIRichResponseContentItemsMetadata = (function() {

            /**
             * Properties of a AIRichResponseContentItemsMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseContentItemsMetadata
             * @property {Array.<proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata>|null} [itemsMetadata] AIRichResponseContentItemsMetadata itemsMetadata
             * @property {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType|null} [contentType] AIRichResponseContentItemsMetadata contentType
             */

            /**
             * Constructs a new AIRichResponseContentItemsMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseContentItemsMetadata.
             * @implements IAIRichResponseContentItemsMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata=} [properties] Properties to set
             */
            function AIRichResponseContentItemsMetadata(properties) {
                this.itemsMetadata = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseContentItemsMetadata itemsMetadata.
             * @member {Array.<proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata>} itemsMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @instance
             */
            AIRichResponseContentItemsMetadata.prototype.itemsMetadata = $util.emptyArray;

            /**
             * AIRichResponseContentItemsMetadata contentType.
             * @member {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType|null|undefined} contentType
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @instance
             */
            AIRichResponseContentItemsMetadata.prototype.contentType = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseContentItemsMetadata.prototype, "_contentType", {
                get: $util.oneOfGetter($oneOfFields = ["contentType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseContentItemsMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata} AIRichResponseContentItemsMetadata instance
             */
            AIRichResponseContentItemsMetadata.create = function create(properties) {
                return new AIRichResponseContentItemsMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseContentItemsMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata} message AIRichResponseContentItemsMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseContentItemsMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.itemsMetadata != null && message.itemsMetadata.length)
                    for (let i = 0; i < message.itemsMetadata.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.encode(message.itemsMetadata[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                if (message.contentType != null && Object.hasOwnProperty.call(message, "contentType"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.contentType);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseContentItemsMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata} message AIRichResponseContentItemsMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseContentItemsMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseContentItemsMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata} AIRichResponseContentItemsMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseContentItemsMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            if (!(message.itemsMetadata && message.itemsMetadata.length))
                                message.itemsMetadata = [];
                            message.itemsMetadata.push($root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.decode(reader, reader.uint32()));
                            break;
                        }
                    case 2: {
                            message.contentType = reader.int32();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseContentItemsMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata} AIRichResponseContentItemsMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseContentItemsMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseContentItemsMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseContentItemsMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.itemsMetadata != null && message.hasOwnProperty("itemsMetadata")) {
                    if (!Array.isArray(message.itemsMetadata))
                        return "itemsMetadata: array expected";
                    for (let i = 0; i < message.itemsMetadata.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.verify(message.itemsMetadata[i]);
                        if (error)
                            return "itemsMetadata." + error;
                    }
                }
                if (message.contentType != null && message.hasOwnProperty("contentType")) {
                    properties._contentType = 1;
                    switch (message.contentType) {
                    default:
                        return "contentType: enum value expected";
                    case 0:
                    case 1:
                        break;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseContentItemsMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata} AIRichResponseContentItemsMetadata
             */
            AIRichResponseContentItemsMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata();
                if (object.itemsMetadata) {
                    if (!Array.isArray(object.itemsMetadata))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.itemsMetadata: array expected");
                    message.itemsMetadata = [];
                    for (let i = 0; i < object.itemsMetadata.length; ++i) {
                        if (typeof object.itemsMetadata[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.itemsMetadata: object expected");
                        message.itemsMetadata[i] = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.fromObject(object.itemsMetadata[i]);
                    }
                }
                switch (object.contentType) {
                default:
                    if (typeof object.contentType === "number") {
                        message.contentType = object.contentType;
                        break;
                    }
                    break;
                case "DEFAULT":
                case 0:
                    message.contentType = 0;
                    break;
                case "CAROUSEL":
                case 1:
                    message.contentType = 1;
                    break;
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseContentItemsMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata} message AIRichResponseContentItemsMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseContentItemsMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.itemsMetadata = [];
                if (message.itemsMetadata && message.itemsMetadata.length) {
                    object.itemsMetadata = [];
                    for (let j = 0; j < message.itemsMetadata.length; ++j)
                        object.itemsMetadata[j] = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.toObject(message.itemsMetadata[j], options);
                }
                if (message.contentType != null && message.hasOwnProperty("contentType")) {
                    object.contentType = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType[message.contentType] === undefined ? message.contentType : $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType[message.contentType] : message.contentType;
                    if (options.oneofs)
                        object._contentType = "contentType";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseContentItemsMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseContentItemsMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseContentItemsMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseContentItemsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata";
            };

            AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata = (function() {

                /**
                 * Properties of a AIRichResponseContentItemMetadata.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
                 * @interface IAIRichResponseContentItemMetadata
                 * @property {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem|null} [reelItem] AIRichResponseContentItemMetadata reelItem
                 */

                /**
                 * Constructs a new AIRichResponseContentItemMetadata.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
                 * @classdesc Represents a AIRichResponseContentItemMetadata.
                 * @implements IAIRichResponseContentItemMetadata
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata=} [properties] Properties to set
                 */
                function AIRichResponseContentItemMetadata(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseContentItemMetadata reelItem.
                 * @member {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem|null|undefined} reelItem
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @instance
                 */
                AIRichResponseContentItemMetadata.prototype.reelItem = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                /**
                 * AIRichResponseContentItemMetadata aIRichResponseContentItem.
                 * @member {"reelItem"|undefined} aIRichResponseContentItem
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @instance
                 */
                Object.defineProperty(AIRichResponseContentItemMetadata.prototype, "aIRichResponseContentItem", {
                    get: $util.oneOfGetter($oneOfFields = ["reelItem"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseContentItemMetadata instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata} AIRichResponseContentItemMetadata instance
                 */
                AIRichResponseContentItemMetadata.create = function create(properties) {
                    return new AIRichResponseContentItemMetadata(properties);
                };

                /**
                 * Encodes the specified AIRichResponseContentItemMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata} message AIRichResponseContentItemMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseContentItemMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.reelItem != null && Object.hasOwnProperty.call(message, "reelItem"))
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.encode(message.reelItem, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseContentItemMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata} message AIRichResponseContentItemMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseContentItemMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseContentItemMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata} AIRichResponseContentItemMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseContentItemMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.decode(reader, reader.uint32());
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseContentItemMetadata message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata} AIRichResponseContentItemMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseContentItemMetadata.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseContentItemMetadata message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseContentItemMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.reelItem != null && message.hasOwnProperty("reelItem")) {
                        properties.aIRichResponseContentItem = 1;
                        {
                            let error = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.verify(message.reelItem);
                            if (error)
                                return "reelItem." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseContentItemMetadata message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata} AIRichResponseContentItemMetadata
                 */
                AIRichResponseContentItemMetadata.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                    if (object.reelItem != null) {
                        if (typeof object.reelItem !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.reelItem: object expected");
                        message.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.fromObject(object.reelItem);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseContentItemMetadata message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata} message AIRichResponseContentItemMetadata
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseContentItemMetadata.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.reelItem != null && message.hasOwnProperty("reelItem")) {
                        object.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.toObject(message.reelItem, options);
                        if (options.oneofs)
                            object.aIRichResponseContentItem = "reelItem";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseContentItemMetadata to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseContentItemMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseContentItemMetadata
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseContentItemMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata";
                };

                return AIRichResponseContentItemMetadata;
            })();

            AIRichResponseContentItemsMetadata.AIRichResponseReelItem = (function() {

                /**
                 * Properties of a AIRichResponseReelItem.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
                 * @interface IAIRichResponseReelItem
                 * @property {string|null} [title] AIRichResponseReelItem title
                 * @property {string|null} [profileIconUrl] AIRichResponseReelItem profileIconUrl
                 * @property {string|null} [thumbnailUrl] AIRichResponseReelItem thumbnailUrl
                 * @property {string|null} [videoUrl] AIRichResponseReelItem videoUrl
                 */

                /**
                 * Constructs a new AIRichResponseReelItem.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata
                 * @classdesc Represents a AIRichResponseReelItem.
                 * @implements IAIRichResponseReelItem
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem=} [properties] Properties to set
                 */
                function AIRichResponseReelItem(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseReelItem title.
                 * @member {string|null|undefined} title
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @instance
                 */
                AIRichResponseReelItem.prototype.title = null;

                /**
                 * AIRichResponseReelItem profileIconUrl.
                 * @member {string|null|undefined} profileIconUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @instance
                 */
                AIRichResponseReelItem.prototype.profileIconUrl = null;

                /**
                 * AIRichResponseReelItem thumbnailUrl.
                 * @member {string|null|undefined} thumbnailUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @instance
                 */
                AIRichResponseReelItem.prototype.thumbnailUrl = null;

                /**
                 * AIRichResponseReelItem videoUrl.
                 * @member {string|null|undefined} videoUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @instance
                 */
                AIRichResponseReelItem.prototype.videoUrl = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_profileIconUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["profileIconUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_thumbnailUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["thumbnailUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseReelItem.prototype, "_videoUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["videoUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseReelItem instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem} AIRichResponseReelItem instance
                 */
                AIRichResponseReelItem.create = function create(properties) {
                    return new AIRichResponseReelItem(properties);
                };

                /**
                 * Encodes the specified AIRichResponseReelItem message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem} message AIRichResponseReelItem message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseReelItem.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
                    if (message.profileIconUrl != null && Object.hasOwnProperty.call(message, "profileIconUrl"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.profileIconUrl);
                    if (message.thumbnailUrl != null && Object.hasOwnProperty.call(message, "thumbnailUrl"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.thumbnailUrl);
                    if (message.videoUrl != null && Object.hasOwnProperty.call(message, "videoUrl"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.videoUrl);
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseReelItem message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem} message AIRichResponseReelItem message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseReelItem.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseReelItem message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem} AIRichResponseReelItem
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseReelItem.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.title = reader.string();
                                break;
                            }
                        case 2: {
                                message.profileIconUrl = reader.string();
                                break;
                            }
                        case 3: {
                                message.thumbnailUrl = reader.string();
                                break;
                            }
                        case 4: {
                                message.videoUrl = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseReelItem message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem} AIRichResponseReelItem
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseReelItem.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseReelItem message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseReelItem.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.title != null && message.hasOwnProperty("title")) {
                        properties._title = 1;
                        if (!$util.isString(message.title))
                            return "title: string expected";
                    }
                    if (message.profileIconUrl != null && message.hasOwnProperty("profileIconUrl")) {
                        properties._profileIconUrl = 1;
                        if (!$util.isString(message.profileIconUrl))
                            return "profileIconUrl: string expected";
                    }
                    if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl")) {
                        properties._thumbnailUrl = 1;
                        if (!$util.isString(message.thumbnailUrl))
                            return "thumbnailUrl: string expected";
                    }
                    if (message.videoUrl != null && message.hasOwnProperty("videoUrl")) {
                        properties._videoUrl = 1;
                        if (!$util.isString(message.videoUrl))
                            return "videoUrl: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseReelItem message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem} AIRichResponseReelItem
                 */
                AIRichResponseReelItem.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                    if (object.title != null)
                        message.title = String(object.title);
                    if (object.profileIconUrl != null)
                        message.profileIconUrl = String(object.profileIconUrl);
                    if (object.thumbnailUrl != null)
                        message.thumbnailUrl = String(object.thumbnailUrl);
                    if (object.videoUrl != null)
                        message.videoUrl = String(object.videoUrl);
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseReelItem message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem} message AIRichResponseReelItem
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseReelItem.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.title != null && message.hasOwnProperty("title")) {
                        object.title = message.title;
                        if (options.oneofs)
                            object._title = "title";
                    }
                    if (message.profileIconUrl != null && message.hasOwnProperty("profileIconUrl")) {
                        object.profileIconUrl = message.profileIconUrl;
                        if (options.oneofs)
                            object._profileIconUrl = "profileIconUrl";
                    }
                    if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl")) {
                        object.thumbnailUrl = message.thumbnailUrl;
                        if (options.oneofs)
                            object._thumbnailUrl = "thumbnailUrl";
                    }
                    if (message.videoUrl != null && message.hasOwnProperty("videoUrl")) {
                        object.videoUrl = message.videoUrl;
                        if (options.oneofs)
                            object._videoUrl = "videoUrl";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseReelItem to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseReelItem.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseReelItem
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseReelItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem";
                };

                return AIRichResponseReelItem;
            })();

            /**
             * ContentType enum.
             * @name proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType
             * @enum {number}
             * @property {number} DEFAULT=0 DEFAULT value
             * @property {number} CAROUSEL=1 CAROUSEL value
             */
            AIRichResponseContentItemsMetadata.ContentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "DEFAULT"] = 0;
                values[valuesById[1] = "CAROUSEL"] = 1;
                return values;
            })();

            return AIRichResponseContentItemsMetadata;
        })();

        AIRichResponseMessage.AIRichResponseDynamicMetadata = (function() {

            /**
             * Properties of a AIRichResponseDynamicMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseDynamicMetadata
             * @property {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType|null} [type] AIRichResponseDynamicMetadata type
             * @property {number|Long|null} [version] AIRichResponseDynamicMetadata version
             * @property {string|null} [url] AIRichResponseDynamicMetadata url
             * @property {number|null} [loopCount] AIRichResponseDynamicMetadata loopCount
             */

            /**
             * Constructs a new AIRichResponseDynamicMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseDynamicMetadata.
             * @implements IAIRichResponseDynamicMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata=} [properties] Properties to set
             */
            function AIRichResponseDynamicMetadata(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseDynamicMetadata type.
             * @member {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType|null|undefined} type
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @instance
             */
            AIRichResponseDynamicMetadata.prototype.type = null;

            /**
             * AIRichResponseDynamicMetadata version.
             * @member {number|Long|null|undefined} version
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @instance
             */
            AIRichResponseDynamicMetadata.prototype.version = null;

            /**
             * AIRichResponseDynamicMetadata url.
             * @member {string|null|undefined} url
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @instance
             */
            AIRichResponseDynamicMetadata.prototype.url = null;

            /**
             * AIRichResponseDynamicMetadata loopCount.
             * @member {number|null|undefined} loopCount
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @instance
             */
            AIRichResponseDynamicMetadata.prototype.loopCount = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_type", {
                get: $util.oneOfGetter($oneOfFields = ["type"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_version", {
                get: $util.oneOfGetter($oneOfFields = ["version"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_url", {
                get: $util.oneOfGetter($oneOfFields = ["url"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseDynamicMetadata.prototype, "_loopCount", {
                get: $util.oneOfGetter($oneOfFields = ["loopCount"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseDynamicMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata} AIRichResponseDynamicMetadata instance
             */
            AIRichResponseDynamicMetadata.create = function create(properties) {
                return new AIRichResponseDynamicMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseDynamicMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata} message AIRichResponseDynamicMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseDynamicMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
                if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                    writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.version);
                if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.url);
                if (message.loopCount != null && Object.hasOwnProperty.call(message, "loopCount"))
                    writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.loopCount);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseDynamicMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata} message AIRichResponseDynamicMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseDynamicMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseDynamicMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata} AIRichResponseDynamicMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseDynamicMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.type = reader.int32();
                            break;
                        }
                    case 2: {
                            message.version = reader.uint64();
                            break;
                        }
                    case 3: {
                            message.url = reader.string();
                            break;
                        }
                    case 4: {
                            message.loopCount = reader.uint32();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseDynamicMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata} AIRichResponseDynamicMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseDynamicMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseDynamicMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseDynamicMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.type != null && message.hasOwnProperty("type")) {
                    properties._type = 1;
                    switch (message.type) {
                    default:
                        return "type: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                }
                if (message.version != null && message.hasOwnProperty("version")) {
                    properties._version = 1;
                    if (!$util.isInteger(message.version) && !(message.version && $util.isInteger(message.version.low) && $util.isInteger(message.version.high)))
                        return "version: integer|Long expected";
                }
                if (message.url != null && message.hasOwnProperty("url")) {
                    properties._url = 1;
                    if (!$util.isString(message.url))
                        return "url: string expected";
                }
                if (message.loopCount != null && message.hasOwnProperty("loopCount")) {
                    properties._loopCount = 1;
                    if (!$util.isInteger(message.loopCount))
                        return "loopCount: integer expected";
                }
                return null;
            };

            /**
             * Creates a AIRichResponseDynamicMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata} AIRichResponseDynamicMetadata
             */
            AIRichResponseDynamicMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata();
                switch (object.type) {
                default:
                    if (typeof object.type === "number") {
                        message.type = object.type;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN":
                case 0:
                    message.type = 0;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE":
                case 1:
                    message.type = 1;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF":
                case 2:
                    message.type = 2;
                    break;
                }
                if (object.version != null)
                    if ($util.Long)
                        (message.version = $util.Long.fromValue(object.version)).unsigned = true;
                    else if (typeof object.version === "string")
                        message.version = parseInt(object.version, 10);
                    else if (typeof object.version === "number")
                        message.version = object.version;
                    else if (typeof object.version === "object")
                        message.version = new $util.LongBits(object.version.low >>> 0, object.version.high >>> 0).toNumber(true);
                if (object.url != null)
                    message.url = String(object.url);
                if (object.loopCount != null)
                    message.loopCount = object.loopCount >>> 0;
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseDynamicMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseDynamicMetadata} message AIRichResponseDynamicMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseDynamicMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.type != null && message.hasOwnProperty("type")) {
                    object.type = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[message.type] === undefined ? message.type : $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType[message.type] : message.type;
                    if (options.oneofs)
                        object._type = "type";
                }
                if (message.version != null && message.hasOwnProperty("version")) {
                    if (typeof message.version === "number")
                        object.version = options.longs === String ? String(message.version) : message.version;
                    else
                        object.version = options.longs === String ? $util.Long.prototype.toString.call(message.version) : options.longs === Number ? new $util.LongBits(message.version.low >>> 0, message.version.high >>> 0).toNumber(true) : message.version;
                    if (options.oneofs)
                        object._version = "version";
                }
                if (message.url != null && message.hasOwnProperty("url")) {
                    object.url = message.url;
                    if (options.oneofs)
                        object._url = "url";
                }
                if (message.loopCount != null && message.hasOwnProperty("loopCount")) {
                    object.loopCount = message.loopCount;
                    if (options.oneofs)
                        object._loopCount = "loopCount";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseDynamicMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseDynamicMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseDynamicMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseDynamicMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseDynamicMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseDynamicMetadata";
            };

            /**
             * AIRichResponseDynamicMetadataType enum.
             * @name proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType
             * @enum {number}
             * @property {number} AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN=0 AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN value
             * @property {number} AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE=1 AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE value
             * @property {number} AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF=2 AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF value
             */
            AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF"] = 2;
                return values;
            })();

            return AIRichResponseDynamicMetadata;
        })();

        AIRichResponseMessage.AIRichResponseGridImageMetadata = (function() {

            /**
             * Properties of a AIRichResponseGridImageMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseGridImageMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseImageURL|null} [gridImageUrl] AIRichResponseGridImageMetadata gridImageUrl
             * @property {Array.<proto.AIRichResponseMessage.IAIRichResponseImageURL>|null} [imageUrls] AIRichResponseGridImageMetadata imageUrls
             */

            /**
             * Constructs a new AIRichResponseGridImageMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseGridImageMetadata.
             * @implements IAIRichResponseGridImageMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata=} [properties] Properties to set
             */
            function AIRichResponseGridImageMetadata(properties) {
                this.imageUrls = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseGridImageMetadata gridImageUrl.
             * @member {proto.AIRichResponseMessage.IAIRichResponseImageURL|null|undefined} gridImageUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @instance
             */
            AIRichResponseGridImageMetadata.prototype.gridImageUrl = null;

            /**
             * AIRichResponseGridImageMetadata imageUrls.
             * @member {Array.<proto.AIRichResponseMessage.IAIRichResponseImageURL>} imageUrls
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @instance
             */
            AIRichResponseGridImageMetadata.prototype.imageUrls = $util.emptyArray;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseGridImageMetadata.prototype, "_gridImageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["gridImageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseGridImageMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseGridImageMetadata} AIRichResponseGridImageMetadata instance
             */
            AIRichResponseGridImageMetadata.create = function create(properties) {
                return new AIRichResponseGridImageMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseGridImageMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata} message AIRichResponseGridImageMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseGridImageMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.gridImageUrl != null && Object.hasOwnProperty.call(message, "gridImageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(message.gridImageUrl, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                if (message.imageUrls != null && message.imageUrls.length)
                    for (let i = 0; i < message.imageUrls.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(message.imageUrls[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseGridImageMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata} message AIRichResponseGridImageMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseGridImageMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseGridImageMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseGridImageMetadata} AIRichResponseGridImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseGridImageMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(reader, reader.uint32());
                            break;
                        }
                    case 2: {
                            if (!(message.imageUrls && message.imageUrls.length))
                                message.imageUrls = [];
                            message.imageUrls.push($root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseGridImageMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseGridImageMetadata} AIRichResponseGridImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseGridImageMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseGridImageMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseGridImageMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.gridImageUrl != null && message.hasOwnProperty("gridImageUrl")) {
                    properties._gridImageUrl = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.verify(message.gridImageUrl);
                        if (error)
                            return "gridImageUrl." + error;
                    }
                }
                if (message.imageUrls != null && message.hasOwnProperty("imageUrls")) {
                    if (!Array.isArray(message.imageUrls))
                        return "imageUrls: array expected";
                    for (let i = 0; i < message.imageUrls.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.verify(message.imageUrls[i]);
                        if (error)
                            return "imageUrls." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseGridImageMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseGridImageMetadata} AIRichResponseGridImageMetadata
             */
            AIRichResponseGridImageMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata();
                if (object.gridImageUrl != null) {
                    if (typeof object.gridImageUrl !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.gridImageUrl: object expected");
                    message.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(object.gridImageUrl);
                }
                if (object.imageUrls) {
                    if (!Array.isArray(object.imageUrls))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.imageUrls: array expected");
                    message.imageUrls = [];
                    for (let i = 0; i < object.imageUrls.length; ++i) {
                        if (typeof object.imageUrls[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.imageUrls: object expected");
                        message.imageUrls[i] = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(object.imageUrls[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseGridImageMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseGridImageMetadata} message AIRichResponseGridImageMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseGridImageMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.imageUrls = [];
                if (message.gridImageUrl != null && message.hasOwnProperty("gridImageUrl")) {
                    object.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(message.gridImageUrl, options);
                    if (options.oneofs)
                        object._gridImageUrl = "gridImageUrl";
                }
                if (message.imageUrls && message.imageUrls.length) {
                    object.imageUrls = [];
                    for (let j = 0; j < message.imageUrls.length; ++j)
                        object.imageUrls[j] = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(message.imageUrls[j], options);
                }
                return object;
            };

            /**
             * Converts this AIRichResponseGridImageMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseGridImageMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseGridImageMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseGridImageMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseGridImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseGridImageMetadata";
            };

            return AIRichResponseGridImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseImageURL = (function() {

            /**
             * Properties of a AIRichResponseImageURL.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseImageURL
             * @property {string|null} [imagePreviewUrl] AIRichResponseImageURL imagePreviewUrl
             * @property {string|null} [imageHighResUrl] AIRichResponseImageURL imageHighResUrl
             * @property {string|null} [sourceUrl] AIRichResponseImageURL sourceUrl
             */

            /**
             * Constructs a new AIRichResponseImageURL.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseImageURL.
             * @implements IAIRichResponseImageURL
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseImageURL=} [properties] Properties to set
             */
            function AIRichResponseImageURL(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseImageURL imagePreviewUrl.
             * @member {string|null|undefined} imagePreviewUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @instance
             */
            AIRichResponseImageURL.prototype.imagePreviewUrl = null;

            /**
             * AIRichResponseImageURL imageHighResUrl.
             * @member {string|null|undefined} imageHighResUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @instance
             */
            AIRichResponseImageURL.prototype.imageHighResUrl = null;

            /**
             * AIRichResponseImageURL sourceUrl.
             * @member {string|null|undefined} sourceUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @instance
             */
            AIRichResponseImageURL.prototype.sourceUrl = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_imagePreviewUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imagePreviewUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_imageHighResUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imageHighResUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseImageURL.prototype, "_sourceUrl", {
                get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseImageURL instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseImageURL=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseImageURL} AIRichResponseImageURL instance
             */
            AIRichResponseImageURL.create = function create(properties) {
                return new AIRichResponseImageURL(properties);
            };

            /**
             * Encodes the specified AIRichResponseImageURL message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseImageURL.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseImageURL} message AIRichResponseImageURL message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseImageURL.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.imagePreviewUrl != null && Object.hasOwnProperty.call(message, "imagePreviewUrl"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.imagePreviewUrl);
                if (message.imageHighResUrl != null && Object.hasOwnProperty.call(message, "imageHighResUrl"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.imageHighResUrl);
                if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.sourceUrl);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseImageURL message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseImageURL.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseImageURL} message AIRichResponseImageURL message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseImageURL.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseImageURL message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseImageURL} AIRichResponseImageURL
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseImageURL.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseImageURL();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.imagePreviewUrl = reader.string();
                            break;
                        }
                    case 2: {
                            message.imageHighResUrl = reader.string();
                            break;
                        }
                    case 3: {
                            message.sourceUrl = reader.string();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseImageURL message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseImageURL} AIRichResponseImageURL
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseImageURL.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseImageURL message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseImageURL.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.imagePreviewUrl != null && message.hasOwnProperty("imagePreviewUrl")) {
                    properties._imagePreviewUrl = 1;
                    if (!$util.isString(message.imagePreviewUrl))
                        return "imagePreviewUrl: string expected";
                }
                if (message.imageHighResUrl != null && message.hasOwnProperty("imageHighResUrl")) {
                    properties._imageHighResUrl = 1;
                    if (!$util.isString(message.imageHighResUrl))
                        return "imageHighResUrl: string expected";
                }
                if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                    properties._sourceUrl = 1;
                    if (!$util.isString(message.sourceUrl))
                        return "sourceUrl: string expected";
                }
                return null;
            };

            /**
             * Creates a AIRichResponseImageURL message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseImageURL} AIRichResponseImageURL
             */
            AIRichResponseImageURL.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseImageURL)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseImageURL();
                if (object.imagePreviewUrl != null)
                    message.imagePreviewUrl = String(object.imagePreviewUrl);
                if (object.imageHighResUrl != null)
                    message.imageHighResUrl = String(object.imageHighResUrl);
                if (object.sourceUrl != null)
                    message.sourceUrl = String(object.sourceUrl);
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseImageURL message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseImageURL} message AIRichResponseImageURL
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseImageURL.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.imagePreviewUrl != null && message.hasOwnProperty("imagePreviewUrl")) {
                    object.imagePreviewUrl = message.imagePreviewUrl;
                    if (options.oneofs)
                        object._imagePreviewUrl = "imagePreviewUrl";
                }
                if (message.imageHighResUrl != null && message.hasOwnProperty("imageHighResUrl")) {
                    object.imageHighResUrl = message.imageHighResUrl;
                    if (options.oneofs)
                        object._imageHighResUrl = "imageHighResUrl";
                }
                if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                    object.sourceUrl = message.sourceUrl;
                    if (options.oneofs)
                        object._sourceUrl = "sourceUrl";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseImageURL to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseImageURL.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseImageURL
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseImageURL
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseImageURL.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseImageURL";
            };

            return AIRichResponseImageURL;
        })();

        AIRichResponseMessage.AIRichResponseInlineImageMetadata = (function() {

            /**
             * Properties of a AIRichResponseInlineImageMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseInlineImageMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseImageURL|null} [imageUrl] AIRichResponseInlineImageMetadata imageUrl
             * @property {string|null} [imageText] AIRichResponseInlineImageMetadata imageText
             * @property {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment|null} [alignment] AIRichResponseInlineImageMetadata alignment
             * @property {string|null} [tapLinkUrl] AIRichResponseInlineImageMetadata tapLinkUrl
             */

            /**
             * Constructs a new AIRichResponseInlineImageMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseInlineImageMetadata.
             * @implements IAIRichResponseInlineImageMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata=} [properties] Properties to set
             */
            function AIRichResponseInlineImageMetadata(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseInlineImageMetadata imageUrl.
             * @member {proto.AIRichResponseMessage.IAIRichResponseImageURL|null|undefined} imageUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @instance
             */
            AIRichResponseInlineImageMetadata.prototype.imageUrl = null;

            /**
             * AIRichResponseInlineImageMetadata imageText.
             * @member {string|null|undefined} imageText
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @instance
             */
            AIRichResponseInlineImageMetadata.prototype.imageText = null;

            /**
             * AIRichResponseInlineImageMetadata alignment.
             * @member {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment|null|undefined} alignment
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @instance
             */
            AIRichResponseInlineImageMetadata.prototype.alignment = null;

            /**
             * AIRichResponseInlineImageMetadata tapLinkUrl.
             * @member {string|null|undefined} tapLinkUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @instance
             */
            AIRichResponseInlineImageMetadata.prototype.tapLinkUrl = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageUrl", {
                get: $util.oneOfGetter($oneOfFields = ["imageUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_imageText", {
                get: $util.oneOfGetter($oneOfFields = ["imageText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_alignment", {
                get: $util.oneOfGetter($oneOfFields = ["alignment"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseInlineImageMetadata.prototype, "_tapLinkUrl", {
                get: $util.oneOfGetter($oneOfFields = ["tapLinkUrl"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseInlineImageMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata} AIRichResponseInlineImageMetadata instance
             */
            AIRichResponseInlineImageMetadata.create = function create(properties) {
                return new AIRichResponseInlineImageMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseInlineImageMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata} message AIRichResponseInlineImageMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseInlineImageMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.imageUrl != null && Object.hasOwnProperty.call(message, "imageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(message.imageUrl, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                if (message.imageText != null && Object.hasOwnProperty.call(message, "imageText"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.imageText);
                if (message.alignment != null && Object.hasOwnProperty.call(message, "alignment"))
                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.alignment);
                if (message.tapLinkUrl != null && Object.hasOwnProperty.call(message, "tapLinkUrl"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.tapLinkUrl);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseInlineImageMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata} message AIRichResponseInlineImageMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseInlineImageMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseInlineImageMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata} AIRichResponseInlineImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseInlineImageMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(reader, reader.uint32());
                            break;
                        }
                    case 2: {
                            message.imageText = reader.string();
                            break;
                        }
                    case 3: {
                            message.alignment = reader.int32();
                            break;
                        }
                    case 4: {
                            message.tapLinkUrl = reader.string();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseInlineImageMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata} AIRichResponseInlineImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseInlineImageMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseInlineImageMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseInlineImageMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.imageUrl != null && message.hasOwnProperty("imageUrl")) {
                    properties._imageUrl = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.verify(message.imageUrl);
                        if (error)
                            return "imageUrl." + error;
                    }
                }
                if (message.imageText != null && message.hasOwnProperty("imageText")) {
                    properties._imageText = 1;
                    if (!$util.isString(message.imageText))
                        return "imageText: string expected";
                }
                if (message.alignment != null && message.hasOwnProperty("alignment")) {
                    properties._alignment = 1;
                    switch (message.alignment) {
                    default:
                        return "alignment: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                }
                if (message.tapLinkUrl != null && message.hasOwnProperty("tapLinkUrl")) {
                    properties._tapLinkUrl = 1;
                    if (!$util.isString(message.tapLinkUrl))
                        return "tapLinkUrl: string expected";
                }
                return null;
            };

            /**
             * Creates a AIRichResponseInlineImageMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata} AIRichResponseInlineImageMetadata
             */
            AIRichResponseInlineImageMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata();
                if (object.imageUrl != null) {
                    if (typeof object.imageUrl !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.imageUrl: object expected");
                    message.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.fromObject(object.imageUrl);
                }
                if (object.imageText != null)
                    message.imageText = String(object.imageText);
                switch (object.alignment) {
                default:
                    if (typeof object.alignment === "number") {
                        message.alignment = object.alignment;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED":
                case 0:
                    message.alignment = 0;
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED":
                case 1:
                    message.alignment = 1;
                    break;
                case "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED":
                case 2:
                    message.alignment = 2;
                    break;
                }
                if (object.tapLinkUrl != null)
                    message.tapLinkUrl = String(object.tapLinkUrl);
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseInlineImageMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata} message AIRichResponseInlineImageMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseInlineImageMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.imageUrl != null && message.hasOwnProperty("imageUrl")) {
                    object.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.toObject(message.imageUrl, options);
                    if (options.oneofs)
                        object._imageUrl = "imageUrl";
                }
                if (message.imageText != null && message.hasOwnProperty("imageText")) {
                    object.imageText = message.imageText;
                    if (options.oneofs)
                        object._imageText = "imageText";
                }
                if (message.alignment != null && message.hasOwnProperty("alignment")) {
                    object.alignment = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[message.alignment] === undefined ? message.alignment : $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment[message.alignment] : message.alignment;
                    if (options.oneofs)
                        object._alignment = "alignment";
                }
                if (message.tapLinkUrl != null && message.hasOwnProperty("tapLinkUrl")) {
                    object.tapLinkUrl = message.tapLinkUrl;
                    if (options.oneofs)
                        object._tapLinkUrl = "tapLinkUrl";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseInlineImageMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseInlineImageMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseInlineImageMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseInlineImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata";
            };

            /**
             * AIRichResponseImageAlignment enum.
             * @name proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment
             * @enum {number}
             * @property {number} AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED=0 AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED value
             * @property {number} AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED=1 AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED value
             * @property {number} AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED=2 AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED value
             */
            AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED"] = 2;
                return values;
            })();

            return AIRichResponseInlineImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseLatexMetadata = (function() {

            /**
             * Properties of a AIRichResponseLatexMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseLatexMetadata
             * @property {string|null} [text] AIRichResponseLatexMetadata text
             * @property {Array.<proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression>|null} [expressions] AIRichResponseLatexMetadata expressions
             */

            /**
             * Constructs a new AIRichResponseLatexMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseLatexMetadata.
             * @implements IAIRichResponseLatexMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata=} [properties] Properties to set
             */
            function AIRichResponseLatexMetadata(properties) {
                this.expressions = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseLatexMetadata text.
             * @member {string|null|undefined} text
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @instance
             */
            AIRichResponseLatexMetadata.prototype.text = null;

            /**
             * AIRichResponseLatexMetadata expressions.
             * @member {Array.<proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression>} expressions
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @instance
             */
            AIRichResponseLatexMetadata.prototype.expressions = $util.emptyArray;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseLatexMetadata.prototype, "_text", {
                get: $util.oneOfGetter($oneOfFields = ["text"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseLatexMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata} AIRichResponseLatexMetadata instance
             */
            AIRichResponseLatexMetadata.create = function create(properties) {
                return new AIRichResponseLatexMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseLatexMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata} message AIRichResponseLatexMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseLatexMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
                if (message.expressions != null && message.expressions.length)
                    for (let i = 0; i < message.expressions.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.encode(message.expressions[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseLatexMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata} message AIRichResponseLatexMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseLatexMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseLatexMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata} AIRichResponseLatexMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseLatexMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.text = reader.string();
                            break;
                        }
                    case 2: {
                            if (!(message.expressions && message.expressions.length))
                                message.expressions = [];
                            message.expressions.push($root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseLatexMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata} AIRichResponseLatexMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseLatexMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseLatexMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseLatexMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.text != null && message.hasOwnProperty("text")) {
                    properties._text = 1;
                    if (!$util.isString(message.text))
                        return "text: string expected";
                }
                if (message.expressions != null && message.hasOwnProperty("expressions")) {
                    if (!Array.isArray(message.expressions))
                        return "expressions: array expected";
                    for (let i = 0; i < message.expressions.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.verify(message.expressions[i]);
                        if (error)
                            return "expressions." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseLatexMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata} AIRichResponseLatexMetadata
             */
            AIRichResponseLatexMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata();
                if (object.text != null)
                    message.text = String(object.text);
                if (object.expressions) {
                    if (!Array.isArray(object.expressions))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseLatexMetadata.expressions: array expected");
                    message.expressions = [];
                    for (let i = 0; i < object.expressions.length; ++i) {
                        if (typeof object.expressions[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseLatexMetadata.expressions: object expected");
                        message.expressions[i] = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.fromObject(object.expressions[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseLatexMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata} message AIRichResponseLatexMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseLatexMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.expressions = [];
                if (message.text != null && message.hasOwnProperty("text")) {
                    object.text = message.text;
                    if (options.oneofs)
                        object._text = "text";
                }
                if (message.expressions && message.expressions.length) {
                    object.expressions = [];
                    for (let j = 0; j < message.expressions.length; ++j)
                        object.expressions[j] = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.toObject(message.expressions[j], options);
                }
                return object;
            };

            /**
             * Converts this AIRichResponseLatexMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseLatexMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseLatexMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseLatexMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata";
            };

            AIRichResponseLatexMetadata.AIRichResponseLatexExpression = (function() {

                /**
                 * Properties of a AIRichResponseLatexExpression.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
                 * @interface IAIRichResponseLatexExpression
                 * @property {string|null} [latexExpression] AIRichResponseLatexExpression latexExpression
                 * @property {string|null} [url] AIRichResponseLatexExpression url
                 * @property {number|null} [width] AIRichResponseLatexExpression width
                 * @property {number|null} [height] AIRichResponseLatexExpression height
                 * @property {number|null} [fontHeight] AIRichResponseLatexExpression fontHeight
                 * @property {number|null} [imageTopPadding] AIRichResponseLatexExpression imageTopPadding
                 * @property {number|null} [imageLeadingPadding] AIRichResponseLatexExpression imageLeadingPadding
                 * @property {number|null} [imageBottomPadding] AIRichResponseLatexExpression imageBottomPadding
                 * @property {number|null} [imageTrailingPadding] AIRichResponseLatexExpression imageTrailingPadding
                 */

                /**
                 * Constructs a new AIRichResponseLatexExpression.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata
                 * @classdesc Represents a AIRichResponseLatexExpression.
                 * @implements IAIRichResponseLatexExpression
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression=} [properties] Properties to set
                 */
                function AIRichResponseLatexExpression(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseLatexExpression latexExpression.
                 * @member {string|null|undefined} latexExpression
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.latexExpression = null;

                /**
                 * AIRichResponseLatexExpression url.
                 * @member {string|null|undefined} url
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.url = null;

                /**
                 * AIRichResponseLatexExpression width.
                 * @member {number|null|undefined} width
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.width = null;

                /**
                 * AIRichResponseLatexExpression height.
                 * @member {number|null|undefined} height
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.height = null;

                /**
                 * AIRichResponseLatexExpression fontHeight.
                 * @member {number|null|undefined} fontHeight
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.fontHeight = null;

                /**
                 * AIRichResponseLatexExpression imageTopPadding.
                 * @member {number|null|undefined} imageTopPadding
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.imageTopPadding = null;

                /**
                 * AIRichResponseLatexExpression imageLeadingPadding.
                 * @member {number|null|undefined} imageLeadingPadding
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.imageLeadingPadding = null;

                /**
                 * AIRichResponseLatexExpression imageBottomPadding.
                 * @member {number|null|undefined} imageBottomPadding
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.imageBottomPadding = null;

                /**
                 * AIRichResponseLatexExpression imageTrailingPadding.
                 * @member {number|null|undefined} imageTrailingPadding
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 */
                AIRichResponseLatexExpression.prototype.imageTrailingPadding = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_latexExpression", {
                    get: $util.oneOfGetter($oneOfFields = ["latexExpression"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_url", {
                    get: $util.oneOfGetter($oneOfFields = ["url"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_width", {
                    get: $util.oneOfGetter($oneOfFields = ["width"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_height", {
                    get: $util.oneOfGetter($oneOfFields = ["height"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_fontHeight", {
                    get: $util.oneOfGetter($oneOfFields = ["fontHeight"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTopPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageTopPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageLeadingPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageLeadingPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageBottomPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageBottomPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseLatexExpression.prototype, "_imageTrailingPadding", {
                    get: $util.oneOfGetter($oneOfFields = ["imageTrailingPadding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseLatexExpression instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression} AIRichResponseLatexExpression instance
                 */
                AIRichResponseLatexExpression.create = function create(properties) {
                    return new AIRichResponseLatexExpression(properties);
                };

                /**
                 * Encodes the specified AIRichResponseLatexExpression message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression} message AIRichResponseLatexExpression message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseLatexExpression.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.latexExpression != null && Object.hasOwnProperty.call(message, "latexExpression"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.latexExpression);
                    if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.url);
                    if (message.width != null && Object.hasOwnProperty.call(message, "width"))
                        writer.uint32(/* id 3, wireType 1 =*/25).double(message.width);
                    if (message.height != null && Object.hasOwnProperty.call(message, "height"))
                        writer.uint32(/* id 4, wireType 1 =*/33).double(message.height);
                    if (message.fontHeight != null && Object.hasOwnProperty.call(message, "fontHeight"))
                        writer.uint32(/* id 5, wireType 1 =*/41).double(message.fontHeight);
                    if (message.imageTopPadding != null && Object.hasOwnProperty.call(message, "imageTopPadding"))
                        writer.uint32(/* id 6, wireType 1 =*/49).double(message.imageTopPadding);
                    if (message.imageLeadingPadding != null && Object.hasOwnProperty.call(message, "imageLeadingPadding"))
                        writer.uint32(/* id 7, wireType 1 =*/57).double(message.imageLeadingPadding);
                    if (message.imageBottomPadding != null && Object.hasOwnProperty.call(message, "imageBottomPadding"))
                        writer.uint32(/* id 8, wireType 1 =*/65).double(message.imageBottomPadding);
                    if (message.imageTrailingPadding != null && Object.hasOwnProperty.call(message, "imageTrailingPadding"))
                        writer.uint32(/* id 9, wireType 1 =*/73).double(message.imageTrailingPadding);
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseLatexExpression message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression} message AIRichResponseLatexExpression message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseLatexExpression.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseLatexExpression message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression} AIRichResponseLatexExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseLatexExpression.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.latexExpression = reader.string();
                                break;
                            }
                        case 2: {
                                message.url = reader.string();
                                break;
                            }
                        case 3: {
                                message.width = reader.double();
                                break;
                            }
                        case 4: {
                                message.height = reader.double();
                                break;
                            }
                        case 5: {
                                message.fontHeight = reader.double();
                                break;
                            }
                        case 6: {
                                message.imageTopPadding = reader.double();
                                break;
                            }
                        case 7: {
                                message.imageLeadingPadding = reader.double();
                                break;
                            }
                        case 8: {
                                message.imageBottomPadding = reader.double();
                                break;
                            }
                        case 9: {
                                message.imageTrailingPadding = reader.double();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseLatexExpression message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression} AIRichResponseLatexExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseLatexExpression.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseLatexExpression message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseLatexExpression.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.latexExpression != null && message.hasOwnProperty("latexExpression")) {
                        properties._latexExpression = 1;
                        if (!$util.isString(message.latexExpression))
                            return "latexExpression: string expected";
                    }
                    if (message.url != null && message.hasOwnProperty("url")) {
                        properties._url = 1;
                        if (!$util.isString(message.url))
                            return "url: string expected";
                    }
                    if (message.width != null && message.hasOwnProperty("width")) {
                        properties._width = 1;
                        if (typeof message.width !== "number")
                            return "width: number expected";
                    }
                    if (message.height != null && message.hasOwnProperty("height")) {
                        properties._height = 1;
                        if (typeof message.height !== "number")
                            return "height: number expected";
                    }
                    if (message.fontHeight != null && message.hasOwnProperty("fontHeight")) {
                        properties._fontHeight = 1;
                        if (typeof message.fontHeight !== "number")
                            return "fontHeight: number expected";
                    }
                    if (message.imageTopPadding != null && message.hasOwnProperty("imageTopPadding")) {
                        properties._imageTopPadding = 1;
                        if (typeof message.imageTopPadding !== "number")
                            return "imageTopPadding: number expected";
                    }
                    if (message.imageLeadingPadding != null && message.hasOwnProperty("imageLeadingPadding")) {
                        properties._imageLeadingPadding = 1;
                        if (typeof message.imageLeadingPadding !== "number")
                            return "imageLeadingPadding: number expected";
                    }
                    if (message.imageBottomPadding != null && message.hasOwnProperty("imageBottomPadding")) {
                        properties._imageBottomPadding = 1;
                        if (typeof message.imageBottomPadding !== "number")
                            return "imageBottomPadding: number expected";
                    }
                    if (message.imageTrailingPadding != null && message.hasOwnProperty("imageTrailingPadding")) {
                        properties._imageTrailingPadding = 1;
                        if (typeof message.imageTrailingPadding !== "number")
                            return "imageTrailingPadding: number expected";
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseLatexExpression message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression} AIRichResponseLatexExpression
                 */
                AIRichResponseLatexExpression.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                    if (object.latexExpression != null)
                        message.latexExpression = String(object.latexExpression);
                    if (object.url != null)
                        message.url = String(object.url);
                    if (object.width != null)
                        message.width = Number(object.width);
                    if (object.height != null)
                        message.height = Number(object.height);
                    if (object.fontHeight != null)
                        message.fontHeight = Number(object.fontHeight);
                    if (object.imageTopPadding != null)
                        message.imageTopPadding = Number(object.imageTopPadding);
                    if (object.imageLeadingPadding != null)
                        message.imageLeadingPadding = Number(object.imageLeadingPadding);
                    if (object.imageBottomPadding != null)
                        message.imageBottomPadding = Number(object.imageBottomPadding);
                    if (object.imageTrailingPadding != null)
                        message.imageTrailingPadding = Number(object.imageTrailingPadding);
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseLatexExpression message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression} message AIRichResponseLatexExpression
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseLatexExpression.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.latexExpression != null && message.hasOwnProperty("latexExpression")) {
                        object.latexExpression = message.latexExpression;
                        if (options.oneofs)
                            object._latexExpression = "latexExpression";
                    }
                    if (message.url != null && message.hasOwnProperty("url")) {
                        object.url = message.url;
                        if (options.oneofs)
                            object._url = "url";
                    }
                    if (message.width != null && message.hasOwnProperty("width")) {
                        object.width = options.json && !isFinite(message.width) ? String(message.width) : message.width;
                        if (options.oneofs)
                            object._width = "width";
                    }
                    if (message.height != null && message.hasOwnProperty("height")) {
                        object.height = options.json && !isFinite(message.height) ? String(message.height) : message.height;
                        if (options.oneofs)
                            object._height = "height";
                    }
                    if (message.fontHeight != null && message.hasOwnProperty("fontHeight")) {
                        object.fontHeight = options.json && !isFinite(message.fontHeight) ? String(message.fontHeight) : message.fontHeight;
                        if (options.oneofs)
                            object._fontHeight = "fontHeight";
                    }
                    if (message.imageTopPadding != null && message.hasOwnProperty("imageTopPadding")) {
                        object.imageTopPadding = options.json && !isFinite(message.imageTopPadding) ? String(message.imageTopPadding) : message.imageTopPadding;
                        if (options.oneofs)
                            object._imageTopPadding = "imageTopPadding";
                    }
                    if (message.imageLeadingPadding != null && message.hasOwnProperty("imageLeadingPadding")) {
                        object.imageLeadingPadding = options.json && !isFinite(message.imageLeadingPadding) ? String(message.imageLeadingPadding) : message.imageLeadingPadding;
                        if (options.oneofs)
                            object._imageLeadingPadding = "imageLeadingPadding";
                    }
                    if (message.imageBottomPadding != null && message.hasOwnProperty("imageBottomPadding")) {
                        object.imageBottomPadding = options.json && !isFinite(message.imageBottomPadding) ? String(message.imageBottomPadding) : message.imageBottomPadding;
                        if (options.oneofs)
                            object._imageBottomPadding = "imageBottomPadding";
                    }
                    if (message.imageTrailingPadding != null && message.hasOwnProperty("imageTrailingPadding")) {
                        object.imageTrailingPadding = options.json && !isFinite(message.imageTrailingPadding) ? String(message.imageTrailingPadding) : message.imageTrailingPadding;
                        if (options.oneofs)
                            object._imageTrailingPadding = "imageTrailingPadding";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseLatexExpression to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseLatexExpression.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseLatexExpression
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseLatexExpression.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression";
                };

                return AIRichResponseLatexExpression;
            })();

            return AIRichResponseLatexMetadata;
        })();

        AIRichResponseMessage.AIRichResponseMapMetadata = (function() {

            /**
             * Properties of a AIRichResponseMapMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseMapMetadata
             * @property {number|null} [centerLatitude] AIRichResponseMapMetadata centerLatitude
             * @property {number|null} [centerLongitude] AIRichResponseMapMetadata centerLongitude
             * @property {number|null} [latitudeDelta] AIRichResponseMapMetadata latitudeDelta
             * @property {number|null} [longitudeDelta] AIRichResponseMapMetadata longitudeDelta
             * @property {Array.<proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation>|null} [annotations] AIRichResponseMapMetadata annotations
             * @property {boolean|null} [showInfoList] AIRichResponseMapMetadata showInfoList
             */

            /**
             * Constructs a new AIRichResponseMapMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseMapMetadata.
             * @implements IAIRichResponseMapMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseMapMetadata=} [properties] Properties to set
             */
            function AIRichResponseMapMetadata(properties) {
                this.annotations = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseMapMetadata centerLatitude.
             * @member {number|null|undefined} centerLatitude
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.centerLatitude = null;

            /**
             * AIRichResponseMapMetadata centerLongitude.
             * @member {number|null|undefined} centerLongitude
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.centerLongitude = null;

            /**
             * AIRichResponseMapMetadata latitudeDelta.
             * @member {number|null|undefined} latitudeDelta
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.latitudeDelta = null;

            /**
             * AIRichResponseMapMetadata longitudeDelta.
             * @member {number|null|undefined} longitudeDelta
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.longitudeDelta = null;

            /**
             * AIRichResponseMapMetadata annotations.
             * @member {Array.<proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation>} annotations
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.annotations = $util.emptyArray;

            /**
             * AIRichResponseMapMetadata showInfoList.
             * @member {boolean|null|undefined} showInfoList
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             */
            AIRichResponseMapMetadata.prototype.showInfoList = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLatitude", {
                get: $util.oneOfGetter($oneOfFields = ["centerLatitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_centerLongitude", {
                get: $util.oneOfGetter($oneOfFields = ["centerLongitude"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_latitudeDelta", {
                get: $util.oneOfGetter($oneOfFields = ["latitudeDelta"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_longitudeDelta", {
                get: $util.oneOfGetter($oneOfFields = ["longitudeDelta"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseMapMetadata.prototype, "_showInfoList", {
                get: $util.oneOfGetter($oneOfFields = ["showInfoList"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseMapMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseMapMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata} AIRichResponseMapMetadata instance
             */
            AIRichResponseMapMetadata.create = function create(properties) {
                return new AIRichResponseMapMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseMapMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseMapMetadata} message AIRichResponseMapMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseMapMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.centerLatitude != null && Object.hasOwnProperty.call(message, "centerLatitude"))
                    writer.uint32(/* id 1, wireType 1 =*/9).double(message.centerLatitude);
                if (message.centerLongitude != null && Object.hasOwnProperty.call(message, "centerLongitude"))
                    writer.uint32(/* id 2, wireType 1 =*/17).double(message.centerLongitude);
                if (message.latitudeDelta != null && Object.hasOwnProperty.call(message, "latitudeDelta"))
                    writer.uint32(/* id 3, wireType 1 =*/25).double(message.latitudeDelta);
                if (message.longitudeDelta != null && Object.hasOwnProperty.call(message, "longitudeDelta"))
                    writer.uint32(/* id 4, wireType 1 =*/33).double(message.longitudeDelta);
                if (message.annotations != null && message.annotations.length)
                    for (let i = 0; i < message.annotations.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.encode(message.annotations[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.showInfoList != null && Object.hasOwnProperty.call(message, "showInfoList"))
                    writer.uint32(/* id 6, wireType 0 =*/48).bool(message.showInfoList);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseMapMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseMapMetadata} message AIRichResponseMapMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseMapMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseMapMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata} AIRichResponseMapMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseMapMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.centerLatitude = reader.double();
                            break;
                        }
                    case 2: {
                            message.centerLongitude = reader.double();
                            break;
                        }
                    case 3: {
                            message.latitudeDelta = reader.double();
                            break;
                        }
                    case 4: {
                            message.longitudeDelta = reader.double();
                            break;
                        }
                    case 5: {
                            if (!(message.annotations && message.annotations.length))
                                message.annotations = [];
                            message.annotations.push($root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.decode(reader, reader.uint32()));
                            break;
                        }
                    case 6: {
                            message.showInfoList = reader.bool();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseMapMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata} AIRichResponseMapMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseMapMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseMapMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseMapMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.centerLatitude != null && message.hasOwnProperty("centerLatitude")) {
                    properties._centerLatitude = 1;
                    if (typeof message.centerLatitude !== "number")
                        return "centerLatitude: number expected";
                }
                if (message.centerLongitude != null && message.hasOwnProperty("centerLongitude")) {
                    properties._centerLongitude = 1;
                    if (typeof message.centerLongitude !== "number")
                        return "centerLongitude: number expected";
                }
                if (message.latitudeDelta != null && message.hasOwnProperty("latitudeDelta")) {
                    properties._latitudeDelta = 1;
                    if (typeof message.latitudeDelta !== "number")
                        return "latitudeDelta: number expected";
                }
                if (message.longitudeDelta != null && message.hasOwnProperty("longitudeDelta")) {
                    properties._longitudeDelta = 1;
                    if (typeof message.longitudeDelta !== "number")
                        return "longitudeDelta: number expected";
                }
                if (message.annotations != null && message.hasOwnProperty("annotations")) {
                    if (!Array.isArray(message.annotations))
                        return "annotations: array expected";
                    for (let i = 0; i < message.annotations.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.verify(message.annotations[i]);
                        if (error)
                            return "annotations." + error;
                    }
                }
                if (message.showInfoList != null && message.hasOwnProperty("showInfoList")) {
                    properties._showInfoList = 1;
                    if (typeof message.showInfoList !== "boolean")
                        return "showInfoList: boolean expected";
                }
                return null;
            };

            /**
             * Creates a AIRichResponseMapMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata} AIRichResponseMapMetadata
             */
            AIRichResponseMapMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata();
                if (object.centerLatitude != null)
                    message.centerLatitude = Number(object.centerLatitude);
                if (object.centerLongitude != null)
                    message.centerLongitude = Number(object.centerLongitude);
                if (object.latitudeDelta != null)
                    message.latitudeDelta = Number(object.latitudeDelta);
                if (object.longitudeDelta != null)
                    message.longitudeDelta = Number(object.longitudeDelta);
                if (object.annotations) {
                    if (!Array.isArray(object.annotations))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseMapMetadata.annotations: array expected");
                    message.annotations = [];
                    for (let i = 0; i < object.annotations.length; ++i) {
                        if (typeof object.annotations[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseMapMetadata.annotations: object expected");
                        message.annotations[i] = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.fromObject(object.annotations[i]);
                    }
                }
                if (object.showInfoList != null)
                    message.showInfoList = Boolean(object.showInfoList);
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseMapMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata} message AIRichResponseMapMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseMapMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.annotations = [];
                if (message.centerLatitude != null && message.hasOwnProperty("centerLatitude")) {
                    object.centerLatitude = options.json && !isFinite(message.centerLatitude) ? String(message.centerLatitude) : message.centerLatitude;
                    if (options.oneofs)
                        object._centerLatitude = "centerLatitude";
                }
                if (message.centerLongitude != null && message.hasOwnProperty("centerLongitude")) {
                    object.centerLongitude = options.json && !isFinite(message.centerLongitude) ? String(message.centerLongitude) : message.centerLongitude;
                    if (options.oneofs)
                        object._centerLongitude = "centerLongitude";
                }
                if (message.latitudeDelta != null && message.hasOwnProperty("latitudeDelta")) {
                    object.latitudeDelta = options.json && !isFinite(message.latitudeDelta) ? String(message.latitudeDelta) : message.latitudeDelta;
                    if (options.oneofs)
                        object._latitudeDelta = "latitudeDelta";
                }
                if (message.longitudeDelta != null && message.hasOwnProperty("longitudeDelta")) {
                    object.longitudeDelta = options.json && !isFinite(message.longitudeDelta) ? String(message.longitudeDelta) : message.longitudeDelta;
                    if (options.oneofs)
                        object._longitudeDelta = "longitudeDelta";
                }
                if (message.annotations && message.annotations.length) {
                    object.annotations = [];
                    for (let j = 0; j < message.annotations.length; ++j)
                        object.annotations[j] = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.toObject(message.annotations[j], options);
                }
                if (message.showInfoList != null && message.hasOwnProperty("showInfoList")) {
                    object.showInfoList = message.showInfoList;
                    if (options.oneofs)
                        object._showInfoList = "showInfoList";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseMapMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseMapMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseMapMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseMapMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata";
            };

            AIRichResponseMapMetadata.AIRichResponseMapAnnotation = (function() {

                /**
                 * Properties of a AIRichResponseMapAnnotation.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
                 * @interface IAIRichResponseMapAnnotation
                 * @property {number|null} [annotationNumber] AIRichResponseMapAnnotation annotationNumber
                 * @property {number|null} [latitude] AIRichResponseMapAnnotation latitude
                 * @property {number|null} [longitude] AIRichResponseMapAnnotation longitude
                 * @property {string|null} [title] AIRichResponseMapAnnotation title
                 * @property {string|null} [body] AIRichResponseMapAnnotation body
                 */

                /**
                 * Constructs a new AIRichResponseMapAnnotation.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata
                 * @classdesc Represents a AIRichResponseMapAnnotation.
                 * @implements IAIRichResponseMapAnnotation
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation=} [properties] Properties to set
                 */
                function AIRichResponseMapAnnotation(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseMapAnnotation annotationNumber.
                 * @member {number|null|undefined} annotationNumber
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 */
                AIRichResponseMapAnnotation.prototype.annotationNumber = null;

                /**
                 * AIRichResponseMapAnnotation latitude.
                 * @member {number|null|undefined} latitude
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 */
                AIRichResponseMapAnnotation.prototype.latitude = null;

                /**
                 * AIRichResponseMapAnnotation longitude.
                 * @member {number|null|undefined} longitude
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 */
                AIRichResponseMapAnnotation.prototype.longitude = null;

                /**
                 * AIRichResponseMapAnnotation title.
                 * @member {string|null|undefined} title
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 */
                AIRichResponseMapAnnotation.prototype.title = null;

                /**
                 * AIRichResponseMapAnnotation body.
                 * @member {string|null|undefined} body
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 */
                AIRichResponseMapAnnotation.prototype.body = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_annotationNumber", {
                    get: $util.oneOfGetter($oneOfFields = ["annotationNumber"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_latitude", {
                    get: $util.oneOfGetter($oneOfFields = ["latitude"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_longitude", {
                    get: $util.oneOfGetter($oneOfFields = ["longitude"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseMapAnnotation.prototype, "_body", {
                    get: $util.oneOfGetter($oneOfFields = ["body"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseMapAnnotation instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation} AIRichResponseMapAnnotation instance
                 */
                AIRichResponseMapAnnotation.create = function create(properties) {
                    return new AIRichResponseMapAnnotation(properties);
                };

                /**
                 * Encodes the specified AIRichResponseMapAnnotation message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation} message AIRichResponseMapAnnotation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseMapAnnotation.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.annotationNumber != null && Object.hasOwnProperty.call(message, "annotationNumber"))
                        writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.annotationNumber);
                    if (message.latitude != null && Object.hasOwnProperty.call(message, "latitude"))
                        writer.uint32(/* id 2, wireType 1 =*/17).double(message.latitude);
                    if (message.longitude != null && Object.hasOwnProperty.call(message, "longitude"))
                        writer.uint32(/* id 3, wireType 1 =*/25).double(message.longitude);
                    if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.title);
                    if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.body);
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseMapAnnotation message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation} message AIRichResponseMapAnnotation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseMapAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseMapAnnotation message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation} AIRichResponseMapAnnotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseMapAnnotation.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.annotationNumber = reader.uint32();
                                break;
                            }
                        case 2: {
                                message.latitude = reader.double();
                                break;
                            }
                        case 3: {
                                message.longitude = reader.double();
                                break;
                            }
                        case 4: {
                                message.title = reader.string();
                                break;
                            }
                        case 5: {
                                message.body = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseMapAnnotation message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation} AIRichResponseMapAnnotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseMapAnnotation.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseMapAnnotation message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseMapAnnotation.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.annotationNumber != null && message.hasOwnProperty("annotationNumber")) {
                        properties._annotationNumber = 1;
                        if (!$util.isInteger(message.annotationNumber))
                            return "annotationNumber: integer expected";
                    }
                    if (message.latitude != null && message.hasOwnProperty("latitude")) {
                        properties._latitude = 1;
                        if (typeof message.latitude !== "number")
                            return "latitude: number expected";
                    }
                    if (message.longitude != null && message.hasOwnProperty("longitude")) {
                        properties._longitude = 1;
                        if (typeof message.longitude !== "number")
                            return "longitude: number expected";
                    }
                    if (message.title != null && message.hasOwnProperty("title")) {
                        properties._title = 1;
                        if (!$util.isString(message.title))
                            return "title: string expected";
                    }
                    if (message.body != null && message.hasOwnProperty("body")) {
                        properties._body = 1;
                        if (!$util.isString(message.body))
                            return "body: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseMapAnnotation message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation} AIRichResponseMapAnnotation
                 */
                AIRichResponseMapAnnotation.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                    if (object.annotationNumber != null)
                        message.annotationNumber = object.annotationNumber >>> 0;
                    if (object.latitude != null)
                        message.latitude = Number(object.latitude);
                    if (object.longitude != null)
                        message.longitude = Number(object.longitude);
                    if (object.title != null)
                        message.title = String(object.title);
                    if (object.body != null)
                        message.body = String(object.body);
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseMapAnnotation message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation} message AIRichResponseMapAnnotation
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseMapAnnotation.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.annotationNumber != null && message.hasOwnProperty("annotationNumber")) {
                        object.annotationNumber = message.annotationNumber;
                        if (options.oneofs)
                            object._annotationNumber = "annotationNumber";
                    }
                    if (message.latitude != null && message.hasOwnProperty("latitude")) {
                        object.latitude = options.json && !isFinite(message.latitude) ? String(message.latitude) : message.latitude;
                        if (options.oneofs)
                            object._latitude = "latitude";
                    }
                    if (message.longitude != null && message.hasOwnProperty("longitude")) {
                        object.longitude = options.json && !isFinite(message.longitude) ? String(message.longitude) : message.longitude;
                        if (options.oneofs)
                            object._longitude = "longitude";
                    }
                    if (message.title != null && message.hasOwnProperty("title")) {
                        object.title = message.title;
                        if (options.oneofs)
                            object._title = "title";
                    }
                    if (message.body != null && message.hasOwnProperty("body")) {
                        object.body = message.body;
                        if (options.oneofs)
                            object._body = "body";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseMapAnnotation to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseMapAnnotation.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseMapAnnotation
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseMapAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation";
                };

                return AIRichResponseMapAnnotation;
            })();

            return AIRichResponseMapMetadata;
        })();

        /**
         * AIRichResponseMessageType enum.
         * @name proto.AIRichResponseMessage.AIRichResponseMessageType
         * @enum {number}
         * @property {number} AI_RICH_RESPONSE_TYPE_UNKNOWN=0 AI_RICH_RESPONSE_TYPE_UNKNOWN value
         * @property {number} AI_RICH_RESPONSE_TYPE_STANDARD=1 AI_RICH_RESPONSE_TYPE_STANDARD value
         */
        AIRichResponseMessage.AIRichResponseMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_TYPE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_TYPE_STANDARD"] = 1;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseSubMessage = (function() {

            /**
             * Properties of a AIRichResponseSubMessage.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseSubMessage
             * @property {proto.AIRichResponseMessage.AIRichResponseSubMessageType|null} [messageType] AIRichResponseSubMessage messageType
             * @property {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata|null} [gridImageMetadata] AIRichResponseSubMessage gridImageMetadata
             * @property {string|null} [messageText] AIRichResponseSubMessage messageText
             * @property {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata|null} [imageMetadata] AIRichResponseSubMessage imageMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata|null} [codeMetadata] AIRichResponseSubMessage codeMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseTableMetadata|null} [tableMetadata] AIRichResponseSubMessage tableMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata|null} [dynamicMetadata] AIRichResponseSubMessage dynamicMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata|null} [latexMetadata] AIRichResponseSubMessage latexMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseMapMetadata|null} [mapMetadata] AIRichResponseSubMessage mapMetadata
             * @property {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata|null} [contentItemsMetadata] AIRichResponseSubMessage contentItemsMetadata
             */

            /**
             * Constructs a new AIRichResponseSubMessage.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseSubMessage.
             * @implements IAIRichResponseSubMessage
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseSubMessage=} [properties] Properties to set
             */
            function AIRichResponseSubMessage(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseSubMessage messageType.
             * @member {proto.AIRichResponseMessage.AIRichResponseSubMessageType|null|undefined} messageType
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.messageType = null;

            /**
             * AIRichResponseSubMessage gridImageMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata|null|undefined} gridImageMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.gridImageMetadata = null;

            /**
             * AIRichResponseSubMessage messageText.
             * @member {string|null|undefined} messageText
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.messageText = null;

            /**
             * AIRichResponseSubMessage imageMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata|null|undefined} imageMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.imageMetadata = null;

            /**
             * AIRichResponseSubMessage codeMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseCodeMetadata|null|undefined} codeMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.codeMetadata = null;

            /**
             * AIRichResponseSubMessage tableMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseTableMetadata|null|undefined} tableMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.tableMetadata = null;

            /**
             * AIRichResponseSubMessage dynamicMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata|null|undefined} dynamicMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.dynamicMetadata = null;

            /**
             * AIRichResponseSubMessage latexMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseLatexMetadata|null|undefined} latexMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.latexMetadata = null;

            /**
             * AIRichResponseSubMessage mapMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseMapMetadata|null|undefined} mapMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.mapMetadata = null;

            /**
             * AIRichResponseSubMessage contentItemsMetadata.
             * @member {proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata|null|undefined} contentItemsMetadata
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             */
            AIRichResponseSubMessage.prototype.contentItemsMetadata = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageType", {
                get: $util.oneOfGetter($oneOfFields = ["messageType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_gridImageMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["gridImageMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_messageText", {
                get: $util.oneOfGetter($oneOfFields = ["messageText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_imageMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["imageMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_codeMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["codeMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_tableMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["tableMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_dynamicMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["dynamicMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_latexMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["latexMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_mapMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["mapMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseSubMessage.prototype, "_contentItemsMetadata", {
                get: $util.oneOfGetter($oneOfFields = ["contentItemsMetadata"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseSubMessage instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseSubMessage=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseSubMessage} AIRichResponseSubMessage instance
             */
            AIRichResponseSubMessage.create = function create(properties) {
                return new AIRichResponseSubMessage(properties);
            };

            /**
             * Encodes the specified AIRichResponseSubMessage message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseSubMessage.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseSubMessage} message AIRichResponseSubMessage message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseSubMessage.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.messageType != null && Object.hasOwnProperty.call(message, "messageType"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.messageType);
                if (message.gridImageMetadata != null && Object.hasOwnProperty.call(message, "gridImageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.encode(message.gridImageMetadata, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.messageText != null && Object.hasOwnProperty.call(message, "messageText"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.messageText);
                if (message.imageMetadata != null && Object.hasOwnProperty.call(message, "imageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.encode(message.imageMetadata, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                if (message.codeMetadata != null && Object.hasOwnProperty.call(message, "codeMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.encode(message.codeMetadata, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                if (message.tableMetadata != null && Object.hasOwnProperty.call(message, "tableMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.encode(message.tableMetadata, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                if (message.dynamicMetadata != null && Object.hasOwnProperty.call(message, "dynamicMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.encode(message.dynamicMetadata, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                if (message.latexMetadata != null && Object.hasOwnProperty.call(message, "latexMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.encode(message.latexMetadata, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                if (message.mapMetadata != null && Object.hasOwnProperty.call(message, "mapMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.encode(message.mapMetadata, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                if (message.contentItemsMetadata != null && Object.hasOwnProperty.call(message, "contentItemsMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.encode(message.contentItemsMetadata, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseSubMessage message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseSubMessage.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseSubMessage} message AIRichResponseSubMessage message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseSubMessage.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseSubMessage message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseSubMessage} AIRichResponseSubMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseSubMessage.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseSubMessage();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.messageType = reader.int32();
                            break;
                        }
                    case 2: {
                            message.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 3: {
                            message.messageText = reader.string();
                            break;
                        }
                    case 4: {
                            message.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 5: {
                            message.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 6: {
                            message.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 7: {
                            message.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 8: {
                            message.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 9: {
                            message.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    case 10: {
                            message.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.decode(reader, reader.uint32());
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseSubMessage message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseSubMessage} AIRichResponseSubMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseSubMessage.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseSubMessage message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseSubMessage.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.messageType != null && message.hasOwnProperty("messageType")) {
                    properties._messageType = 1;
                    switch (message.messageType) {
                    default:
                        return "messageType: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                        break;
                    }
                }
                if (message.gridImageMetadata != null && message.hasOwnProperty("gridImageMetadata")) {
                    properties._gridImageMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.verify(message.gridImageMetadata);
                        if (error)
                            return "gridImageMetadata." + error;
                    }
                }
                if (message.messageText != null && message.hasOwnProperty("messageText")) {
                    properties._messageText = 1;
                    if (!$util.isString(message.messageText))
                        return "messageText: string expected";
                }
                if (message.imageMetadata != null && message.hasOwnProperty("imageMetadata")) {
                    properties._imageMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.verify(message.imageMetadata);
                        if (error)
                            return "imageMetadata." + error;
                    }
                }
                if (message.codeMetadata != null && message.hasOwnProperty("codeMetadata")) {
                    properties._codeMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.verify(message.codeMetadata);
                        if (error)
                            return "codeMetadata." + error;
                    }
                }
                if (message.tableMetadata != null && message.hasOwnProperty("tableMetadata")) {
                    properties._tableMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.verify(message.tableMetadata);
                        if (error)
                            return "tableMetadata." + error;
                    }
                }
                if (message.dynamicMetadata != null && message.hasOwnProperty("dynamicMetadata")) {
                    properties._dynamicMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.verify(message.dynamicMetadata);
                        if (error)
                            return "dynamicMetadata." + error;
                    }
                }
                if (message.latexMetadata != null && message.hasOwnProperty("latexMetadata")) {
                    properties._latexMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.verify(message.latexMetadata);
                        if (error)
                            return "latexMetadata." + error;
                    }
                }
                if (message.mapMetadata != null && message.hasOwnProperty("mapMetadata")) {
                    properties._mapMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.verify(message.mapMetadata);
                        if (error)
                            return "mapMetadata." + error;
                    }
                }
                if (message.contentItemsMetadata != null && message.hasOwnProperty("contentItemsMetadata")) {
                    properties._contentItemsMetadata = 1;
                    {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.verify(message.contentItemsMetadata);
                        if (error)
                            return "contentItemsMetadata." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseSubMessage message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseSubMessage} AIRichResponseSubMessage
             */
            AIRichResponseSubMessage.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseSubMessage)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseSubMessage();
                switch (object.messageType) {
                default:
                    if (typeof object.messageType === "number") {
                        message.messageType = object.messageType;
                        break;
                    }
                    break;
                case "AI_RICH_RESPONSE_UNKNOWN":
                case 0:
                    message.messageType = 0;
                    break;
                case "AI_RICH_RESPONSE_GRID_IMAGE":
                case 1:
                    message.messageType = 1;
                    break;
                case "AI_RICH_RESPONSE_TEXT":
                case 2:
                    message.messageType = 2;
                    break;
                case "AI_RICH_RESPONSE_INLINE_IMAGE":
                case 3:
                    message.messageType = 3;
                    break;
                case "AI_RICH_RESPONSE_TABLE":
                case 4:
                    message.messageType = 4;
                    break;
                case "AI_RICH_RESPONSE_CODE":
                case 5:
                    message.messageType = 5;
                    break;
                case "AI_RICH_RESPONSE_DYNAMIC":
                case 6:
                    message.messageType = 6;
                    break;
                case "AI_RICH_RESPONSE_MAP":
                case 7:
                    message.messageType = 7;
                    break;
                case "AI_RICH_RESPONSE_LATEX":
                case 8:
                    message.messageType = 8;
                    break;
                case "AI_RICH_RESPONSE_CONTENT_ITEMS":
                case 9:
                    message.messageType = 9;
                    break;
                }
                if (object.gridImageMetadata != null) {
                    if (typeof object.gridImageMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.gridImageMetadata: object expected");
                    message.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.fromObject(object.gridImageMetadata);
                }
                if (object.messageText != null)
                    message.messageText = String(object.messageText);
                if (object.imageMetadata != null) {
                    if (typeof object.imageMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.imageMetadata: object expected");
                    message.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.fromObject(object.imageMetadata);
                }
                if (object.codeMetadata != null) {
                    if (typeof object.codeMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.codeMetadata: object expected");
                    message.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.fromObject(object.codeMetadata);
                }
                if (object.tableMetadata != null) {
                    if (typeof object.tableMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.tableMetadata: object expected");
                    message.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.fromObject(object.tableMetadata);
                }
                if (object.dynamicMetadata != null) {
                    if (typeof object.dynamicMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.dynamicMetadata: object expected");
                    message.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.fromObject(object.dynamicMetadata);
                }
                if (object.latexMetadata != null) {
                    if (typeof object.latexMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.latexMetadata: object expected");
                    message.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.fromObject(object.latexMetadata);
                }
                if (object.mapMetadata != null) {
                    if (typeof object.mapMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.mapMetadata: object expected");
                    message.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.fromObject(object.mapMetadata);
                }
                if (object.contentItemsMetadata != null) {
                    if (typeof object.contentItemsMetadata !== "object")
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseSubMessage.contentItemsMetadata: object expected");
                    message.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.fromObject(object.contentItemsMetadata);
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseSubMessage message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseSubMessage} message AIRichResponseSubMessage
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseSubMessage.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.messageType != null && message.hasOwnProperty("messageType")) {
                    object.messageType = options.enums === String ? $root.proto.AIRichResponseMessage.AIRichResponseSubMessageType[message.messageType] === undefined ? message.messageType : $root.proto.AIRichResponseMessage.AIRichResponseSubMessageType[message.messageType] : message.messageType;
                    if (options.oneofs)
                        object._messageType = "messageType";
                }
                if (message.gridImageMetadata != null && message.hasOwnProperty("gridImageMetadata")) {
                    object.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.toObject(message.gridImageMetadata, options);
                    if (options.oneofs)
                        object._gridImageMetadata = "gridImageMetadata";
                }
                if (message.messageText != null && message.hasOwnProperty("messageText")) {
                    object.messageText = message.messageText;
                    if (options.oneofs)
                        object._messageText = "messageText";
                }
                if (message.imageMetadata != null && message.hasOwnProperty("imageMetadata")) {
                    object.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.toObject(message.imageMetadata, options);
                    if (options.oneofs)
                        object._imageMetadata = "imageMetadata";
                }
                if (message.codeMetadata != null && message.hasOwnProperty("codeMetadata")) {
                    object.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.toObject(message.codeMetadata, options);
                    if (options.oneofs)
                        object._codeMetadata = "codeMetadata";
                }
                if (message.tableMetadata != null && message.hasOwnProperty("tableMetadata")) {
                    object.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.toObject(message.tableMetadata, options);
                    if (options.oneofs)
                        object._tableMetadata = "tableMetadata";
                }
                if (message.dynamicMetadata != null && message.hasOwnProperty("dynamicMetadata")) {
                    object.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.toObject(message.dynamicMetadata, options);
                    if (options.oneofs)
                        object._dynamicMetadata = "dynamicMetadata";
                }
                if (message.latexMetadata != null && message.hasOwnProperty("latexMetadata")) {
                    object.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.toObject(message.latexMetadata, options);
                    if (options.oneofs)
                        object._latexMetadata = "latexMetadata";
                }
                if (message.mapMetadata != null && message.hasOwnProperty("mapMetadata")) {
                    object.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.toObject(message.mapMetadata, options);
                    if (options.oneofs)
                        object._mapMetadata = "mapMetadata";
                }
                if (message.contentItemsMetadata != null && message.hasOwnProperty("contentItemsMetadata")) {
                    object.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.toObject(message.contentItemsMetadata, options);
                    if (options.oneofs)
                        object._contentItemsMetadata = "contentItemsMetadata";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseSubMessage to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseSubMessage.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseSubMessage
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseSubMessage
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseSubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseSubMessage";
            };

            return AIRichResponseSubMessage;
        })();

        /**
         * AIRichResponseSubMessageType enum.
         * @name proto.AIRichResponseMessage.AIRichResponseSubMessageType
         * @enum {number}
         * @property {number} AI_RICH_RESPONSE_UNKNOWN=0 AI_RICH_RESPONSE_UNKNOWN value
         * @property {number} AI_RICH_RESPONSE_GRID_IMAGE=1 AI_RICH_RESPONSE_GRID_IMAGE value
         * @property {number} AI_RICH_RESPONSE_TEXT=2 AI_RICH_RESPONSE_TEXT value
         * @property {number} AI_RICH_RESPONSE_INLINE_IMAGE=3 AI_RICH_RESPONSE_INLINE_IMAGE value
         * @property {number} AI_RICH_RESPONSE_TABLE=4 AI_RICH_RESPONSE_TABLE value
         * @property {number} AI_RICH_RESPONSE_CODE=5 AI_RICH_RESPONSE_CODE value
         * @property {number} AI_RICH_RESPONSE_DYNAMIC=6 AI_RICH_RESPONSE_DYNAMIC value
         * @property {number} AI_RICH_RESPONSE_MAP=7 AI_RICH_RESPONSE_MAP value
         * @property {number} AI_RICH_RESPONSE_LATEX=8 AI_RICH_RESPONSE_LATEX value
         * @property {number} AI_RICH_RESPONSE_CONTENT_ITEMS=9 AI_RICH_RESPONSE_CONTENT_ITEMS value
         */
        AIRichResponseMessage.AIRichResponseSubMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_GRID_IMAGE"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_TEXT"] = 2;
            values[valuesById[3] = "AI_RICH_RESPONSE_INLINE_IMAGE"] = 3;
            values[valuesById[4] = "AI_RICH_RESPONSE_TABLE"] = 4;
            values[valuesById[5] = "AI_RICH_RESPONSE_CODE"] = 5;
            values[valuesById[6] = "AI_RICH_RESPONSE_DYNAMIC"] = 6;
            values[valuesById[7] = "AI_RICH_RESPONSE_MAP"] = 7;
            values[valuesById[8] = "AI_RICH_RESPONSE_LATEX"] = 8;
            values[valuesById[9] = "AI_RICH_RESPONSE_CONTENT_ITEMS"] = 9;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseTableMetadata = (function() {

            /**
             * Properties of a AIRichResponseTableMetadata.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseTableMetadata
             * @property {Array.<proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow>|null} [rows] AIRichResponseTableMetadata rows
             */

            /**
             * Constructs a new AIRichResponseTableMetadata.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseTableMetadata.
             * @implements IAIRichResponseTableMetadata
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseTableMetadata=} [properties] Properties to set
             */
            function AIRichResponseTableMetadata(properties) {
                this.rows = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseTableMetadata rows.
             * @member {Array.<proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow>} rows
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @instance
             */
            AIRichResponseTableMetadata.prototype.rows = $util.emptyArray;

            /**
             * Creates a new AIRichResponseTableMetadata instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseTableMetadata=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata} AIRichResponseTableMetadata instance
             */
            AIRichResponseTableMetadata.create = function create(properties) {
                return new AIRichResponseTableMetadata(properties);
            };

            /**
             * Encodes the specified AIRichResponseTableMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseTableMetadata} message AIRichResponseTableMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseTableMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.rows != null && message.rows.length)
                    for (let i = 0; i < message.rows.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.encode(message.rows[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseTableMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseTableMetadata} message AIRichResponseTableMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseTableMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseTableMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata} AIRichResponseTableMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseTableMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            if (!(message.rows && message.rows.length))
                                message.rows = [];
                            message.rows.push($root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseTableMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata} AIRichResponseTableMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseTableMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseTableMetadata message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseTableMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.rows != null && message.hasOwnProperty("rows")) {
                    if (!Array.isArray(message.rows))
                        return "rows: array expected";
                    for (let i = 0; i < message.rows.length; ++i) {
                        let error = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.verify(message.rows[i]);
                        if (error)
                            return "rows." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a AIRichResponseTableMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata} AIRichResponseTableMetadata
             */
            AIRichResponseTableMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata();
                if (object.rows) {
                    if (!Array.isArray(object.rows))
                        throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.rows: array expected");
                    message.rows = [];
                    for (let i = 0; i < object.rows.length; ++i) {
                        if (typeof object.rows[i] !== "object")
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.rows: object expected");
                        message.rows[i] = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.fromObject(object.rows[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseTableMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata} message AIRichResponseTableMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseTableMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults)
                    object.rows = [];
                if (message.rows && message.rows.length) {
                    object.rows = [];
                    for (let j = 0; j < message.rows.length; ++j)
                        object.rows[j] = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.toObject(message.rows[j], options);
                }
                return object;
            };

            /**
             * Converts this AIRichResponseTableMetadata to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseTableMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseTableMetadata
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseTableMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata";
            };

            AIRichResponseTableMetadata.AIRichResponseTableRow = (function() {

                /**
                 * Properties of a AIRichResponseTableRow.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
                 * @interface IAIRichResponseTableRow
                 * @property {Array.<string>|null} [items] AIRichResponseTableRow items
                 * @property {boolean|null} [isHeading] AIRichResponseTableRow isHeading
                 */

                /**
                 * Constructs a new AIRichResponseTableRow.
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata
                 * @classdesc Represents a AIRichResponseTableRow.
                 * @implements IAIRichResponseTableRow
                 * @constructor
                 * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow=} [properties] Properties to set
                 */
                function AIRichResponseTableRow(properties) {
                    this.items = [];
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AIRichResponseTableRow items.
                 * @member {Array.<string>} items
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @instance
                 */
                AIRichResponseTableRow.prototype.items = $util.emptyArray;

                /**
                 * AIRichResponseTableRow isHeading.
                 * @member {boolean|null|undefined} isHeading
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @instance
                 */
                AIRichResponseTableRow.prototype.isHeading = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(AIRichResponseTableRow.prototype, "_isHeading", {
                    get: $util.oneOfGetter($oneOfFields = ["isHeading"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new AIRichResponseTableRow instance using the specified properties.
                 * @function create
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow=} [properties] Properties to set
                 * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow} AIRichResponseTableRow instance
                 */
                AIRichResponseTableRow.create = function create(properties) {
                    return new AIRichResponseTableRow(properties);
                };

                /**
                 * Encodes the specified AIRichResponseTableRow message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.verify|verify} messages.
                 * @function encode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow} message AIRichResponseTableRow message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseTableRow.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.items != null && message.items.length)
                        for (let i = 0; i < message.items.length; ++i)
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.items[i]);
                    if (message.isHeading != null && Object.hasOwnProperty.call(message, "isHeading"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isHeading);
                    return writer;
                };

                /**
                 * Encodes the specified AIRichResponseTableRow message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow} message AIRichResponseTableRow message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AIRichResponseTableRow.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a AIRichResponseTableRow message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow} AIRichResponseTableRow
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseTableRow.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                if (!(message.items && message.items.length))
                                    message.items = [];
                                message.items.push(reader.string());
                                break;
                            }
                        case 2: {
                                message.isHeading = reader.bool();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a AIRichResponseTableRow message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow} AIRichResponseTableRow
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AIRichResponseTableRow.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a AIRichResponseTableRow message.
                 * @function verify
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AIRichResponseTableRow.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.items != null && message.hasOwnProperty("items")) {
                        if (!Array.isArray(message.items))
                            return "items: array expected";
                        for (let i = 0; i < message.items.length; ++i)
                            if (!$util.isString(message.items[i]))
                                return "items: string[] expected";
                    }
                    if (message.isHeading != null && message.hasOwnProperty("isHeading")) {
                        properties._isHeading = 1;
                        if (typeof message.isHeading !== "boolean")
                            return "isHeading: boolean expected";
                    }
                    return null;
                };

                /**
                 * Creates a AIRichResponseTableRow message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow} AIRichResponseTableRow
                 */
                AIRichResponseTableRow.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow)
                        return object;
                    let message = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow();
                    if (object.items) {
                        if (!Array.isArray(object.items))
                            throw TypeError(".proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.items: array expected");
                        message.items = [];
                        for (let i = 0; i < object.items.length; ++i)
                            message.items[i] = String(object.items[i]);
                    }
                    if (object.isHeading != null)
                        message.isHeading = Boolean(object.isHeading);
                    return message;
                };

                /**
                 * Creates a plain object from a AIRichResponseTableRow message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow} message AIRichResponseTableRow
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AIRichResponseTableRow.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (options.arrays || options.defaults)
                        object.items = [];
                    if (message.items && message.items.length) {
                        object.items = [];
                        for (let j = 0; j < message.items.length; ++j)
                            object.items[j] = message.items[j];
                    }
                    if (message.isHeading != null && message.hasOwnProperty("isHeading")) {
                        object.isHeading = message.isHeading;
                        if (options.oneofs)
                            object._isHeading = "isHeading";
                    }
                    return object;
                };

                /**
                 * Converts this AIRichResponseTableRow to JSON.
                 * @function toJSON
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AIRichResponseTableRow.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for AIRichResponseTableRow
                 * @function getTypeUrl
                 * @memberof proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                AIRichResponseTableRow.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow";
                };

                return AIRichResponseTableRow;
            })();

            return AIRichResponseTableMetadata;
        })();

        AIRichResponseMessage.AIRichResponseUnifiedResponse = (function() {

            /**
             * Properties of a AIRichResponseUnifiedResponse.
             * @memberof proto.AIRichResponseMessage
             * @interface IAIRichResponseUnifiedResponse
             * @property {Uint8Array|null} [data] AIRichResponseUnifiedResponse data
             */

            /**
             * Constructs a new AIRichResponseUnifiedResponse.
             * @memberof proto.AIRichResponseMessage
             * @classdesc Represents a AIRichResponseUnifiedResponse.
             * @implements IAIRichResponseUnifiedResponse
             * @constructor
             * @param {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse=} [properties] Properties to set
             */
            function AIRichResponseUnifiedResponse(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AIRichResponseUnifiedResponse data.
             * @member {Uint8Array|null|undefined} data
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @instance
             */
            AIRichResponseUnifiedResponse.prototype.data = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(AIRichResponseUnifiedResponse.prototype, "_data", {
                get: $util.oneOfGetter($oneOfFields = ["data"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new AIRichResponseUnifiedResponse instance using the specified properties.
             * @function create
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse=} [properties] Properties to set
             * @returns {proto.AIRichResponseMessage.AIRichResponseUnifiedResponse} AIRichResponseUnifiedResponse instance
             */
            AIRichResponseUnifiedResponse.create = function create(properties) {
                return new AIRichResponseUnifiedResponse(properties);
            };

            /**
             * Encodes the specified AIRichResponseUnifiedResponse message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.verify|verify} messages.
             * @function encode
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse} message AIRichResponseUnifiedResponse message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseUnifiedResponse.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.data);
                return writer;
            };

            /**
             * Encodes the specified AIRichResponseUnifiedResponse message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse} message AIRichResponseUnifiedResponse message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AIRichResponseUnifiedResponse.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a AIRichResponseUnifiedResponse message from the specified reader or buffer.
             * @function decode
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.AIRichResponseMessage.AIRichResponseUnifiedResponse} AIRichResponseUnifiedResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseUnifiedResponse.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.data = reader.bytes();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a AIRichResponseUnifiedResponse message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.AIRichResponseMessage.AIRichResponseUnifiedResponse} AIRichResponseUnifiedResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AIRichResponseUnifiedResponse.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a AIRichResponseUnifiedResponse message.
             * @function verify
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AIRichResponseUnifiedResponse.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.data != null && message.hasOwnProperty("data")) {
                    properties._data = 1;
                    if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                        return "data: buffer expected";
                }
                return null;
            };

            /**
             * Creates a AIRichResponseUnifiedResponse message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.AIRichResponseMessage.AIRichResponseUnifiedResponse} AIRichResponseUnifiedResponse
             */
            AIRichResponseUnifiedResponse.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse)
                    return object;
                let message = new $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse();
                if (object.data != null)
                    if (typeof object.data === "string")
                        $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                    else if (object.data.length >= 0)
                        message.data = object.data;
                return message;
            };

            /**
             * Creates a plain object from a AIRichResponseUnifiedResponse message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {proto.AIRichResponseMessage.AIRichResponseUnifiedResponse} message AIRichResponseUnifiedResponse
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AIRichResponseUnifiedResponse.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.data != null && message.hasOwnProperty("data")) {
                    object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                    if (options.oneofs)
                        object._data = "data";
                }
                return object;
            };

            /**
             * Converts this AIRichResponseUnifiedResponse to JSON.
             * @function toJSON
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AIRichResponseUnifiedResponse.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for AIRichResponseUnifiedResponse
             * @function getTypeUrl
             * @memberof proto.AIRichResponseMessage.AIRichResponseUnifiedResponse
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            AIRichResponseUnifiedResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseUnifiedResponse";
            };

            return AIRichResponseUnifiedResponse;
        })();

        return AIRichResponseMessage;
    })();

    proto.Account = (function() {

        /**
         * Properties of an Account.
         * @memberof proto
         * @interface IAccount
         * @property {string|null} [lid] Account lid
         * @property {string|null} [username] Account username
         * @property {string|null} [countryCode] Account countryCode
         * @property {boolean|null} [isUsernameDeleted] Account isUsernameDeleted
         */

        /**
         * Constructs a new Account.
         * @memberof proto
         * @classdesc Represents an Account.
         * @implements IAccount
         * @constructor
         * @param {proto.IAccount=} [properties] Properties to set
         */
        function Account(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Account lid.
         * @member {string|null|undefined} lid
         * @memberof proto.Account
         * @instance
         */
        Account.prototype.lid = null;

        /**
         * Account username.
         * @member {string|null|undefined} username
         * @memberof proto.Account
         * @instance
         */
        Account.prototype.username = null;

        /**
         * Account countryCode.
         * @member {string|null|undefined} countryCode
         * @memberof proto.Account
         * @instance
         */
        Account.prototype.countryCode = null;

        /**
         * Account isUsernameDeleted.
         * @member {boolean|null|undefined} isUsernameDeleted
         * @memberof proto.Account
         * @instance
         */
        Account.prototype.isUsernameDeleted = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_lid", {
            get: $util.oneOfGetter($oneOfFields = ["lid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_username", {
            get: $util.oneOfGetter($oneOfFields = ["username"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_countryCode", {
            get: $util.oneOfGetter($oneOfFields = ["countryCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(Account.prototype, "_isUsernameDeleted", {
            get: $util.oneOfGetter($oneOfFields = ["isUsernameDeleted"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Account instance using the specified properties.
         * @function create
         * @memberof proto.Account
         * @static
         * @param {proto.IAccount=} [properties] Properties to set
         * @returns {proto.Account} Account instance
         */
        Account.create = function create(properties) {
            return new Account(properties);
        };

        /**
         * Encodes the specified Account message. Does not implicitly {@link proto.Account.verify|verify} messages.
         * @function encode
         * @memberof proto.Account
         * @static
         * @param {proto.IAccount} message Account message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Account.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lid != null && Object.hasOwnProperty.call(message, "lid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.lid);
            if (message.username != null && Object.hasOwnProperty.call(message, "username"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.username);
            if (message.countryCode != null && Object.hasOwnProperty.call(message, "countryCode"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.countryCode);
            if (message.isUsernameDeleted != null && Object.hasOwnProperty.call(message, "isUsernameDeleted"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.isUsernameDeleted);
            return writer;
        };

        /**
         * Encodes the specified Account message, length delimited. Does not implicitly {@link proto.Account.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Account
         * @static
         * @param {proto.IAccount} message Account message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Account.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an Account message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Account
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Account} Account
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Account.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Account();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.lid = reader.string();
                        break;
                    }
                case 2: {
                        message.username = reader.string();
                        break;
                    }
                case 3: {
                        message.countryCode = reader.string();
                        break;
                    }
                case 4: {
                        message.isUsernameDeleted = reader.bool();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an Account message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Account
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Account} Account
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Account.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an Account message.
         * @function verify
         * @memberof proto.Account
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Account.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.lid != null && message.hasOwnProperty("lid")) {
                properties._lid = 1;
                if (!$util.isString(message.lid))
                    return "lid: string expected";
            }
            if (message.username != null && message.hasOwnProperty("username")) {
                properties._username = 1;
                if (!$util.isString(message.username))
                    return "username: string expected";
            }
            if (message.countryCode != null && message.hasOwnProperty("countryCode")) {
                properties._countryCode = 1;
                if (!$util.isString(message.countryCode))
                    return "countryCode: string expected";
            }
            if (message.isUsernameDeleted != null && message.hasOwnProperty("isUsernameDeleted")) {
                properties._isUsernameDeleted = 1;
                if (typeof message.isUsernameDeleted !== "boolean")
                    return "isUsernameDeleted: boolean expected";
            }
            return null;
        };

        /**
         * Creates an Account message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Account
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Account} Account
         */
        Account.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Account)
                return object;
            let message = new $root.proto.Account();
            if (object.lid != null)
                message.lid = String(object.lid);
            if (object.username != null)
                message.username = String(object.username);
            if (object.countryCode != null)
                message.countryCode = String(object.countryCode);
            if (object.isUsernameDeleted != null)
                message.isUsernameDeleted = Boolean(object.isUsernameDeleted);
            return message;
        };

        /**
         * Creates a plain object from an Account message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Account
         * @static
         * @param {proto.Account} message Account
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Account.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.lid != null && message.hasOwnProperty("lid")) {
                object.lid = message.lid;
                if (options.oneofs)
                    object._lid = "lid";
            }
            if (message.username != null && message.hasOwnProperty("username")) {
                object.username = message.username;
                if (options.oneofs)
                    object._username = "username";
            }
            if (message.countryCode != null && message.hasOwnProperty("countryCode")) {
                object.countryCode = message.countryCode;
                if (options.oneofs)
                    object._countryCode = "countryCode";
            }
            if (message.isUsernameDeleted != null && message.hasOwnProperty("isUsernameDeleted")) {
                object.isUsernameDeleted = message.isUsernameDeleted;
                if (options.oneofs)
                    object._isUsernameDeleted = "isUsernameDeleted";
            }
            return object;
        };

        /**
         * Converts this Account to JSON.
         * @function toJSON
         * @memberof proto.Account
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Account.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for Account
         * @function getTypeUrl
         * @memberof proto.Account
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        Account.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Account";
        };

        return Account;
    })();

    proto.ActionLink = (function() {

        /**
         * Properties of an ActionLink.
         * @memberof proto
         * @interface IActionLink
         * @property {string|null} [url] ActionLink url
         * @property {string|null} [buttonTitle] ActionLink buttonTitle
         */

        /**
         * Constructs a new ActionLink.
         * @memberof proto
         * @classdesc Represents an ActionLink.
         * @implements IActionLink
         * @constructor
         * @param {proto.IActionLink=} [properties] Properties to set
         */
        function ActionLink(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ActionLink url.
         * @member {string|null|undefined} url
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.url = null;

        /**
         * ActionLink buttonTitle.
         * @member {string|null|undefined} buttonTitle
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.buttonTitle = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_url", {
            get: $util.oneOfGetter($oneOfFields = ["url"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(ActionLink.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @function create
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink=} [properties] Properties to set
         * @returns {proto.ActionLink} ActionLink instance
         */
        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encode
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.buttonTitle != null && Object.hasOwnProperty.call(message, "buttonTitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.buttonTitle);
            return writer;
        };

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ActionLink();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.url = reader.string();
                        break;
                    }
                case 2: {
                        message.buttonTitle = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ActionLink message.
         * @function verify
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ActionLink.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.url != null && message.hasOwnProperty("url")) {
                properties._url = 1;
                if (!$util.isString(message.url))
                    return "url: string expected";
            }
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle")) {
                properties._buttonTitle = 1;
                if (!$util.isString(message.buttonTitle))
                    return "buttonTitle: string expected";
            }
            return null;
        };

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ActionLink} ActionLink
         */
        ActionLink.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ActionLink)
                return object;
            let message = new $root.proto.ActionLink();
            if (object.url != null)
                message.url = String(object.url);
            if (object.buttonTitle != null)
                message.buttonTitle = String(object.buttonTitle);
            return message;
        };

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ActionLink
         * @static
         * @param {proto.ActionLink} message ActionLink
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ActionLink.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.url != null && message.hasOwnProperty("url")) {
                object.url = message.url;
                if (options.oneofs)
                    object._url = "url";
            }
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle")) {
                object.buttonTitle = message.buttonTitle;
                if (options.oneofs)
                    object._buttonTitle = "buttonTitle";
            }
            return object;
        };

        /**
         * Converts this ActionLink to JSON.
         * @function toJSON
         * @memberof proto.ActionLink
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ActionLink
         * @function getTypeUrl
         * @memberof proto.ActionLink
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ActionLink.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ActionLink";
        };

        return ActionLink;
    })();

    proto.AutoDownloadSettings = (function() {

        /**
         * Properties of an AutoDownloadSettings.
         * @memberof proto
         * @interface IAutoDownloadSettings
         * @property {boolean|null} [downloadImages] AutoDownloadSettings downloadImages
         * @property {boolean|null} [downloadAudio] AutoDownloadSettings downloadAudio
         * @property {boolean|null} [downloadVideo] AutoDownloadSettings downloadVideo
         * @property {boolean|null} [downloadDocuments] AutoDownloadSettings downloadDocuments
         */

        /**
         * Constructs a new AutoDownloadSettings.
         * @memberof proto
         * @classdesc Represents an AutoDownloadSettings.
         * @implements IAutoDownloadSettings
         * @constructor
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         */
        function AutoDownloadSettings(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AutoDownloadSettings downloadImages.
         * @member {boolean|null|undefined} downloadImages
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadImages = null;

        /**
         * AutoDownloadSettings downloadAudio.
         * @member {boolean|null|undefined} downloadAudio
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadAudio = null;

        /**
         * AutoDownloadSettings downloadVideo.
         * @member {boolean|null|undefined} downloadVideo
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadVideo = null;

        /**
         * AutoDownloadSettings downloadDocuments.
         * @member {boolean|null|undefined} downloadDocuments
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadDocuments = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadImages", {
            get: $util.oneOfGetter($oneOfFields = ["downloadImages"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadAudio", {
            get: $util.oneOfGetter($oneOfFields = ["downloadAudio"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadVideo", {
            get: $util.oneOfGetter($oneOfFields = ["downloadVideo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AutoDownloadSettings.prototype, "_downloadDocuments", {
            get: $util.oneOfGetter($oneOfFields = ["downloadDocuments"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new AutoDownloadSettings instance using the specified properties.
         * @function create
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings instance
         */
        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        /**
         * Encodes the specified AutoDownloadSettings message. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.downloadImages != null && Object.hasOwnProperty.call(message, "downloadImages"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.downloadImages);
            if (message.downloadAudio != null && Object.hasOwnProperty.call(message, "downloadAudio"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.downloadAudio);
            if (message.downloadVideo != null && Object.hasOwnProperty.call(message, "downloadVideo"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.downloadVideo);
            if (message.downloadDocuments != null && Object.hasOwnProperty.call(message, "downloadDocuments"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.downloadDocuments);
            return writer;
        };

        /**
         * Encodes the specified AutoDownloadSettings message, length delimited. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AutoDownloadSettings();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.downloadImages = reader.bool();
                        break;
                    }
                case 2: {
                        message.downloadAudio = reader.bool();
                        break;
                    }
                case 3: {
                        message.downloadVideo = reader.bool();
                        break;
                    }
                case 4: {
                        message.downloadDocuments = reader.bool();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AutoDownloadSettings message.
         * @function verify
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AutoDownloadSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages")) {
                properties._downloadImages = 1;
                if (typeof message.downloadImages !== "boolean")
                    return "downloadImages: boolean expected";
            }
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio")) {
                properties._downloadAudio = 1;
                if (typeof message.downloadAudio !== "boolean")
                    return "downloadAudio: boolean expected";
            }
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo")) {
                properties._downloadVideo = 1;
                if (typeof message.downloadVideo !== "boolean")
                    return "downloadVideo: boolean expected";
            }
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments")) {
                properties._downloadDocuments = 1;
                if (typeof message.downloadDocuments !== "boolean")
                    return "downloadDocuments: boolean expected";
            }
            return null;
        };

        /**
         * Creates an AutoDownloadSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         */
        AutoDownloadSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AutoDownloadSettings)
                return object;
            let message = new $root.proto.AutoDownloadSettings();
            if (object.downloadImages != null)
                message.downloadImages = Boolean(object.downloadImages);
            if (object.downloadAudio != null)
                message.downloadAudio = Boolean(object.downloadAudio);
            if (object.downloadVideo != null)
                message.downloadVideo = Boolean(object.downloadVideo);
            if (object.downloadDocuments != null)
                message.downloadDocuments = Boolean(object.downloadDocuments);
            return message;
        };

        /**
         * Creates a plain object from an AutoDownloadSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.AutoDownloadSettings} message AutoDownloadSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AutoDownloadSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages")) {
                object.downloadImages = message.downloadImages;
                if (options.oneofs)
                    object._downloadImages = "downloadImages";
            }
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio")) {
                object.downloadAudio = message.downloadAudio;
                if (options.oneofs)
                    object._downloadAudio = "downloadAudio";
            }
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo")) {
                object.downloadVideo = message.downloadVideo;
                if (options.oneofs)
                    object._downloadVideo = "downloadVideo";
            }
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments")) {
                object.downloadDocuments = message.downloadDocuments;
                if (options.oneofs)
                    object._downloadDocuments = "downloadDocuments";
            }
            return object;
        };

        /**
         * Converts this AutoDownloadSettings to JSON.
         * @function toJSON
         * @memberof proto.AutoDownloadSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AutoDownloadSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for AutoDownloadSettings
         * @function getTypeUrl
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        AutoDownloadSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AutoDownloadSettings";
        };

        return AutoDownloadSettings;
    })();

    proto.AvatarUserSettings = (function() {

        /**
         * Properties of an AvatarUserSettings.
         * @memberof proto
         * @interface IAvatarUserSettings
         * @property {string|null} [fbid] AvatarUserSettings fbid
         * @property {string|null} [password] AvatarUserSettings password
         */

        /**
         * Constructs a new AvatarUserSettings.
         * @memberof proto
         * @classdesc Represents an AvatarUserSettings.
         * @implements IAvatarUserSettings
         * @constructor
         * @param {proto.IAvatarUserSettings=} [properties] Properties to set
         */
        function AvatarUserSettings(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AvatarUserSettings fbid.
         * @member {string|null|undefined} fbid
         * @memberof proto.AvatarUserSettings
         * @instance
         */
        AvatarUserSettings.prototype.fbid = null;

        /**
         * AvatarUserSettings password.
         * @member {string|null|undefined} password
         * @memberof proto.AvatarUserSettings
         * @instance
         */
        AvatarUserSettings.prototype.password = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_fbid", {
            get: $util.oneOfGetter($oneOfFields = ["fbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(AvatarUserSettings.prototype, "_password", {
            get: $util.oneOfGetter($oneOfFields = ["password"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new AvatarUserSettings instance using the specified properties.
         * @function create
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings=} [properties] Properties to set
         * @returns {proto.AvatarUserSettings} AvatarUserSettings instance
         */
        AvatarUserSettings.create = function create(properties) {
            return new AvatarUserSettings(properties);
        };

        /**
         * Encodes the specified AvatarUserSettings message. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings} message AvatarUserSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AvatarUserSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fbid != null && Object.hasOwnProperty.call(message, "fbid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fbid);
            if (message.password != null && Object.hasOwnProperty.call(message, "password"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.password);
            return writer;
        };

        /**
         * Encodes the specified AvatarUserSettings message, length delimited. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings} message AvatarUserSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AvatarUserSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AvatarUserSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AvatarUserSettings();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.fbid = reader.string();
                        break;
                    }
                case 2: {
                        message.password = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AvatarUserSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AvatarUserSettings message.
         * @function verify
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AvatarUserSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.fbid != null && message.hasOwnProperty("fbid")) {
                properties._fbid = 1;
                if (!$util.isString(message.fbid))
                    return "fbid: string expected";
            }
            if (message.password != null && message.hasOwnProperty("password")) {
                properties._password = 1;
                if (!$util.isString(message.password))
                    return "password: string expected";
            }
            return null;
        };

        /**
         * Creates an AvatarUserSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         */
        AvatarUserSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AvatarUserSettings)
                return object;
            let message = new $root.proto.AvatarUserSettings();
            if (object.fbid != null)
                message.fbid = String(object.fbid);
            if (object.password != null)
                message.password = String(object.password);
            return message;
        };

        /**
         * Creates a plain object from an AvatarUserSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.AvatarUserSettings} message AvatarUserSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AvatarUserSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.fbid != null && message.hasOwnProperty("fbid")) {
                object.fbid = message.fbid;
                if (options.oneofs)
                    object._fbid = "fbid";
            }
            if (message.password != null && message.hasOwnProperty("password")) {
                object.password = message.password;
                if (options.oneofs)
                    object._password = "password";
            }
            return object;
        };

        /**
         * Converts this AvatarUserSettings to JSON.
         * @function toJSON
         * @memberof proto.AvatarUserSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AvatarUserSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for AvatarUserSettings
         * @function getTypeUrl
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        AvatarUserSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AvatarUserSettings";
        };

        return AvatarUserSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        /**
         * Properties of a BizAccountLinkInfo.
         * @memberof proto
         * @interface IBizAccountLinkInfo
         * @property {number|Long|null} [whatsappBizAcctFbid] BizAccountLinkInfo whatsappBizAcctFbid
         * @property {string|null} [whatsappAcctNumber] BizAccountLinkInfo whatsappAcctNumber
         * @property {number|Long|null} [issueTime] BizAccountLinkInfo issueTime
         * @property {proto.BizAccountLinkInfo.HostStorageType|null} [hostStorage] BizAccountLinkInfo hostStorage
         * @property {proto.BizAccountLinkInfo.AccountType|null} [accountType] BizAccountLinkInfo accountType
         */

        /**
         * Constructs a new BizAccountLinkInfo.
         * @memberof proto
         * @classdesc Represents a BizAccountLinkInfo.
         * @implements IBizAccountLinkInfo
         * @constructor
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         */
        function BizAccountLinkInfo(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountLinkInfo whatsappBizAcctFbid.
         * @member {number|Long|null|undefined} whatsappBizAcctFbid
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = null;

        /**
         * BizAccountLinkInfo whatsappAcctNumber.
         * @member {string|null|undefined} whatsappAcctNumber
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappAcctNumber = null;

        /**
         * BizAccountLinkInfo issueTime.
         * @member {number|Long|null|undefined} issueTime
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.issueTime = null;

        /**
         * BizAccountLinkInfo hostStorage.
         * @member {proto.BizAccountLinkInfo.HostStorageType|null|undefined} hostStorage
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.hostStorage = null;

        /**
         * BizAccountLinkInfo accountType.
         * @member {proto.BizAccountLinkInfo.AccountType|null|undefined} accountType
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.accountType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappBizAcctFbid", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappBizAcctFbid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_whatsappAcctNumber", {
            get: $util.oneOfGetter($oneOfFields = ["whatsappAcctNumber"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_issueTime", {
            get: $util.oneOfGetter($oneOfFields = ["issueTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountLinkInfo.prototype, "_accountType", {
            get: $util.oneOfGetter($oneOfFields = ["accountType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo instance
         */
        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(message, "whatsappBizAcctFbid"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.whatsappBizAcctFbid);
            if (message.whatsappAcctNumber != null && Object.hasOwnProperty.call(message, "whatsappAcctNumber"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.whatsappAcctNumber);
            if (message.issueTime != null && Object.hasOwnProperty.call(message, "issueTime"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.issueTime);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.hostStorage);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountLinkInfo();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.whatsappBizAcctFbid = reader.uint64();
                        break;
                    }
                case 2: {
                        message.whatsappAcctNumber = reader.string();
                        break;
                    }
                case 3: {
                        message.issueTime = reader.uint64();
                        break;
                    }
                case 4: {
                        message.hostStorage = reader.int32();
                        break;
                    }
                case 5: {
                        message.accountType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountLinkInfo message.
         * @function verify
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountLinkInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid")) {
                properties._whatsappBizAcctFbid = 1;
                if (!$util.isInteger(message.whatsappBizAcctFbid) && !(message.whatsappBizAcctFbid && $util.isInteger(message.whatsappBizAcctFbid.low) && $util.isInteger(message.whatsappBizAcctFbid.high)))
                    return "whatsappBizAcctFbid: integer|Long expected";
            }
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber")) {
                properties._whatsappAcctNumber = 1;
                if (!$util.isString(message.whatsappAcctNumber))
                    return "whatsappAcctNumber: string expected";
            }
            if (message.issueTime != null && message.hasOwnProperty("issueTime")) {
                properties._issueTime = 1;
                if (!$util.isInteger(message.issueTime) && !(message.issueTime && $util.isInteger(message.issueTime.low) && $util.isInteger(message.issueTime.high)))
                    return "issueTime: integer|Long expected";
            }
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage")) {
                properties._hostStorage = 1;
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                properties._accountType = 1;
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         */
        BizAccountLinkInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountLinkInfo)
                return object;
            let message = new $root.proto.BizAccountLinkInfo();
            if (object.whatsappBizAcctFbid != null)
                if ($util.Long)
                    (message.whatsappBizAcctFbid = $util.Long.fromValue(object.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof object.whatsappBizAcctFbid === "string")
                    message.whatsappBizAcctFbid = parseInt(object.whatsappBizAcctFbid, 10);
                else if (typeof object.whatsappBizAcctFbid === "number")
                    message.whatsappBizAcctFbid = object.whatsappBizAcctFbid;
                else if (typeof object.whatsappBizAcctFbid === "object")
                    message.whatsappBizAcctFbid = new $util.LongBits(object.whatsappBizAcctFbid.low >>> 0, object.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            if (object.whatsappAcctNumber != null)
                message.whatsappAcctNumber = String(object.whatsappAcctNumber);
            if (object.issueTime != null)
                if ($util.Long)
                    (message.issueTime = $util.Long.fromValue(object.issueTime)).unsigned = true;
                else if (typeof object.issueTime === "string")
                    message.issueTime = parseInt(object.issueTime, 10);
                else if (typeof object.issueTime === "number")
                    message.issueTime = object.issueTime;
                else if (typeof object.issueTime === "object")
                    message.issueTime = new $util.LongBits(object.issueTime.low >>> 0, object.issueTime.high >>> 0).toNumber(true);
            switch (object.hostStorage) {
            default:
                if (typeof object.hostStorage === "number") {
                    message.hostStorage = object.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.accountType) {
            default:
                if (typeof object.accountType === "number") {
                    message.accountType = object.accountType;
                    break;
                }
                break;
            case "ENTERPRISE":
            case 0:
                message.accountType = 0;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.BizAccountLinkInfo} message BizAccountLinkInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountLinkInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid")) {
                if (typeof message.whatsappBizAcctFbid === "number")
                    object.whatsappBizAcctFbid = options.longs === String ? String(message.whatsappBizAcctFbid) : message.whatsappBizAcctFbid;
                else
                    object.whatsappBizAcctFbid = options.longs === String ? $util.Long.prototype.toString.call(message.whatsappBizAcctFbid) : options.longs === Number ? new $util.LongBits(message.whatsappBizAcctFbid.low >>> 0, message.whatsappBizAcctFbid.high >>> 0).toNumber(true) : message.whatsappBizAcctFbid;
                if (options.oneofs)
                    object._whatsappBizAcctFbid = "whatsappBizAcctFbid";
            }
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber")) {
                object.whatsappAcctNumber = message.whatsappAcctNumber;
                if (options.oneofs)
                    object._whatsappAcctNumber = "whatsappAcctNumber";
            }
            if (message.issueTime != null && message.hasOwnProperty("issueTime")) {
                if (typeof message.issueTime === "number")
                    object.issueTime = options.longs === String ? String(message.issueTime) : message.issueTime;
                else
                    object.issueTime = options.longs === String ? $util.Long.prototype.toString.call(message.issueTime) : options.longs === Number ? new $util.LongBits(message.issueTime.low >>> 0, message.issueTime.high >>> 0).toNumber(true) : message.issueTime;
                if (options.oneofs)
                    object._issueTime = "issueTime";
            }
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage")) {
                object.hostStorage = options.enums === String ? $root.proto.BizAccountLinkInfo.HostStorageType[message.hostStorage] === undefined ? message.hostStorage : $root.proto.BizAccountLinkInfo.HostStorageType[message.hostStorage] : message.hostStorage;
                if (options.oneofs)
                    object._hostStorage = "hostStorage";
            }
            if (message.accountType != null && message.hasOwnProperty("accountType")) {
                object.accountType = options.enums === String ? $root.proto.BizAccountLinkInfo.AccountType[message.accountType] === undefined ? message.accountType : $root.proto.BizAccountLinkInfo.AccountType[message.accountType] : message.accountType;
                if (options.oneofs)
                    object._accountType = "accountType";
            }
            return object;
        };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @function toJSON
         * @memberof proto.BizAccountLinkInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BizAccountLinkInfo
         * @function getTypeUrl
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BizAccountLinkInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountLinkInfo";
        };

        /**
         * AccountType enum.
         * @name proto.BizAccountLinkInfo.AccountType
         * @enum {number}
         * @property {number} ENTERPRISE=0 ENTERPRISE value
         */
        BizAccountLinkInfo.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        /**
         * HostStorageType enum.
         * @name proto.BizAccountLinkInfo.HostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizAccountLinkInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        /**
         * Properties of a BizAccountPayload.
         * @memberof proto
         * @interface IBizAccountPayload
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizAccountPayload vnameCert
         * @property {Uint8Array|null} [bizAcctLinkInfo] BizAccountPayload bizAcctLinkInfo
         */

        /**
         * Constructs a new BizAccountPayload.
         * @memberof proto
         * @classdesc Represents a BizAccountPayload.
         * @implements IBizAccountPayload
         * @constructor
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         */
        function BizAccountPayload(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountPayload vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.vnameCert = null;

        /**
         * BizAccountPayload bizAcctLinkInfo.
         * @member {Uint8Array|null|undefined} bizAcctLinkInfo
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.bizAcctLinkInfo = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizAccountPayload.prototype, "_bizAcctLinkInfo", {
            get: $util.oneOfGetter($oneOfFields = ["bizAcctLinkInfo"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         * @returns {proto.BizAccountPayload} BizAccountPayload instance
         */
        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.bizAcctLinkInfo != null && Object.hasOwnProperty.call(message, "bizAcctLinkInfo"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.bizAcctLinkInfo);
            return writer;
        };

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountPayload();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        message.bizAcctLinkInfo = reader.bytes();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountPayload message.
         * @function verify
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                properties._vnameCert = 1;
                {
                    let error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                    if (error)
                        return "vnameCert." + error;
                }
            }
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo")) {
                properties._bizAcctLinkInfo = 1;
                if (!(message.bizAcctLinkInfo && typeof message.bizAcctLinkInfo.length === "number" || $util.isString(message.bizAcctLinkInfo)))
                    return "bizAcctLinkInfo: buffer expected";
            }
            return null;
        };

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountPayload} BizAccountPayload
         */
        BizAccountPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountPayload)
                return object;
            let message = new $root.proto.BizAccountPayload();
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.bizAcctLinkInfo != null)
                if (typeof object.bizAcctLinkInfo === "string")
                    $util.base64.decode(object.bizAcctLinkInfo, message.bizAcctLinkInfo = $util.newBuffer($util.base64.length(object.bizAcctLinkInfo)), 0);
                else if (object.bizAcctLinkInfo.length >= 0)
                    message.bizAcctLinkInfo = object.bizAcctLinkInfo;
            return message;
        };

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.BizAccountPayload} message BizAccountPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
                if (options.oneofs)
                    object._vnameCert = "vnameCert";
            }
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo")) {
                object.bizAcctLinkInfo = options.bytes === String ? $util.base64.encode(message.bizAcctLinkInfo, 0, message.bizAcctLinkInfo.length) : options.bytes === Array ? Array.prototype.slice.call(message.bizAcctLinkInfo) : message.bizAcctLinkInfo;
                if (options.oneofs)
                    object._bizAcctLinkInfo = "bizAcctLinkInfo";
            }
            return object;
        };

        /**
         * Converts this BizAccountPayload to JSON.
         * @function toJSON
         * @memberof proto.BizAccountPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BizAccountPayload
         * @function getTypeUrl
         * @memberof proto.BizAccountPayload
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BizAccountPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountPayload";
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        /**
         * Properties of a BizIdentityInfo.
         * @memberof proto
         * @interface IBizIdentityInfo
         * @property {proto.BizIdentityInfo.VerifiedLevelValue|null} [vlevel] BizIdentityInfo vlevel
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizIdentityInfo vnameCert
         * @property {boolean|null} [signed] BizIdentityInfo signed
         * @property {boolean|null} [revoked] BizIdentityInfo revoked
         * @property {proto.BizIdentityInfo.HostStorageType|null} [hostStorage] BizIdentityInfo hostStorage
         * @property {proto.BizIdentityInfo.ActualActorsType|null} [actualActors] BizIdentityInfo actualActors
         * @property {number|Long|null} [privacyModeTs] BizIdentityInfo privacyModeTs
         * @property {number|Long|null} [featureControls] BizIdentityInfo featureControls
         */

        /**
         * Constructs a new BizIdentityInfo.
         * @memberof proto
         * @classdesc Represents a BizIdentityInfo.
         * @implements IBizIdentityInfo
         * @constructor
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         */
        function BizIdentityInfo(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizIdentityInfo vlevel.
         * @member {proto.BizIdentityInfo.VerifiedLevelValue|null|undefined} vlevel
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vlevel = null;

        /**
         * BizIdentityInfo vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vnameCert = null;

        /**
         * BizIdentityInfo signed.
         * @member {boolean|null|undefined} signed
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.signed = null;

        /**
         * BizIdentityInfo revoked.
         * @member {boolean|null|undefined} revoked
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.revoked = null;

        /**
         * BizIdentityInfo hostStorage.
         * @member {proto.BizIdentityInfo.HostStorageType|null|undefined} hostStorage
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.hostStorage = null;

        /**
         * BizIdentityInfo actualActors.
         * @member {proto.BizIdentityInfo.ActualActorsType|null|undefined} actualActors
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.actualActors = null;

        /**
         * BizIdentityInfo privacyModeTs.
         * @member {number|Long|null|undefined} privacyModeTs
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.privacyModeTs = null;

        /**
         * BizIdentityInfo featureControls.
         * @member {number|Long|null|undefined} featureControls
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.featureControls = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vlevel", {
            get: $util.oneOfGetter($oneOfFields = ["vlevel"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_vnameCert", {
            get: $util.oneOfGetter($oneOfFields = ["vnameCert"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_signed", {
            get: $util.oneOfGetter($oneOfFields = ["signed"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_revoked", {
            get: $util.oneOfGetter($oneOfFields = ["revoked"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_hostStorage", {
            get: $util.oneOfGetter($oneOfFields = ["hostStorage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_actualActors", {
            get: $util.oneOfGetter($oneOfFields = ["actualActors"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_privacyModeTs", {
            get: $util.oneOfGetter($oneOfFields = ["privacyModeTs"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BizIdentityInfo.prototype, "_featureControls", {
            get: $util.oneOfGetter($oneOfFields = ["featureControls"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         * @returns {proto.BizIdentityInfo} BizIdentityInfo instance
         */
        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vlevel != null && Object.hasOwnProperty.call(message, "vlevel"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.vlevel);
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.signed != null && Object.hasOwnProperty.call(message, "signed"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.signed);
            if (message.revoked != null && Object.hasOwnProperty.call(message, "revoked"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.revoked);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.hostStorage);
            if (message.actualActors != null && Object.hasOwnProperty.call(message, "actualActors"))
                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.actualActors);
            if (message.privacyModeTs != null && Object.hasOwnProperty.call(message, "privacyModeTs"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.privacyModeTs);
            if (message.featureControls != null && Object.hasOwnProperty.call(message, "featureControls"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint64(message.featureControls);
            return writer;
        };

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizIdentityInfo();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.vlevel = reader.int32();
                        break;
                    }
                case 2: {
                        message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                        break;
                    }
                case 3: {
                        message.signed = reader.bool();
                        break;
                    }
                case 4: {
                        message.revoked = reader.bool();
                        break;
                    }
                case 5: {
                        message.hostStorage = reader.int32();
                        break;
                    }
                case 6: {
                        message.actualActors = reader.int32();
                        break;
                    }
                case 7: {
                        message.privacyModeTs = reader.uint64();
                        break;
                    }
                case 8: {
                        message.featureControls = reader.uint64();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizIdentityInfo message.
         * @function verify
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizIdentityInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.vlevel != null && message.hasOwnProperty("vlevel")) {
                properties._vlevel = 1;
                switch (message.vlevel) {
                default:
                    return "vlevel: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                properties._vnameCert = 1;
                {
                    let error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                    if (error)
                        return "vnameCert." + error;
                }
            }
            if (message.signed != null && message.hasOwnProperty("signed")) {
                properties._signed = 1;
                if (typeof message.signed !== "boolean")
                    return "signed: boolean expected";
            }
            if (message.revoked != null && message.hasOwnProperty("revoked")) {
                properties._revoked = 1;
                if (typeof message.revoked !== "boolean")
                    return "revoked: boolean expected";
            }
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage")) {
                properties._hostStorage = 1;
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.actualActors != null && message.hasOwnProperty("actualActors")) {
                properties._actualActors = 1;
                switch (message.actualActors) {
                default:
                    return "actualActors: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs")) {
                properties._privacyModeTs = 1;
                if (!$util.isInteger(message.privacyModeTs) && !(message.privacyModeTs && $util.isInteger(message.privacyModeTs.low) && $util.isInteger(message.privacyModeTs.high)))
                    return "privacyModeTs: integer|Long expected";
            }
            if (message.featureControls != null && message.hasOwnProperty("featureControls")) {
                properties._featureControls = 1;
                if (!$util.isInteger(message.featureControls) && !(message.featureControls && $util.isInteger(message.featureControls.low) && $util.isInteger(message.featureControls.high)))
                    return "featureControls: integer|Long expected";
            }
            return null;
        };

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         */
        BizIdentityInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizIdentityInfo)
                return object;
            let message = new $root.proto.BizIdentityInfo();
            switch (object.vlevel) {
            default:
                if (typeof object.vlevel === "number") {
                    message.vlevel = object.vlevel;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                message.vlevel = 0;
                break;
            case "LOW":
            case 1:
                message.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                message.vlevel = 2;
                break;
            }
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.signed != null)
                message.signed = Boolean(object.signed);
            if (object.revoked != null)
                message.revoked = Boolean(object.revoked);
            switch (object.hostStorage) {
            default:
                if (typeof object.hostStorage === "number") {
                    message.hostStorage = object.hostStorage;
                    break;
                }
                break;
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.actualActors) {
            default:
                if (typeof object.actualActors === "number") {
                    message.actualActors = object.actualActors;
                    break;
                }
                break;
            case "SELF":
            case 0:
                message.actualActors = 0;
                break;
            case "BSP":
            case 1:
                message.actualActors = 1;
                break;
            }
            if (object.privacyModeTs != null)
                if ($util.Long)
                    (message.privacyModeTs = $util.Long.fromValue(object.privacyModeTs)).unsigned = true;
                else if (typeof object.privacyModeTs === "string")
                    message.privacyModeTs = parseInt(object.privacyModeTs, 10);
                else if (typeof object.privacyModeTs === "number")
                    message.privacyModeTs = object.privacyModeTs;
                else if (typeof object.privacyModeTs === "object")
                    message.privacyModeTs = new $util.LongBits(object.privacyModeTs.low >>> 0, object.privacyModeTs.high >>> 0).toNumber(true);
            if (object.featureControls != null)
                if ($util.Long)
                    (message.featureControls = $util.Long.fromValue(object.featureControls)).unsigned = true;
                else if (typeof object.featureControls === "string")
                    message.featureControls = parseInt(object.featureControls, 10);
                else if (typeof object.featureControls === "number")
                    message.featureControls = object.featureControls;
                else if (typeof object.featureControls === "object")
                    message.featureControls = new $util.LongBits(object.featureControls.low >>> 0, object.featureControls.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.BizIdentityInfo} message BizIdentityInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizIdentityInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.vlevel != null && message.hasOwnProperty("vlevel")) {
                object.vlevel = options.enums === String ? $root.proto.BizIdentityInfo.VerifiedLevelValue[message.vlevel] === undefined ? message.vlevel : $root.proto.BizIdentityInfo.VerifiedLevelValue[message.vlevel] : message.vlevel;
                if (options.oneofs)
                    object._vlevel = "vlevel";
            }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
                if (options.oneofs)
                    object._vnameCert = "vnameCert";
            }
            if (message.signed != null && message.hasOwnProperty("signed")) {
                object.signed = message.signed;
                if (options.oneofs)
                    object._signed = "signed";
            }
            if (message.revoked != null && message.hasOwnProperty("revoked")) {
                object.revoked = message.revoked;
                if (options.oneofs)
                    object._revoked = "revoked";
            }
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage")) {
                object.hostStorage = options.enums === String ? $root.proto.BizIdentityInfo.HostStorageType[message.hostStorage] === undefined ? message.hostStorage : $root.proto.BizIdentityInfo.HostStorageType[message.hostStorage] : message.hostStorage;
                if (options.oneofs)
                    object._hostStorage = "hostStorage";
            }
            if (message.actualActors != null && message.hasOwnProperty("actualActors")) {
                object.actualActors = options.enums === String ? $root.proto.BizIdentityInfo.ActualActorsType[message.actualActors] === undefined ? message.actualActors : $root.proto.BizIdentityInfo.ActualActorsType[message.actualActors] : message.actualActors;
                if (options.oneofs)
                    object._actualActors = "actualActors";
            }
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs")) {
                if (typeof message.privacyModeTs === "number")
                    object.privacyModeTs = options.longs === String ? String(message.privacyModeTs) : message.privacyModeTs;
                else
                    object.privacyModeTs = options.longs === String ? $util.Long.prototype.toString.call(message.privacyModeTs) : options.longs === Number ? new $util.LongBits(message.privacyModeTs.low >>> 0, message.privacyModeTs.high >>> 0).toNumber(true) : message.privacyModeTs;
                if (options.oneofs)
                    object._privacyModeTs = "privacyModeTs";
            }
            if (message.featureControls != null && message.hasOwnProperty("featureControls")) {
                if (typeof message.featureControls === "number")
                    object.featureControls = options.longs === String ? String(message.featureControls) : message.featureControls;
                else
                    object.featureControls = options.longs === String ? $util.Long.prototype.toString.call(message.featureControls) : options.longs === Number ? new $util.LongBits(message.featureControls.low >>> 0, message.featureControls.high >>> 0).toNumber(true) : message.featureControls;
                if (options.oneofs)
                    object._featureControls = "featureControls";
            }
            return object;
        };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @function toJSON
         * @memberof proto.BizIdentityInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BizIdentityInfo
         * @function getTypeUrl
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BizIdentityInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizIdentityInfo";
        };

        /**
         * ActualActorsType enum.
         * @name proto.BizIdentityInfo.ActualActorsType
         * @enum {number}
         * @property {number} SELF=0 SELF value
         * @property {number} BSP=1 BSP value
         */
        BizIdentityInfo.ActualActorsType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        /**
         * HostStorageType enum.
         * @name proto.BizIdentityInfo.HostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizIdentityInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * VerifiedLevelValue enum.
         * @name proto.BizIdentityInfo.VerifiedLevelValue
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} LOW=1 LOW value
         * @property {number} HIGH=2 HIGH value
         */
        BizIdentityInfo.VerifiedLevelValue = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.BotAgeCollectionMetadata = (function() {

        /**
         * Properties of a BotAgeCollectionMetadata.
         * @memberof proto
         * @interface IBotAgeCollectionMetadata
         * @property {boolean|null} [ageCollectionEligible] BotAgeCollectionMetadata ageCollectionEligible
         * @property {boolean|null} [shouldTriggerAgeCollectionOnClient] BotAgeCollectionMetadata shouldTriggerAgeCollectionOnClient
         */

        /**
         * Constructs a new BotAgeCollectionMetadata.
         * @memberof proto
         * @classdesc Represents a BotAgeCollectionMetadata.
         * @implements IBotAgeCollectionMetadata
         * @constructor
         * @param {proto.IBotAgeCollectionMetadata=} [properties] Properties to set
         */
        function BotAgeCollectionMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotAgeCollectionMetadata ageCollectionEligible.
         * @member {boolean|null|undefined} ageCollectionEligible
         * @memberof proto.BotAgeCollectionMetadata
         * @instance
         */
        BotAgeCollectionMetadata.prototype.ageCollectionEligible = null;

        /**
         * BotAgeCollectionMetadata shouldTriggerAgeCollectionOnClient.
         * @member {boolean|null|undefined} shouldTriggerAgeCollectionOnClient
         * @memberof proto.BotAgeCollectionMetadata
         * @instance
         */
        BotAgeCollectionMetadata.prototype.shouldTriggerAgeCollectionOnClient = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_ageCollectionEligible", {
            get: $util.oneOfGetter($oneOfFields = ["ageCollectionEligible"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAgeCollectionMetadata.prototype, "_shouldTriggerAgeCollectionOnClient", {
            get: $util.oneOfGetter($oneOfFields = ["shouldTriggerAgeCollectionOnClient"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotAgeCollectionMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {proto.IBotAgeCollectionMetadata=} [properties] Properties to set
         * @returns {proto.BotAgeCollectionMetadata} BotAgeCollectionMetadata instance
         */
        BotAgeCollectionMetadata.create = function create(properties) {
            return new BotAgeCollectionMetadata(properties);
        };

        /**
         * Encodes the specified BotAgeCollectionMetadata message. Does not implicitly {@link proto.BotAgeCollectionMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {proto.IBotAgeCollectionMetadata} message BotAgeCollectionMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotAgeCollectionMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ageCollectionEligible != null && Object.hasOwnProperty.call(message, "ageCollectionEligible"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.ageCollectionEligible);
            if (message.shouldTriggerAgeCollectionOnClient != null && Object.hasOwnProperty.call(message, "shouldTriggerAgeCollectionOnClient"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.shouldTriggerAgeCollectionOnClient);
            return writer;
        };

        /**
         * Encodes the specified BotAgeCollectionMetadata message, length delimited. Does not implicitly {@link proto.BotAgeCollectionMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {proto.IBotAgeCollectionMetadata} message BotAgeCollectionMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotAgeCollectionMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotAgeCollectionMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotAgeCollectionMetadata} BotAgeCollectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotAgeCollectionMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotAgeCollectionMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.ageCollectionEligible = reader.bool();
                        break;
                    }
                case 2: {
                        message.shouldTriggerAgeCollectionOnClient = reader.bool();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotAgeCollectionMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotAgeCollectionMetadata} BotAgeCollectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotAgeCollectionMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotAgeCollectionMetadata message.
         * @function verify
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotAgeCollectionMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.ageCollectionEligible != null && message.hasOwnProperty("ageCollectionEligible")) {
                properties._ageCollectionEligible = 1;
                if (typeof message.ageCollectionEligible !== "boolean")
                    return "ageCollectionEligible: boolean expected";
            }
            if (message.shouldTriggerAgeCollectionOnClient != null && message.hasOwnProperty("shouldTriggerAgeCollectionOnClient")) {
                properties._shouldTriggerAgeCollectionOnClient = 1;
                if (typeof message.shouldTriggerAgeCollectionOnClient !== "boolean")
                    return "shouldTriggerAgeCollectionOnClient: boolean expected";
            }
            return null;
        };

        /**
         * Creates a BotAgeCollectionMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotAgeCollectionMetadata} BotAgeCollectionMetadata
         */
        BotAgeCollectionMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotAgeCollectionMetadata)
                return object;
            let message = new $root.proto.BotAgeCollectionMetadata();
            if (object.ageCollectionEligible != null)
                message.ageCollectionEligible = Boolean(object.ageCollectionEligible);
            if (object.shouldTriggerAgeCollectionOnClient != null)
                message.shouldTriggerAgeCollectionOnClient = Boolean(object.shouldTriggerAgeCollectionOnClient);
            return message;
        };

        /**
         * Creates a plain object from a BotAgeCollectionMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {proto.BotAgeCollectionMetadata} message BotAgeCollectionMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotAgeCollectionMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.ageCollectionEligible != null && message.hasOwnProperty("ageCollectionEligible")) {
                object.ageCollectionEligible = message.ageCollectionEligible;
                if (options.oneofs)
                    object._ageCollectionEligible = "ageCollectionEligible";
            }
            if (message.shouldTriggerAgeCollectionOnClient != null && message.hasOwnProperty("shouldTriggerAgeCollectionOnClient")) {
                object.shouldTriggerAgeCollectionOnClient = message.shouldTriggerAgeCollectionOnClient;
                if (options.oneofs)
                    object._shouldTriggerAgeCollectionOnClient = "shouldTriggerAgeCollectionOnClient";
            }
            return object;
        };

        /**
         * Converts this BotAgeCollectionMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotAgeCollectionMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotAgeCollectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotAgeCollectionMetadata
         * @function getTypeUrl
         * @memberof proto.BotAgeCollectionMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotAgeCollectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAgeCollectionMetadata";
        };

        return BotAgeCollectionMetadata;
    })();

    proto.BotAvatarMetadata = (function() {

        /**
         * Properties of a BotAvatarMetadata.
         * @memberof proto
         * @interface IBotAvatarMetadata
         * @property {number|null} [sentiment] BotAvatarMetadata sentiment
         * @property {string|null} [behaviorGraph] BotAvatarMetadata behaviorGraph
         * @property {number|null} [action] BotAvatarMetadata action
         * @property {number|null} [intensity] BotAvatarMetadata intensity
         * @property {number|null} [wordCount] BotAvatarMetadata wordCount
         */

        /**
         * Constructs a new BotAvatarMetadata.
         * @memberof proto
         * @classdesc Represents a BotAvatarMetadata.
         * @implements IBotAvatarMetadata
         * @constructor
         * @param {proto.IBotAvatarMetadata=} [properties] Properties to set
         */
        function BotAvatarMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotAvatarMetadata sentiment.
         * @member {number|null|undefined} sentiment
         * @memberof proto.BotAvatarMetadata
         * @instance
         */
        BotAvatarMetadata.prototype.sentiment = null;

        /**
         * BotAvatarMetadata behaviorGraph.
         * @member {string|null|undefined} behaviorGraph
         * @memberof proto.BotAvatarMetadata
         * @instance
         */
        BotAvatarMetadata.prototype.behaviorGraph = null;

        /**
         * BotAvatarMetadata action.
         * @member {number|null|undefined} action
         * @memberof proto.BotAvatarMetadata
         * @instance
         */
        BotAvatarMetadata.prototype.action = null;

        /**
         * BotAvatarMetadata intensity.
         * @member {number|null|undefined} intensity
         * @memberof proto.BotAvatarMetadata
         * @instance
         */
        BotAvatarMetadata.prototype.intensity = null;

        /**
         * BotAvatarMetadata wordCount.
         * @member {number|null|undefined} wordCount
         * @memberof proto.BotAvatarMetadata
         * @instance
         */
        BotAvatarMetadata.prototype.wordCount = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_sentiment", {
            get: $util.oneOfGetter($oneOfFields = ["sentiment"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_behaviorGraph", {
            get: $util.oneOfGetter($oneOfFields = ["behaviorGraph"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_intensity", {
            get: $util.oneOfGetter($oneOfFields = ["intensity"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotAvatarMetadata.prototype, "_wordCount", {
            get: $util.oneOfGetter($oneOfFields = ["wordCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotAvatarMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {proto.IBotAvatarMetadata=} [properties] Properties to set
         * @returns {proto.BotAvatarMetadata} BotAvatarMetadata instance
         */
        BotAvatarMetadata.create = function create(properties) {
            return new BotAvatarMetadata(properties);
        };

        /**
         * Encodes the specified BotAvatarMetadata message. Does not implicitly {@link proto.BotAvatarMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {proto.IBotAvatarMetadata} message BotAvatarMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotAvatarMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.sentiment != null && Object.hasOwnProperty.call(message, "sentiment"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.sentiment);
            if (message.behaviorGraph != null && Object.hasOwnProperty.call(message, "behaviorGraph"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.behaviorGraph);
            if (message.action != null && Object.hasOwnProperty.call(message, "action"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.action);
            if (message.intensity != null && Object.hasOwnProperty.call(message, "intensity"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.intensity);
            if (message.wordCount != null && Object.hasOwnProperty.call(message, "wordCount"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.wordCount);
            return writer;
        };

        /**
         * Encodes the specified BotAvatarMetadata message, length delimited. Does not implicitly {@link proto.BotAvatarMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {proto.IBotAvatarMetadata} message BotAvatarMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotAvatarMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotAvatarMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotAvatarMetadata} BotAvatarMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotAvatarMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotAvatarMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.sentiment = reader.uint32();
                        break;
                    }
                case 2: {
                        message.behaviorGraph = reader.string();
                        break;
                    }
                case 3: {
                        message.action = reader.uint32();
                        break;
                    }
                case 4: {
                        message.intensity = reader.uint32();
                        break;
                    }
                case 5: {
                        message.wordCount = reader.uint32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotAvatarMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotAvatarMetadata} BotAvatarMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotAvatarMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotAvatarMetadata message.
         * @function verify
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotAvatarMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.sentiment != null && message.hasOwnProperty("sentiment")) {
                properties._sentiment = 1;
                if (!$util.isInteger(message.sentiment))
                    return "sentiment: integer expected";
            }
            if (message.behaviorGraph != null && message.hasOwnProperty("behaviorGraph")) {
                properties._behaviorGraph = 1;
                if (!$util.isString(message.behaviorGraph))
                    return "behaviorGraph: string expected";
            }
            if (message.action != null && message.hasOwnProperty("action")) {
                properties._action = 1;
                if (!$util.isInteger(message.action))
                    return "action: integer expected";
            }
            if (message.intensity != null && message.hasOwnProperty("intensity")) {
                properties._intensity = 1;
                if (!$util.isInteger(message.intensity))
                    return "intensity: integer expected";
            }
            if (message.wordCount != null && message.hasOwnProperty("wordCount")) {
                properties._wordCount = 1;
                if (!$util.isInteger(message.wordCount))
                    return "wordCount: integer expected";
            }
            return null;
        };

        /**
         * Creates a BotAvatarMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotAvatarMetadata} BotAvatarMetadata
         */
        BotAvatarMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotAvatarMetadata)
                return object;
            let message = new $root.proto.BotAvatarMetadata();
            if (object.sentiment != null)
                message.sentiment = object.sentiment >>> 0;
            if (object.behaviorGraph != null)
                message.behaviorGraph = String(object.behaviorGraph);
            if (object.action != null)
                message.action = object.action >>> 0;
            if (object.intensity != null)
                message.intensity = object.intensity >>> 0;
            if (object.wordCount != null)
                message.wordCount = object.wordCount >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a BotAvatarMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {proto.BotAvatarMetadata} message BotAvatarMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotAvatarMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.sentiment != null && message.hasOwnProperty("sentiment")) {
                object.sentiment = message.sentiment;
                if (options.oneofs)
                    object._sentiment = "sentiment";
            }
            if (message.behaviorGraph != null && message.hasOwnProperty("behaviorGraph")) {
                object.behaviorGraph = message.behaviorGraph;
                if (options.oneofs)
                    object._behaviorGraph = "behaviorGraph";
            }
            if (message.action != null && message.hasOwnProperty("action")) {
                object.action = message.action;
                if (options.oneofs)
                    object._action = "action";
            }
            if (message.intensity != null && message.hasOwnProperty("intensity")) {
                object.intensity = message.intensity;
                if (options.oneofs)
                    object._intensity = "intensity";
            }
            if (message.wordCount != null && message.hasOwnProperty("wordCount")) {
                object.wordCount = message.wordCount;
                if (options.oneofs)
                    object._wordCount = "wordCount";
            }
            return object;
        };

        /**
         * Converts this BotAvatarMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotAvatarMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotAvatarMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotAvatarMetadata
         * @function getTypeUrl
         * @memberof proto.BotAvatarMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotAvatarMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAvatarMetadata";
        };

        return BotAvatarMetadata;
    })();

    proto.BotCapabilityMetadata = (function() {

        /**
         * Properties of a BotCapabilityMetadata.
         * @memberof proto
         * @interface IBotCapabilityMetadata
         * @property {Array.<proto.BotCapabilityMetadata.BotCapabilityType>|null} [capabilities] BotCapabilityMetadata capabilities
         */

        /**
         * Constructs a new BotCapabilityMetadata.
         * @memberof proto
         * @classdesc Represents a BotCapabilityMetadata.
         * @implements IBotCapabilityMetadata
         * @constructor
         * @param {proto.IBotCapabilityMetadata=} [properties] Properties to set
         */
        function BotCapabilityMetadata(properties) {
            this.capabilities = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotCapabilityMetadata capabilities.
         * @member {Array.<proto.BotCapabilityMetadata.BotCapabilityType>} capabilities
         * @memberof proto.BotCapabilityMetadata
         * @instance
         */
        BotCapabilityMetadata.prototype.capabilities = $util.emptyArray;

        /**
         * Creates a new BotCapabilityMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {proto.IBotCapabilityMetadata=} [properties] Properties to set
         * @returns {proto.BotCapabilityMetadata} BotCapabilityMetadata instance
         */
        BotCapabilityMetadata.create = function create(properties) {
            return new BotCapabilityMetadata(properties);
        };

        /**
         * Encodes the specified BotCapabilityMetadata message. Does not implicitly {@link proto.BotCapabilityMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {proto.IBotCapabilityMetadata} message BotCapabilityMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotCapabilityMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.capabilities != null && message.capabilities.length) {
                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                for (let i = 0; i < message.capabilities.length; ++i)
                    writer.int32(message.capabilities[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified BotCapabilityMetadata message, length delimited. Does not implicitly {@link proto.BotCapabilityMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {proto.IBotCapabilityMetadata} message BotCapabilityMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotCapabilityMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotCapabilityMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotCapabilityMetadata} BotCapabilityMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotCapabilityMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotCapabilityMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.capabilities && message.capabilities.length))
                            message.capabilities = [];
                        if ((tag & 7) === 2) {
                            let end2 = reader.uint32() + reader.pos;
                            while (reader.pos < end2)
                                message.capabilities.push(reader.int32());
                        } else
                            message.capabilities.push(reader.int32());
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotCapabilityMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotCapabilityMetadata} BotCapabilityMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotCapabilityMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotCapabilityMetadata message.
         * @function verify
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotCapabilityMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.capabilities != null && message.hasOwnProperty("capabilities")) {
                if (!Array.isArray(message.capabilities))
                    return "capabilities: array expected";
                for (let i = 0; i < message.capabilities.length; ++i)
                    switch (message.capabilities[i]) {
                    default:
                        return "capabilities: enum value[] expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                    case 11:
                    case 12:
                    case 13:
                    case 14:
                    case 15:
                    case 16:
                    case 17:
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                    case 22:
                    case 23:
                    case 24:
                    case 25:
                    case 26:
                    case 27:
                    case 28:
                    case 29:
                    case 30:
                    case 31:
                    case 32:
                    case 33:
                    case 34:
                    case 35:
                        break;
                    }
            }
            return null;
        };

        /**
         * Creates a BotCapabilityMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotCapabilityMetadata} BotCapabilityMetadata
         */
        BotCapabilityMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotCapabilityMetadata)
                return object;
            let message = new $root.proto.BotCapabilityMetadata();
            if (object.capabilities) {
                if (!Array.isArray(object.capabilities))
                    throw TypeError(".proto.BotCapabilityMetadata.capabilities: array expected");
                message.capabilities = [];
                for (let i = 0; i < object.capabilities.length; ++i)
                    switch (object.capabilities[i]) {
                    default:
                        if (typeof object.capabilities[i] === "number") {
                            message.capabilities[i] = object.capabilities[i];
                            break;
                        }
                    case "UNKNOWN":
                    case 0:
                        message.capabilities[i] = 0;
                        break;
                    case "PROGRESS_INDICATOR":
                    case 1:
                        message.capabilities[i] = 1;
                        break;
                    case "RICH_RESPONSE_HEADING":
                    case 2:
                        message.capabilities[i] = 2;
                        break;
                    case "RICH_RESPONSE_NESTED_LIST":
                    case 3:
                        message.capabilities[i] = 3;
                        break;
                    case "AI_MEMORY":
                    case 4:
                        message.capabilities[i] = 4;
                        break;
                    case "RICH_RESPONSE_THREAD_SURFING":
                    case 5:
                        message.capabilities[i] = 5;
                        break;
                    case "RICH_RESPONSE_TABLE":
                    case 6:
                        message.capabilities[i] = 6;
                        break;
                    case "RICH_RESPONSE_CODE":
                    case 7:
                        message.capabilities[i] = 7;
                        break;
                    case "RICH_RESPONSE_STRUCTURED_RESPONSE":
                    case 8:
                        message.capabilities[i] = 8;
                        break;
                    case "RICH_RESPONSE_INLINE_IMAGE":
                    case 9:
                        message.capabilities[i] = 9;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_CONTROL":
                    case 10:
                        message.capabilities[i] = 10;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_1":
                    case 11:
                        message.capabilities[i] = 11;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_2":
                    case 12:
                        message.capabilities[i] = 12;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_3":
                    case 13:
                        message.capabilities[i] = 13;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_4":
                    case 14:
                        message.capabilities[i] = 14;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_5":
                    case 15:
                        message.capabilities[i] = 15;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_6":
                    case 16:
                        message.capabilities[i] = 16;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_7":
                    case 17:
                        message.capabilities[i] = 17;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_8":
                    case 18:
                        message.capabilities[i] = 18;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_9":
                    case 19:
                        message.capabilities[i] = 19;
                        break;
                    case "WA_IG_1P_PLUGIN_RANKING_UPDATE_10":
                    case 20:
                        message.capabilities[i] = 20;
                        break;
                    case "RICH_RESPONSE_SUB_HEADING":
                    case 21:
                        message.capabilities[i] = 21;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE":
                    case 22:
                        message.capabilities[i] = 22;
                        break;
                    case "AI_STUDIO_UGC_MEMORY":
                    case 23:
                        message.capabilities[i] = 23;
                        break;
                    case "RICH_RESPONSE_LATEX":
                    case 24:
                        message.capabilities[i] = 24;
                        break;
                    case "RICH_RESPONSE_MAPS":
                    case 25:
                        message.capabilities[i] = 25;
                        break;
                    case "RICH_RESPONSE_INLINE_REELS":
                    case 26:
                        message.capabilities[i] = 26;
                        break;
                    case "AGENTIC_PLANNING":
                    case 27:
                        message.capabilities[i] = 27;
                        break;
                    case "ACCOUNT_LINKING":
                    case 28:
                        message.capabilities[i] = 28;
                        break;
                    case "STREAMING_DISAGGREGATION":
                    case 29:
                        message.capabilities[i] = 29;
                        break;
                    case "RICH_RESPONSE_GRID_IMAGE_3P":
                    case 30:
                        message.capabilities[i] = 30;
                        break;
                    case "RICH_RESPONSE_LATEX_INLINE":
                    case 31:
                        message.capabilities[i] = 31;
                        break;
                    case "QUERY_PLAN":
                    case 32:
                        message.capabilities[i] = 32;
                        break;
                    case "PROACTIVE_MESSAGE":
                    case 33:
                        message.capabilities[i] = 33;
                        break;
                    case "RICH_RESPONSE_UNIFIED_RESPONSE":
                    case 34:
                        message.capabilities[i] = 34;
                        break;
                    case "PROMOTION_MESSAGE":
                    case 35:
                        message.capabilities[i] = 35;
                        break;
                    }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotCapabilityMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {proto.BotCapabilityMetadata} message BotCapabilityMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotCapabilityMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.capabilities = [];
            if (message.capabilities && message.capabilities.length) {
                object.capabilities = [];
                for (let j = 0; j < message.capabilities.length; ++j)
                    object.capabilities[j] = options.enums === String ? $root.proto.BotCapabilityMetadata.BotCapabilityType[message.capabilities[j]] === undefined ? message.capabilities[j] : $root.proto.BotCapabilityMetadata.BotCapabilityType[message.capabilities[j]] : message.capabilities[j];
            }
            return object;
        };

        /**
         * Converts this BotCapabilityMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotCapabilityMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotCapabilityMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotCapabilityMetadata
         * @function getTypeUrl
         * @memberof proto.BotCapabilityMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotCapabilityMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotCapabilityMetadata";
        };

        /**
         * BotCapabilityType enum.
         * @name proto.BotCapabilityMetadata.BotCapabilityType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} PROGRESS_INDICATOR=1 PROGRESS_INDICATOR value
         * @property {number} RICH_RESPONSE_HEADING=2 RICH_RESPONSE_HEADING value
         * @property {number} RICH_RESPONSE_NESTED_LIST=3 RICH_RESPONSE_NESTED_LIST value
         * @property {number} AI_MEMORY=4 AI_MEMORY value
         * @property {number} RICH_RESPONSE_THREAD_SURFING=5 RICH_RESPONSE_THREAD_SURFING value
         * @property {number} RICH_RESPONSE_TABLE=6 RICH_RESPONSE_TABLE value
         * @property {number} RICH_RESPONSE_CODE=7 RICH_RESPONSE_CODE value
         * @property {number} RICH_RESPONSE_STRUCTURED_RESPONSE=8 RICH_RESPONSE_STRUCTURED_RESPONSE value
         * @property {number} RICH_RESPONSE_INLINE_IMAGE=9 RICH_RESPONSE_INLINE_IMAGE value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_CONTROL=10 WA_IG_1P_PLUGIN_RANKING_CONTROL value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_1=11 WA_IG_1P_PLUGIN_RANKING_UPDATE_1 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_2=12 WA_IG_1P_PLUGIN_RANKING_UPDATE_2 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_3=13 WA_IG_1P_PLUGIN_RANKING_UPDATE_3 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_4=14 WA_IG_1P_PLUGIN_RANKING_UPDATE_4 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_5=15 WA_IG_1P_PLUGIN_RANKING_UPDATE_5 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_6=16 WA_IG_1P_PLUGIN_RANKING_UPDATE_6 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_7=17 WA_IG_1P_PLUGIN_RANKING_UPDATE_7 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_8=18 WA_IG_1P_PLUGIN_RANKING_UPDATE_8 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_9=19 WA_IG_1P_PLUGIN_RANKING_UPDATE_9 value
         * @property {number} WA_IG_1P_PLUGIN_RANKING_UPDATE_10=20 WA_IG_1P_PLUGIN_RANKING_UPDATE_10 value
         * @property {number} RICH_RESPONSE_SUB_HEADING=21 RICH_RESPONSE_SUB_HEADING value
         * @property {number} RICH_RESPONSE_GRID_IMAGE=22 RICH_RESPONSE_GRID_IMAGE value
         * @property {number} AI_STUDIO_UGC_MEMORY=23 AI_STUDIO_UGC_MEMORY value
         * @property {number} RICH_RESPONSE_LATEX=24 RICH_RESPONSE_LATEX value
         * @property {number} RICH_RESPONSE_MAPS=25 RICH_RESPONSE_MAPS value
         * @property {number} RICH_RESPONSE_INLINE_REELS=26 RICH_RESPONSE_INLINE_REELS value
         * @property {number} AGENTIC_PLANNING=27 AGENTIC_PLANNING value
         * @property {number} ACCOUNT_LINKING=28 ACCOUNT_LINKING value
         * @property {number} STREAMING_DISAGGREGATION=29 STREAMING_DISAGGREGATION value
         * @property {number} RICH_RESPONSE_GRID_IMAGE_3P=30 RICH_RESPONSE_GRID_IMAGE_3P value
         * @property {number} RICH_RESPONSE_LATEX_INLINE=31 RICH_RESPONSE_LATEX_INLINE value
         * @property {number} QUERY_PLAN=32 QUERY_PLAN value
         * @property {number} PROACTIVE_MESSAGE=33 PROACTIVE_MESSAGE value
         * @property {number} RICH_RESPONSE_UNIFIED_RESPONSE=34 RICH_RESPONSE_UNIFIED_RESPONSE value
         * @property {number} PROMOTION_MESSAGE=35 PROMOTION_MESSAGE value
         */
        BotCapabilityMetadata.BotCapabilityType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "PROGRESS_INDICATOR"] = 1;
            values[valuesById[2] = "RICH_RESPONSE_HEADING"] = 2;
            values[valuesById[3] = "RICH_RESPONSE_NESTED_LIST"] = 3;
            values[valuesById[4] = "AI_MEMORY"] = 4;
            values[valuesById[5] = "RICH_RESPONSE_THREAD_SURFING"] = 5;
            values[valuesById[6] = "RICH_RESPONSE_TABLE"] = 6;
            values[valuesById[7] = "RICH_RESPONSE_CODE"] = 7;
            values[valuesById[8] = "RICH_RESPONSE_STRUCTURED_RESPONSE"] = 8;
            values[valuesById[9] = "RICH_RESPONSE_INLINE_IMAGE"] = 9;
            values[valuesById[10] = "WA_IG_1P_PLUGIN_RANKING_CONTROL"] = 10;
            values[valuesById[11] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_1"] = 11;
            values[valuesById[12] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_2"] = 12;
            values[valuesById[13] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_3"] = 13;
            values[valuesById[14] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_4"] = 14;
            values[valuesById[15] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_5"] = 15;
            values[valuesById[16] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_6"] = 16;
            values[valuesById[17] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_7"] = 17;
            values[valuesById[18] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_8"] = 18;
            values[valuesById[19] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_9"] = 19;
            values[valuesById[20] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_10"] = 20;
            values[valuesById[21] = "RICH_RESPONSE_SUB_HEADING"] = 21;
            values[valuesById[22] = "RICH_RESPONSE_GRID_IMAGE"] = 22;
            values[valuesById[23] = "AI_STUDIO_UGC_MEMORY"] = 23;
            values[valuesById[24] = "RICH_RESPONSE_LATEX"] = 24;
            values[valuesById[25] = "RICH_RESPONSE_MAPS"] = 25;
            values[valuesById[26] = "RICH_RESPONSE_INLINE_REELS"] = 26;
            values[valuesById[27] = "AGENTIC_PLANNING"] = 27;
            values[valuesById[28] = "ACCOUNT_LINKING"] = 28;
            values[valuesById[29] = "STREAMING_DISAGGREGATION"] = 29;
            values[valuesById[30] = "RICH_RESPONSE_GRID_IMAGE_3P"] = 30;
            values[valuesById[31] = "RICH_RESPONSE_LATEX_INLINE"] = 31;
            values[valuesById[32] = "QUERY_PLAN"] = 32;
            values[valuesById[33] = "PROACTIVE_MESSAGE"] = 33;
            values[valuesById[34] = "RICH_RESPONSE_UNIFIED_RESPONSE"] = 34;
            values[valuesById[35] = "PROMOTION_MESSAGE"] = 35;
            return values;
        })();

        return BotCapabilityMetadata;
    })();

    proto.BotImagineMetadata = (function() {

        /**
         * Properties of a BotImagineMetadata.
         * @memberof proto
         * @interface IBotImagineMetadata
         * @property {proto.BotImagineMetadata.ImagineType|null} [imagineType] BotImagineMetadata imagineType
         */

        /**
         * Constructs a new BotImagineMetadata.
         * @memberof proto
         * @classdesc Represents a BotImagineMetadata.
         * @implements IBotImagineMetadata
         * @constructor
         * @param {proto.IBotImagineMetadata=} [properties] Properties to set
         */
        function BotImagineMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotImagineMetadata imagineType.
         * @member {proto.BotImagineMetadata.ImagineType|null|undefined} imagineType
         * @memberof proto.BotImagineMetadata
         * @instance
         */
        BotImagineMetadata.prototype.imagineType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotImagineMetadata.prototype, "_imagineType", {
            get: $util.oneOfGetter($oneOfFields = ["imagineType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotImagineMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {proto.IBotImagineMetadata=} [properties] Properties to set
         * @returns {proto.BotImagineMetadata} BotImagineMetadata instance
         */
        BotImagineMetadata.create = function create(properties) {
            return new BotImagineMetadata(properties);
        };

        /**
         * Encodes the specified BotImagineMetadata message. Does not implicitly {@link proto.BotImagineMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {proto.IBotImagineMetadata} message BotImagineMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotImagineMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.imagineType != null && Object.hasOwnProperty.call(message, "imagineType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.imagineType);
            return writer;
        };

        /**
         * Encodes the specified BotImagineMetadata message, length delimited. Does not implicitly {@link proto.BotImagineMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {proto.IBotImagineMetadata} message BotImagineMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotImagineMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotImagineMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotImagineMetadata} BotImagineMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotImagineMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotImagineMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.imagineType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotImagineMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotImagineMetadata} BotImagineMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotImagineMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotImagineMetadata message.
         * @function verify
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotImagineMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.imagineType != null && message.hasOwnProperty("imagineType")) {
                properties._imagineType = 1;
                switch (message.imagineType) {
                default:
                    return "imagineType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotImagineMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotImagineMetadata} BotImagineMetadata
         */
        BotImagineMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotImagineMetadata)
                return object;
            let message = new $root.proto.BotImagineMetadata();
            switch (object.imagineType) {
            default:
                if (typeof object.imagineType === "number") {
                    message.imagineType = object.imagineType;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                message.imagineType = 0;
                break;
            case "IMAGINE":
            case 1:
                message.imagineType = 1;
                break;
            case "MEMU":
            case 2:
                message.imagineType = 2;
                break;
            case "FLASH":
            case 3:
                message.imagineType = 3;
                break;
            case "EDIT":
            case 4:
                message.imagineType = 4;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotImagineMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {proto.BotImagineMetadata} message BotImagineMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotImagineMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.imagineType != null && message.hasOwnProperty("imagineType")) {
                object.imagineType = options.enums === String ? $root.proto.BotImagineMetadata.ImagineType[message.imagineType] === undefined ? message.imagineType : $root.proto.BotImagineMetadata.ImagineType[message.imagineType] : message.imagineType;
                if (options.oneofs)
                    object._imagineType = "imagineType";
            }
            return object;
        };

        /**
         * Converts this BotImagineMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotImagineMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotImagineMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotImagineMetadata
         * @function getTypeUrl
         * @memberof proto.BotImagineMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotImagineMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotImagineMetadata";
        };

        /**
         * ImagineType enum.
         * @name proto.BotImagineMetadata.ImagineType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} IMAGINE=1 IMAGINE value
         * @property {number} MEMU=2 MEMU value
         * @property {number} FLASH=3 FLASH value
         * @property {number} EDIT=4 EDIT value
         */
        BotImagineMetadata.ImagineType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "IMAGINE"] = 1;
            values[valuesById[2] = "MEMU"] = 2;
            values[valuesById[3] = "FLASH"] = 3;
            values[valuesById[4] = "EDIT"] = 4;
            return values;
        })();

        return BotImagineMetadata;
    })();

    proto.BotLinkedAccount = (function() {

        /**
         * Properties of a BotLinkedAccount.
         * @memberof proto
         * @interface IBotLinkedAccount
         * @property {proto.BotLinkedAccount.BotLinkedAccountType|null} [type] BotLinkedAccount type
         */

        /**
         * Constructs a new BotLinkedAccount.
         * @memberof proto
         * @classdesc Represents a BotLinkedAccount.
         * @implements IBotLinkedAccount
         * @constructor
         * @param {proto.IBotLinkedAccount=} [properties] Properties to set
         */
        function BotLinkedAccount(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotLinkedAccount type.
         * @member {proto.BotLinkedAccount.BotLinkedAccountType|null|undefined} type
         * @memberof proto.BotLinkedAccount
         * @instance
         */
        BotLinkedAccount.prototype.type = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccount.prototype, "_type", {
            get: $util.oneOfGetter($oneOfFields = ["type"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotLinkedAccount instance using the specified properties.
         * @function create
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {proto.IBotLinkedAccount=} [properties] Properties to set
         * @returns {proto.BotLinkedAccount} BotLinkedAccount instance
         */
        BotLinkedAccount.create = function create(properties) {
            return new BotLinkedAccount(properties);
        };

        /**
         * Encodes the specified BotLinkedAccount message. Does not implicitly {@link proto.BotLinkedAccount.verify|verify} messages.
         * @function encode
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {proto.IBotLinkedAccount} message BotLinkedAccount message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotLinkedAccount.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
            return writer;
        };

        /**
         * Encodes the specified BotLinkedAccount message, length delimited. Does not implicitly {@link proto.BotLinkedAccount.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {proto.IBotLinkedAccount} message BotLinkedAccount message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotLinkedAccount.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotLinkedAccount message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotLinkedAccount} BotLinkedAccount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotLinkedAccount.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotLinkedAccount();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.type = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotLinkedAccount message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotLinkedAccount} BotLinkedAccount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotLinkedAccount.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotLinkedAccount message.
         * @function verify
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotLinkedAccount.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.type != null && message.hasOwnProperty("type")) {
                properties._type = 1;
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotLinkedAccount message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotLinkedAccount} BotLinkedAccount
         */
        BotLinkedAccount.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotLinkedAccount)
                return object;
            let message = new $root.proto.BotLinkedAccount();
            switch (object.type) {
            default:
                if (typeof object.type === "number") {
                    message.type = object.type;
                    break;
                }
                break;
            case "BOT_LINKED_ACCOUNT_TYPE_1P":
            case 0:
                message.type = 0;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotLinkedAccount message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {proto.BotLinkedAccount} message BotLinkedAccount
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotLinkedAccount.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.type != null && message.hasOwnProperty("type")) {
                object.type = options.enums === String ? $root.proto.BotLinkedAccount.BotLinkedAccountType[message.type] === undefined ? message.type : $root.proto.BotLinkedAccount.BotLinkedAccountType[message.type] : message.type;
                if (options.oneofs)
                    object._type = "type";
            }
            return object;
        };

        /**
         * Converts this BotLinkedAccount to JSON.
         * @function toJSON
         * @memberof proto.BotLinkedAccount
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotLinkedAccount.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotLinkedAccount
         * @function getTypeUrl
         * @memberof proto.BotLinkedAccount
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotLinkedAccount.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccount";
        };

        /**
         * BotLinkedAccountType enum.
         * @name proto.BotLinkedAccount.BotLinkedAccountType
         * @enum {number}
         * @property {number} BOT_LINKED_ACCOUNT_TYPE_1P=0 BOT_LINKED_ACCOUNT_TYPE_1P value
         */
        BotLinkedAccount.BotLinkedAccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_LINKED_ACCOUNT_TYPE_1P"] = 0;
            return values;
        })();

        return BotLinkedAccount;
    })();

    proto.BotLinkedAccountsMetadata = (function() {

        /**
         * Properties of a BotLinkedAccountsMetadata.
         * @memberof proto
         * @interface IBotLinkedAccountsMetadata
         * @property {Array.<proto.IBotLinkedAccount>|null} [accounts] BotLinkedAccountsMetadata accounts
         * @property {Uint8Array|null} [acAuthTokens] BotLinkedAccountsMetadata acAuthTokens
         * @property {number|null} [acErrorCode] BotLinkedAccountsMetadata acErrorCode
         */

        /**
         * Constructs a new BotLinkedAccountsMetadata.
         * @memberof proto
         * @classdesc Represents a BotLinkedAccountsMetadata.
         * @implements IBotLinkedAccountsMetadata
         * @constructor
         * @param {proto.IBotLinkedAccountsMetadata=} [properties] Properties to set
         */
        function BotLinkedAccountsMetadata(properties) {
            this.accounts = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotLinkedAccountsMetadata accounts.
         * @member {Array.<proto.IBotLinkedAccount>} accounts
         * @memberof proto.BotLinkedAccountsMetadata
         * @instance
         */
        BotLinkedAccountsMetadata.prototype.accounts = $util.emptyArray;

        /**
         * BotLinkedAccountsMetadata acAuthTokens.
         * @member {Uint8Array|null|undefined} acAuthTokens
         * @memberof proto.BotLinkedAccountsMetadata
         * @instance
         */
        BotLinkedAccountsMetadata.prototype.acAuthTokens = null;

        /**
         * BotLinkedAccountsMetadata acErrorCode.
         * @member {number|null|undefined} acErrorCode
         * @memberof proto.BotLinkedAccountsMetadata
         * @instance
         */
        BotLinkedAccountsMetadata.prototype.acErrorCode = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acAuthTokens", {
            get: $util.oneOfGetter($oneOfFields = ["acAuthTokens"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotLinkedAccountsMetadata.prototype, "_acErrorCode", {
            get: $util.oneOfGetter($oneOfFields = ["acErrorCode"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotLinkedAccountsMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {proto.IBotLinkedAccountsMetadata=} [properties] Properties to set
         * @returns {proto.BotLinkedAccountsMetadata} BotLinkedAccountsMetadata instance
         */
        BotLinkedAccountsMetadata.create = function create(properties) {
            return new BotLinkedAccountsMetadata(properties);
        };

        /**
         * Encodes the specified BotLinkedAccountsMetadata message. Does not implicitly {@link proto.BotLinkedAccountsMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {proto.IBotLinkedAccountsMetadata} message BotLinkedAccountsMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotLinkedAccountsMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.accounts != null && message.accounts.length)
                for (let i = 0; i < message.accounts.length; ++i)
                    $root.proto.BotLinkedAccount.encode(message.accounts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.acAuthTokens != null && Object.hasOwnProperty.call(message, "acAuthTokens"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.acAuthTokens);
            if (message.acErrorCode != null && Object.hasOwnProperty.call(message, "acErrorCode"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.acErrorCode);
            return writer;
        };

        /**
         * Encodes the specified BotLinkedAccountsMetadata message, length delimited. Does not implicitly {@link proto.BotLinkedAccountsMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {proto.IBotLinkedAccountsMetadata} message BotLinkedAccountsMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotLinkedAccountsMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotLinkedAccountsMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotLinkedAccountsMetadata} BotLinkedAccountsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotLinkedAccountsMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotLinkedAccountsMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.accounts && message.accounts.length))
                            message.accounts = [];
                        message.accounts.push($root.proto.BotLinkedAccount.decode(reader, reader.uint32()));
                        break;
                    }
                case 2: {
                        message.acAuthTokens = reader.bytes();
                        break;
                    }
                case 3: {
                        message.acErrorCode = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotLinkedAccountsMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotLinkedAccountsMetadata} BotLinkedAccountsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotLinkedAccountsMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotLinkedAccountsMetadata message.
         * @function verify
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotLinkedAccountsMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.accounts != null && message.hasOwnProperty("accounts")) {
                if (!Array.isArray(message.accounts))
                    return "accounts: array expected";
                for (let i = 0; i < message.accounts.length; ++i) {
                    let error = $root.proto.BotLinkedAccount.verify(message.accounts[i]);
                    if (error)
                        return "accounts." + error;
                }
            }
            if (message.acAuthTokens != null && message.hasOwnProperty("acAuthTokens")) {
                properties._acAuthTokens = 1;
                if (!(message.acAuthTokens && typeof message.acAuthTokens.length === "number" || $util.isString(message.acAuthTokens)))
                    return "acAuthTokens: buffer expected";
            }
            if (message.acErrorCode != null && message.hasOwnProperty("acErrorCode")) {
                properties._acErrorCode = 1;
                if (!$util.isInteger(message.acErrorCode))
                    return "acErrorCode: integer expected";
            }
            return null;
        };

        /**
         * Creates a BotLinkedAccountsMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotLinkedAccountsMetadata} BotLinkedAccountsMetadata
         */
        BotLinkedAccountsMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotLinkedAccountsMetadata)
                return object;
            let message = new $root.proto.BotLinkedAccountsMetadata();
            if (object.accounts) {
                if (!Array.isArray(object.accounts))
                    throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: array expected");
                message.accounts = [];
                for (let i = 0; i < object.accounts.length; ++i) {
                    if (typeof object.accounts[i] !== "object")
                        throw TypeError(".proto.BotLinkedAccountsMetadata.accounts: object expected");
                    message.accounts[i] = $root.proto.BotLinkedAccount.fromObject(object.accounts[i]);
                }
            }
            if (object.acAuthTokens != null)
                if (typeof object.acAuthTokens === "string")
                    $util.base64.decode(object.acAuthTokens, message.acAuthTokens = $util.newBuffer($util.base64.length(object.acAuthTokens)), 0);
                else if (object.acAuthTokens.length >= 0)
                    message.acAuthTokens = object.acAuthTokens;
            if (object.acErrorCode != null)
                message.acErrorCode = object.acErrorCode | 0;
            return message;
        };

        /**
         * Creates a plain object from a BotLinkedAccountsMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {proto.BotLinkedAccountsMetadata} message BotLinkedAccountsMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotLinkedAccountsMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.accounts = [];
            if (message.accounts && message.accounts.length) {
                object.accounts = [];
                for (let j = 0; j < message.accounts.length; ++j)
                    object.accounts[j] = $root.proto.BotLinkedAccount.toObject(message.accounts[j], options);
            }
            if (message.acAuthTokens != null && message.hasOwnProperty("acAuthTokens")) {
                object.acAuthTokens = options.bytes === String ? $util.base64.encode(message.acAuthTokens, 0, message.acAuthTokens.length) : options.bytes === Array ? Array.prototype.slice.call(message.acAuthTokens) : message.acAuthTokens;
                if (options.oneofs)
                    object._acAuthTokens = "acAuthTokens";
            }
            if (message.acErrorCode != null && message.hasOwnProperty("acErrorCode")) {
                object.acErrorCode = message.acErrorCode;
                if (options.oneofs)
                    object._acErrorCode = "acErrorCode";
            }
            return object;
        };

        /**
         * Converts this BotLinkedAccountsMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotLinkedAccountsMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotLinkedAccountsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotLinkedAccountsMetadata
         * @function getTypeUrl
         * @memberof proto.BotLinkedAccountsMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotLinkedAccountsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccountsMetadata";
        };

        return BotLinkedAccountsMetadata;
    })();

    proto.BotMediaMetadata = (function() {

        /**
         * Properties of a BotMediaMetadata.
         * @memberof proto
         * @interface IBotMediaMetadata
         * @property {string|null} [fileSha256] BotMediaMetadata fileSha256
         * @property {string|null} [mediaKey] BotMediaMetadata mediaKey
         * @property {string|null} [fileEncSha256] BotMediaMetadata fileEncSha256
         * @property {string|null} [directPath] BotMediaMetadata directPath
         * @property {number|Long|null} [mediaKeyTimestamp] BotMediaMetadata mediaKeyTimestamp
         * @property {string|null} [mimetype] BotMediaMetadata mimetype
         * @property {proto.BotMediaMetadata.OrientationType|null} [orientationType] BotMediaMetadata orientationType
         */

        /**
         * Constructs a new BotMediaMetadata.
         * @memberof proto
         * @classdesc Represents a BotMediaMetadata.
         * @implements IBotMediaMetadata
         * @constructor
         * @param {proto.IBotMediaMetadata=} [properties] Properties to set
         */
        function BotMediaMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMediaMetadata fileSha256.
         * @member {string|null|undefined} fileSha256
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.fileSha256 = null;

        /**
         * BotMediaMetadata mediaKey.
         * @member {string|null|undefined} mediaKey
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.mediaKey = null;

        /**
         * BotMediaMetadata fileEncSha256.
         * @member {string|null|undefined} fileEncSha256
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.fileEncSha256 = null;

        /**
         * BotMediaMetadata directPath.
         * @member {string|null|undefined} directPath
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.directPath = null;

        /**
         * BotMediaMetadata mediaKeyTimestamp.
         * @member {number|Long|null|undefined} mediaKeyTimestamp
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.mediaKeyTimestamp = null;

        /**
         * BotMediaMetadata mimetype.
         * @member {string|null|undefined} mimetype
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.mimetype = null;

        /**
         * BotMediaMetadata orientationType.
         * @member {proto.BotMediaMetadata.OrientationType|null|undefined} orientationType
         * @memberof proto.BotMediaMetadata
         * @instance
         */
        BotMediaMetadata.prototype.orientationType = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKey", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_fileEncSha256", {
            get: $util.oneOfGetter($oneOfFields = ["fileEncSha256"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_directPath", {
            get: $util.oneOfGetter($oneOfFields = ["directPath"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mediaKeyTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["mediaKeyTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_mimetype", {
            get: $util.oneOfGetter($oneOfFields = ["mimetype"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMediaMetadata.prototype, "_orientationType", {
            get: $util.oneOfGetter($oneOfFields = ["orientationType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotMediaMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {proto.IBotMediaMetadata=} [properties] Properties to set
         * @returns {proto.BotMediaMetadata} BotMediaMetadata instance
         */
        BotMediaMetadata.create = function create(properties) {
            return new BotMediaMetadata(properties);
        };

        /**
         * Encodes the specified BotMediaMetadata message. Does not implicitly {@link proto.BotMediaMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {proto.IBotMediaMetadata} message BotMediaMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMediaMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fileSha256);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mediaKey);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 5, wireType 0 =*/40).int64(message.mediaKeyTimestamp);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.mimetype);
            if (message.orientationType != null && Object.hasOwnProperty.call(message, "orientationType"))
                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.orientationType);
            return writer;
        };

        /**
         * Encodes the specified BotMediaMetadata message, length delimited. Does not implicitly {@link proto.BotMediaMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {proto.IBotMediaMetadata} message BotMediaMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMediaMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMediaMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMediaMetadata} BotMediaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMediaMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMediaMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.fileSha256 = reader.string();
                        break;
                    }
                case 2: {
                        message.mediaKey = reader.string();
                        break;
                    }
                case 3: {
                        message.fileEncSha256 = reader.string();
                        break;
                    }
                case 4: {
                        message.directPath = reader.string();
                        break;
                    }
                case 5: {
                        message.mediaKeyTimestamp = reader.int64();
                        break;
                    }
                case 6: {
                        message.mimetype = reader.string();
                        break;
                    }
                case 7: {
                        message.orientationType = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMediaMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMediaMetadata} BotMediaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMediaMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMediaMetadata message.
         * @function verify
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMediaMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256")) {
                properties._fileSha256 = 1;
                if (!$util.isString(message.fileSha256))
                    return "fileSha256: string expected";
            }
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey")) {
                properties._mediaKey = 1;
                if (!$util.isString(message.mediaKey))
                    return "mediaKey: string expected";
            }
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256")) {
                properties._fileEncSha256 = 1;
                if (!$util.isString(message.fileEncSha256))
                    return "fileEncSha256: string expected";
            }
            if (message.directPath != null && message.hasOwnProperty("directPath")) {
                properties._directPath = 1;
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            }
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp")) {
                properties._mediaKeyTimestamp = 1;
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            }
            if (message.mimetype != null && message.hasOwnProperty("mimetype")) {
                properties._mimetype = 1;
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            }
            if (message.orientationType != null && message.hasOwnProperty("orientationType")) {
                properties._orientationType = 1;
                switch (message.orientationType) {
                default:
                    return "orientationType: enum value expected";
                case 1:
                case 2:
                case 3:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotMediaMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMediaMetadata} BotMediaMetadata
         */
        BotMediaMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMediaMetadata)
                return object;
            let message = new $root.proto.BotMediaMetadata();
            if (object.fileSha256 != null)
                message.fileSha256 = String(object.fileSha256);
            if (object.mediaKey != null)
                message.mediaKey = String(object.mediaKey);
            if (object.fileEncSha256 != null)
                message.fileEncSha256 = String(object.fileEncSha256);
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            switch (object.orientationType) {
            default:
                if (typeof object.orientationType === "number") {
                    message.orientationType = object.orientationType;
                    break;
                }
                break;
            case "CENTER":
            case 1:
                message.orientationType = 1;
                break;
            case "LEFT":
            case 2:
                message.orientationType = 2;
                break;
            case "RIGHT":
            case 3:
                message.orientationType = 3;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotMediaMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {proto.BotMediaMetadata} message BotMediaMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMediaMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256")) {
                object.fileSha256 = message.fileSha256;
                if (options.oneofs)
                    object._fileSha256 = "fileSha256";
            }
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey")) {
                object.mediaKey = message.mediaKey;
                if (options.oneofs)
                    object._mediaKey = "mediaKey";
            }
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256")) {
                object.fileEncSha256 = message.fileEncSha256;
                if (options.oneofs)
                    object._fileEncSha256 = "fileEncSha256";
            }
            if (message.directPath != null && message.hasOwnProperty("directPath")) {
                object.directPath = message.directPath;
                if (options.oneofs)
                    object._directPath = "directPath";
            }
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp")) {
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
                if (options.oneofs)
                    object._mediaKeyTimestamp = "mediaKeyTimestamp";
            }
            if (message.mimetype != null && message.hasOwnProperty("mimetype")) {
                object.mimetype = message.mimetype;
                if (options.oneofs)
                    object._mimetype = "mimetype";
            }
            if (message.orientationType != null && message.hasOwnProperty("orientationType")) {
                object.orientationType = options.enums === String ? $root.proto.BotMediaMetadata.OrientationType[message.orientationType] === undefined ? message.orientationType : $root.proto.BotMediaMetadata.OrientationType[message.orientationType] : message.orientationType;
                if (options.oneofs)
                    object._orientationType = "orientationType";
            }
            return object;
        };

        /**
         * Converts this BotMediaMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotMediaMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMediaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMediaMetadata
         * @function getTypeUrl
         * @memberof proto.BotMediaMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMediaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMediaMetadata";
        };

        /**
         * OrientationType enum.
         * @name proto.BotMediaMetadata.OrientationType
         * @enum {number}
         * @property {number} CENTER=1 CENTER value
         * @property {number} LEFT=2 LEFT value
         * @property {number} RIGHT=3 RIGHT value
         */
        BotMediaMetadata.OrientationType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "CENTER"] = 1;
            values[valuesById[2] = "LEFT"] = 2;
            values[valuesById[3] = "RIGHT"] = 3;
            return values;
        })();

        return BotMediaMetadata;
    })();

    proto.BotMemoryFact = (function() {

        /**
         * Properties of a BotMemoryFact.
         * @memberof proto
         * @interface IBotMemoryFact
         * @property {string|null} [fact] BotMemoryFact fact
         * @property {string|null} [factId] BotMemoryFact factId
         */

        /**
         * Constructs a new BotMemoryFact.
         * @memberof proto
         * @classdesc Represents a BotMemoryFact.
         * @implements IBotMemoryFact
         * @constructor
         * @param {proto.IBotMemoryFact=} [properties] Properties to set
         */
        function BotMemoryFact(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMemoryFact fact.
         * @member {string|null|undefined} fact
         * @memberof proto.BotMemoryFact
         * @instance
         */
        BotMemoryFact.prototype.fact = null;

        /**
         * BotMemoryFact factId.
         * @member {string|null|undefined} factId
         * @memberof proto.BotMemoryFact
         * @instance
         */
        BotMemoryFact.prototype.factId = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_fact", {
            get: $util.oneOfGetter($oneOfFields = ["fact"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryFact.prototype, "_factId", {
            get: $util.oneOfGetter($oneOfFields = ["factId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotMemoryFact instance using the specified properties.
         * @function create
         * @memberof proto.BotMemoryFact
         * @static
         * @param {proto.IBotMemoryFact=} [properties] Properties to set
         * @returns {proto.BotMemoryFact} BotMemoryFact instance
         */
        BotMemoryFact.create = function create(properties) {
            return new BotMemoryFact(properties);
        };

        /**
         * Encodes the specified BotMemoryFact message. Does not implicitly {@link proto.BotMemoryFact.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMemoryFact
         * @static
         * @param {proto.IBotMemoryFact} message BotMemoryFact message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemoryFact.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fact != null && Object.hasOwnProperty.call(message, "fact"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fact);
            if (message.factId != null && Object.hasOwnProperty.call(message, "factId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.factId);
            return writer;
        };

        /**
         * Encodes the specified BotMemoryFact message, length delimited. Does not implicitly {@link proto.BotMemoryFact.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMemoryFact
         * @static
         * @param {proto.IBotMemoryFact} message BotMemoryFact message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemoryFact.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMemoryFact message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMemoryFact
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMemoryFact} BotMemoryFact
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemoryFact.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMemoryFact();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.fact = reader.string();
                        break;
                    }
                case 2: {
                        message.factId = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMemoryFact message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMemoryFact
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMemoryFact} BotMemoryFact
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemoryFact.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMemoryFact message.
         * @function verify
         * @memberof proto.BotMemoryFact
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMemoryFact.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.fact != null && message.hasOwnProperty("fact")) {
                properties._fact = 1;
                if (!$util.isString(message.fact))
                    return "fact: string expected";
            }
            if (message.factId != null && message.hasOwnProperty("factId")) {
                properties._factId = 1;
                if (!$util.isString(message.factId))
                    return "factId: string expected";
            }
            return null;
        };

        /**
         * Creates a BotMemoryFact message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMemoryFact
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMemoryFact} BotMemoryFact
         */
        BotMemoryFact.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMemoryFact)
                return object;
            let message = new $root.proto.BotMemoryFact();
            if (object.fact != null)
                message.fact = String(object.fact);
            if (object.factId != null)
                message.factId = String(object.factId);
            return message;
        };

        /**
         * Creates a plain object from a BotMemoryFact message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMemoryFact
         * @static
         * @param {proto.BotMemoryFact} message BotMemoryFact
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMemoryFact.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.fact != null && message.hasOwnProperty("fact")) {
                object.fact = message.fact;
                if (options.oneofs)
                    object._fact = "fact";
            }
            if (message.factId != null && message.hasOwnProperty("factId")) {
                object.factId = message.factId;
                if (options.oneofs)
                    object._factId = "factId";
            }
            return object;
        };

        /**
         * Converts this BotMemoryFact to JSON.
         * @function toJSON
         * @memberof proto.BotMemoryFact
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMemoryFact.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMemoryFact
         * @function getTypeUrl
         * @memberof proto.BotMemoryFact
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMemoryFact.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryFact";
        };

        return BotMemoryFact;
    })();

    proto.BotMemoryMetadata = (function() {

        /**
         * Properties of a BotMemoryMetadata.
         * @memberof proto
         * @interface IBotMemoryMetadata
         * @property {Array.<proto.IBotMemoryFact>|null} [addedFacts] BotMemoryMetadata addedFacts
         * @property {Array.<proto.IBotMemoryFact>|null} [removedFacts] BotMemoryMetadata removedFacts
         * @property {string|null} [disclaimer] BotMemoryMetadata disclaimer
         */

        /**
         * Constructs a new BotMemoryMetadata.
         * @memberof proto
         * @classdesc Represents a BotMemoryMetadata.
         * @implements IBotMemoryMetadata
         * @constructor
         * @param {proto.IBotMemoryMetadata=} [properties] Properties to set
         */
        function BotMemoryMetadata(properties) {
            this.addedFacts = [];
            this.removedFacts = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMemoryMetadata addedFacts.
         * @member {Array.<proto.IBotMemoryFact>} addedFacts
         * @memberof proto.BotMemoryMetadata
         * @instance
         */
        BotMemoryMetadata.prototype.addedFacts = $util.emptyArray;

        /**
         * BotMemoryMetadata removedFacts.
         * @member {Array.<proto.IBotMemoryFact>} removedFacts
         * @memberof proto.BotMemoryMetadata
         * @instance
         */
        BotMemoryMetadata.prototype.removedFacts = $util.emptyArray;

        /**
         * BotMemoryMetadata disclaimer.
         * @member {string|null|undefined} disclaimer
         * @memberof proto.BotMemoryMetadata
         * @instance
         */
        BotMemoryMetadata.prototype.disclaimer = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMemoryMetadata.prototype, "_disclaimer", {
            get: $util.oneOfGetter($oneOfFields = ["disclaimer"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotMemoryMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {proto.IBotMemoryMetadata=} [properties] Properties to set
         * @returns {proto.BotMemoryMetadata} BotMemoryMetadata instance
         */
        BotMemoryMetadata.create = function create(properties) {
            return new BotMemoryMetadata(properties);
        };

        /**
         * Encodes the specified BotMemoryMetadata message. Does not implicitly {@link proto.BotMemoryMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {proto.IBotMemoryMetadata} message BotMemoryMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemoryMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.addedFacts != null && message.addedFacts.length)
                for (let i = 0; i < message.addedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(message.addedFacts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.removedFacts != null && message.removedFacts.length)
                for (let i = 0; i < message.removedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(message.removedFacts[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.disclaimer != null && Object.hasOwnProperty.call(message, "disclaimer"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.disclaimer);
            return writer;
        };

        /**
         * Encodes the specified BotMemoryMetadata message, length delimited. Does not implicitly {@link proto.BotMemoryMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {proto.IBotMemoryMetadata} message BotMemoryMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemoryMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMemoryMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMemoryMetadata} BotMemoryMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemoryMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMemoryMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.addedFacts && message.addedFacts.length))
                            message.addedFacts = [];
                        message.addedFacts.push($root.proto.BotMemoryFact.decode(reader, reader.uint32()));
                        break;
                    }
                case 2: {
                        if (!(message.removedFacts && message.removedFacts.length))
                            message.removedFacts = [];
                        message.removedFacts.push($root.proto.BotMemoryFact.decode(reader, reader.uint32()));
                        break;
                    }
                case 3: {
                        message.disclaimer = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMemoryMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMemoryMetadata} BotMemoryMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemoryMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMemoryMetadata message.
         * @function verify
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMemoryMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.addedFacts != null && message.hasOwnProperty("addedFacts")) {
                if (!Array.isArray(message.addedFacts))
                    return "addedFacts: array expected";
                for (let i = 0; i < message.addedFacts.length; ++i) {
                    let error = $root.proto.BotMemoryFact.verify(message.addedFacts[i]);
                    if (error)
                        return "addedFacts." + error;
                }
            }
            if (message.removedFacts != null && message.hasOwnProperty("removedFacts")) {
                if (!Array.isArray(message.removedFacts))
                    return "removedFacts: array expected";
                for (let i = 0; i < message.removedFacts.length; ++i) {
                    let error = $root.proto.BotMemoryFact.verify(message.removedFacts[i]);
                    if (error)
                        return "removedFacts." + error;
                }
            }
            if (message.disclaimer != null && message.hasOwnProperty("disclaimer")) {
                properties._disclaimer = 1;
                if (!$util.isString(message.disclaimer))
                    return "disclaimer: string expected";
            }
            return null;
        };

        /**
         * Creates a BotMemoryMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMemoryMetadata} BotMemoryMetadata
         */
        BotMemoryMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMemoryMetadata)
                return object;
            let message = new $root.proto.BotMemoryMetadata();
            if (object.addedFacts) {
                if (!Array.isArray(object.addedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.addedFacts: array expected");
                message.addedFacts = [];
                for (let i = 0; i < object.addedFacts.length; ++i) {
                    if (typeof object.addedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.addedFacts: object expected");
                    message.addedFacts[i] = $root.proto.BotMemoryFact.fromObject(object.addedFacts[i]);
                }
            }
            if (object.removedFacts) {
                if (!Array.isArray(object.removedFacts))
                    throw TypeError(".proto.BotMemoryMetadata.removedFacts: array expected");
                message.removedFacts = [];
                for (let i = 0; i < object.removedFacts.length; ++i) {
                    if (typeof object.removedFacts[i] !== "object")
                        throw TypeError(".proto.BotMemoryMetadata.removedFacts: object expected");
                    message.removedFacts[i] = $root.proto.BotMemoryFact.fromObject(object.removedFacts[i]);
                }
            }
            if (object.disclaimer != null)
                message.disclaimer = String(object.disclaimer);
            return message;
        };

        /**
         * Creates a plain object from a BotMemoryMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {proto.BotMemoryMetadata} message BotMemoryMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMemoryMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults) {
                object.addedFacts = [];
                object.removedFacts = [];
            }
            if (message.addedFacts && message.addedFacts.length) {
                object.addedFacts = [];
                for (let j = 0; j < message.addedFacts.length; ++j)
                    object.addedFacts[j] = $root.proto.BotMemoryFact.toObject(message.addedFacts[j], options);
            }
            if (message.removedFacts && message.removedFacts.length) {
                object.removedFacts = [];
                for (let j = 0; j < message.removedFacts.length; ++j)
                    object.removedFacts[j] = $root.proto.BotMemoryFact.toObject(message.removedFacts[j], options);
            }
            if (message.disclaimer != null && message.hasOwnProperty("disclaimer")) {
                object.disclaimer = message.disclaimer;
                if (options.oneofs)
                    object._disclaimer = "disclaimer";
            }
            return object;
        };

        /**
         * Converts this BotMemoryMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotMemoryMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMemoryMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMemoryMetadata
         * @function getTypeUrl
         * @memberof proto.BotMemoryMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMemoryMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryMetadata";
        };

        return BotMemoryMetadata;
    })();

    proto.BotMemuMetadata = (function() {

        /**
         * Properties of a BotMemuMetadata.
         * @memberof proto
         * @interface IBotMemuMetadata
         * @property {Array.<proto.IBotMediaMetadata>|null} [faceImages] BotMemuMetadata faceImages
         */

        /**
         * Constructs a new BotMemuMetadata.
         * @memberof proto
         * @classdesc Represents a BotMemuMetadata.
         * @implements IBotMemuMetadata
         * @constructor
         * @param {proto.IBotMemuMetadata=} [properties] Properties to set
         */
        function BotMemuMetadata(properties) {
            this.faceImages = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMemuMetadata faceImages.
         * @member {Array.<proto.IBotMediaMetadata>} faceImages
         * @memberof proto.BotMemuMetadata
         * @instance
         */
        BotMemuMetadata.prototype.faceImages = $util.emptyArray;

        /**
         * Creates a new BotMemuMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {proto.IBotMemuMetadata=} [properties] Properties to set
         * @returns {proto.BotMemuMetadata} BotMemuMetadata instance
         */
        BotMemuMetadata.create = function create(properties) {
            return new BotMemuMetadata(properties);
        };

        /**
         * Encodes the specified BotMemuMetadata message. Does not implicitly {@link proto.BotMemuMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {proto.IBotMemuMetadata} message BotMemuMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemuMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.faceImages != null && message.faceImages.length)
                for (let i = 0; i < message.faceImages.length; ++i)
                    $root.proto.BotMediaMetadata.encode(message.faceImages[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotMemuMetadata message, length delimited. Does not implicitly {@link proto.BotMemuMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {proto.IBotMemuMetadata} message BotMemuMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMemuMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMemuMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMemuMetadata} BotMemuMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemuMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMemuMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.faceImages && message.faceImages.length))
                            message.faceImages = [];
                        message.faceImages.push($root.proto.BotMediaMetadata.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMemuMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMemuMetadata} BotMemuMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMemuMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMemuMetadata message.
         * @function verify
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMemuMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.faceImages != null && message.hasOwnProperty("faceImages")) {
                if (!Array.isArray(message.faceImages))
                    return "faceImages: array expected";
                for (let i = 0; i < message.faceImages.length; ++i) {
                    let error = $root.proto.BotMediaMetadata.verify(message.faceImages[i]);
                    if (error)
                        return "faceImages." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotMemuMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMemuMetadata} BotMemuMetadata
         */
        BotMemuMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMemuMetadata)
                return object;
            let message = new $root.proto.BotMemuMetadata();
            if (object.faceImages) {
                if (!Array.isArray(object.faceImages))
                    throw TypeError(".proto.BotMemuMetadata.faceImages: array expected");
                message.faceImages = [];
                for (let i = 0; i < object.faceImages.length; ++i) {
                    if (typeof object.faceImages[i] !== "object")
                        throw TypeError(".proto.BotMemuMetadata.faceImages: object expected");
                    message.faceImages[i] = $root.proto.BotMediaMetadata.fromObject(object.faceImages[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotMemuMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {proto.BotMemuMetadata} message BotMemuMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMemuMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.faceImages = [];
            if (message.faceImages && message.faceImages.length) {
                object.faceImages = [];
                for (let j = 0; j < message.faceImages.length; ++j)
                    object.faceImages[j] = $root.proto.BotMediaMetadata.toObject(message.faceImages[j], options);
            }
            return object;
        };

        /**
         * Converts this BotMemuMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotMemuMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMemuMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMemuMetadata
         * @function getTypeUrl
         * @memberof proto.BotMemuMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMemuMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemuMetadata";
        };

        return BotMemuMetadata;
    })();

    proto.BotMetadata = (function() {

        /**
         * Properties of a BotMetadata.
         * @memberof proto
         * @interface IBotMetadata
         * @property {proto.IBotAvatarMetadata|null} [avatarMetadata] BotMetadata avatarMetadata
         * @property {string|null} [personaId] BotMetadata personaId
         * @property {proto.IBotPluginMetadata|null} [pluginMetadata] BotMetadata pluginMetadata
         * @property {proto.IBotSuggestedPromptMetadata|null} [suggestedPromptMetadata] BotMetadata suggestedPromptMetadata
         * @property {string|null} [invokerJid] BotMetadata invokerJid
         * @property {proto.IBotSessionMetadata|null} [sessionMetadata] BotMetadata sessionMetadata
         * @property {proto.IBotMemuMetadata|null} [memuMetadata] BotMetadata memuMetadata
         * @property {string|null} [timezone] BotMetadata timezone
         * @property {proto.IBotReminderMetadata|null} [reminderMetadata] BotMetadata reminderMetadata
         * @property {proto.IBotModelMetadata|null} [modelMetadata] BotMetadata modelMetadata
         * @property {string|null} [messageDisclaimerText] BotMetadata messageDisclaimerText
         * @property {proto.IBotProgressIndicatorMetadata|null} [progressIndicatorMetadata] BotMetadata progressIndicatorMetadata
         * @property {proto.IBotCapabilityMetadata|null} [capabilityMetadata] BotMetadata capabilityMetadata
         * @property {proto.IBotImagineMetadata|null} [imagineMetadata] BotMetadata imagineMetadata
         * @property {proto.IBotMemoryMetadata|null} [memoryMetadata] BotMetadata memoryMetadata
         * @property {proto.IBotRenderingMetadata|null} [renderingMetadata] BotMetadata renderingMetadata
         * @property {proto.IBotMetricsMetadata|null} [botMetricsMetadata] BotMetadata botMetricsMetadata
         * @property {proto.IBotLinkedAccountsMetadata|null} [botLinkedAccountsMetadata] BotMetadata botLinkedAccountsMetadata
         * @property {proto.IBotSourcesMetadata|null} [richResponseSourcesMetadata] BotMetadata richResponseSourcesMetadata
         * @property {Uint8Array|null} [aiConversationContext] BotMetadata aiConversationContext
         * @property {proto.IBotPromotionMessageMetadata|null} [botPromotionMessageMetadata] BotMetadata botPromotionMessageMetadata
         * @property {proto.IBotModeSelectionMetadata|null} [botModeSelectionMetadata] BotMetadata botModeSelectionMetadata
         * @property {proto.IBotQuotaMetadata|null} [botQuotaMetadata] BotMetadata botQuotaMetadata
         * @property {proto.IBotAgeCollectionMetadata|null} [botAgeCollectionMetadata] BotMetadata botAgeCollectionMetadata
         */

        /**
         * Constructs a new BotMetadata.
         * @memberof proto
         * @classdesc Represents a BotMetadata.
         * @implements IBotMetadata
         * @constructor
         * @param {proto.IBotMetadata=} [properties] Properties to set
         */
        function BotMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMetadata avatarMetadata.
         * @member {proto.IBotAvatarMetadata|null|undefined} avatarMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.avatarMetadata = null;

        /**
         * BotMetadata personaId.
         * @member {string|null|undefined} personaId
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.personaId = null;

        /**
         * BotMetadata pluginMetadata.
         * @member {proto.IBotPluginMetadata|null|undefined} pluginMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.pluginMetadata = null;

        /**
         * BotMetadata suggestedPromptMetadata.
         * @member {proto.IBotSuggestedPromptMetadata|null|undefined} suggestedPromptMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.suggestedPromptMetadata = null;

        /**
         * BotMetadata invokerJid.
         * @member {string|null|undefined} invokerJid
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.invokerJid = null;

        /**
         * BotMetadata sessionMetadata.
         * @member {proto.IBotSessionMetadata|null|undefined} sessionMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.sessionMetadata = null;

        /**
         * BotMetadata memuMetadata.
         * @member {proto.IBotMemuMetadata|null|undefined} memuMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.memuMetadata = null;

        /**
         * BotMetadata timezone.
         * @member {string|null|undefined} timezone
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.timezone = null;

        /**
         * BotMetadata reminderMetadata.
         * @member {proto.IBotReminderMetadata|null|undefined} reminderMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.reminderMetadata = null;

        /**
         * BotMetadata modelMetadata.
         * @member {proto.IBotModelMetadata|null|undefined} modelMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.modelMetadata = null;

        /**
         * BotMetadata messageDisclaimerText.
         * @member {string|null|undefined} messageDisclaimerText
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.messageDisclaimerText = null;

        /**
         * BotMetadata progressIndicatorMetadata.
         * @member {proto.IBotProgressIndicatorMetadata|null|undefined} progressIndicatorMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.progressIndicatorMetadata = null;

        /**
         * BotMetadata capabilityMetadata.
         * @member {proto.IBotCapabilityMetadata|null|undefined} capabilityMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.capabilityMetadata = null;

        /**
         * BotMetadata imagineMetadata.
         * @member {proto.IBotImagineMetadata|null|undefined} imagineMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.imagineMetadata = null;

        /**
         * BotMetadata memoryMetadata.
         * @member {proto.IBotMemoryMetadata|null|undefined} memoryMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.memoryMetadata = null;

        /**
         * BotMetadata renderingMetadata.
         * @member {proto.IBotRenderingMetadata|null|undefined} renderingMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.renderingMetadata = null;

        /**
         * BotMetadata botMetricsMetadata.
         * @member {proto.IBotMetricsMetadata|null|undefined} botMetricsMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botMetricsMetadata = null;

        /**
         * BotMetadata botLinkedAccountsMetadata.
         * @member {proto.IBotLinkedAccountsMetadata|null|undefined} botLinkedAccountsMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botLinkedAccountsMetadata = null;

        /**
         * BotMetadata richResponseSourcesMetadata.
         * @member {proto.IBotSourcesMetadata|null|undefined} richResponseSourcesMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.richResponseSourcesMetadata = null;

        /**
         * BotMetadata aiConversationContext.
         * @member {Uint8Array|null|undefined} aiConversationContext
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.aiConversationContext = null;

        /**
         * BotMetadata botPromotionMessageMetadata.
         * @member {proto.IBotPromotionMessageMetadata|null|undefined} botPromotionMessageMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botPromotionMessageMetadata = null;

        /**
         * BotMetadata botModeSelectionMetadata.
         * @member {proto.IBotModeSelectionMetadata|null|undefined} botModeSelectionMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botModeSelectionMetadata = null;

        /**
         * BotMetadata botQuotaMetadata.
         * @member {proto.IBotQuotaMetadata|null|undefined} botQuotaMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botQuotaMetadata = null;

        /**
         * BotMetadata botAgeCollectionMetadata.
         * @member {proto.IBotAgeCollectionMetadata|null|undefined} botAgeCollectionMetadata
         * @memberof proto.BotMetadata
         * @instance
         */
        BotMetadata.prototype.botAgeCollectionMetadata = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_avatarMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["avatarMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_personaId", {
            get: $util.oneOfGetter($oneOfFields = ["personaId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_pluginMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["pluginMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_suggestedPromptMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["suggestedPromptMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_invokerJid", {
            get: $util.oneOfGetter($oneOfFields = ["invokerJid"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_sessionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["sessionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memuMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memuMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_timezone", {
            get: $util.oneOfGetter($oneOfFields = ["timezone"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_reminderMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["reminderMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_modelMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["modelMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_messageDisclaimerText", {
            get: $util.oneOfGetter($oneOfFields = ["messageDisclaimerText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_progressIndicatorMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["progressIndicatorMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_capabilityMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["capabilityMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_imagineMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["imagineMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_memoryMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["memoryMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_renderingMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["renderingMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botMetricsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botMetricsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botLinkedAccountsMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botLinkedAccountsMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_richResponseSourcesMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["richResponseSourcesMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_aiConversationContext", {
            get: $util.oneOfGetter($oneOfFields = ["aiConversationContext"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botPromotionMessageMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botPromotionMessageMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botModeSelectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botModeSelectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botQuotaMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botQuotaMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetadata.prototype, "_botAgeCollectionMetadata", {
            get: $util.oneOfGetter($oneOfFields = ["botAgeCollectionMetadata"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotMetadata
         * @static
         * @param {proto.IBotMetadata=} [properties] Properties to set
         * @returns {proto.BotMetadata} BotMetadata instance
         */
        BotMetadata.create = function create(properties) {
            return new BotMetadata(properties);
        };

        /**
         * Encodes the specified BotMetadata message. Does not implicitly {@link proto.BotMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMetadata
         * @static
         * @param {proto.IBotMetadata} message BotMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.avatarMetadata != null && Object.hasOwnProperty.call(message, "avatarMetadata"))
                $root.proto.BotAvatarMetadata.encode(message.avatarMetadata, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.personaId != null && Object.hasOwnProperty.call(message, "personaId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.personaId);
            if (message.pluginMetadata != null && Object.hasOwnProperty.call(message, "pluginMetadata"))
                $root.proto.BotPluginMetadata.encode(message.pluginMetadata, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.suggestedPromptMetadata != null && Object.hasOwnProperty.call(message, "suggestedPromptMetadata"))
                $root.proto.BotSuggestedPromptMetadata.encode(message.suggestedPromptMetadata, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.invokerJid != null && Object.hasOwnProperty.call(message, "invokerJid"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.invokerJid);
            if (message.sessionMetadata != null && Object.hasOwnProperty.call(message, "sessionMetadata"))
                $root.proto.BotSessionMetadata.encode(message.sessionMetadata, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.memuMetadata != null && Object.hasOwnProperty.call(message, "memuMetadata"))
                $root.proto.BotMemuMetadata.encode(message.memuMetadata, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.timezone != null && Object.hasOwnProperty.call(message, "timezone"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.timezone);
            if (message.reminderMetadata != null && Object.hasOwnProperty.call(message, "reminderMetadata"))
                $root.proto.BotReminderMetadata.encode(message.reminderMetadata, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.modelMetadata != null && Object.hasOwnProperty.call(message, "modelMetadata"))
                $root.proto.BotModelMetadata.encode(message.modelMetadata, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            if (message.messageDisclaimerText != null && Object.hasOwnProperty.call(message, "messageDisclaimerText"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.messageDisclaimerText);
            if (message.progressIndicatorMetadata != null && Object.hasOwnProperty.call(message, "progressIndicatorMetadata"))
                $root.proto.BotProgressIndicatorMetadata.encode(message.progressIndicatorMetadata, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
            if (message.capabilityMetadata != null && Object.hasOwnProperty.call(message, "capabilityMetadata"))
                $root.proto.BotCapabilityMetadata.encode(message.capabilityMetadata, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
            if (message.imagineMetadata != null && Object.hasOwnProperty.call(message, "imagineMetadata"))
                $root.proto.BotImagineMetadata.encode(message.imagineMetadata, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
            if (message.memoryMetadata != null && Object.hasOwnProperty.call(message, "memoryMetadata"))
                $root.proto.BotMemoryMetadata.encode(message.memoryMetadata, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.renderingMetadata != null && Object.hasOwnProperty.call(message, "renderingMetadata"))
                $root.proto.BotRenderingMetadata.encode(message.renderingMetadata, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
            if (message.botMetricsMetadata != null && Object.hasOwnProperty.call(message, "botMetricsMetadata"))
                $root.proto.BotMetricsMetadata.encode(message.botMetricsMetadata, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.botLinkedAccountsMetadata != null && Object.hasOwnProperty.call(message, "botLinkedAccountsMetadata"))
                $root.proto.BotLinkedAccountsMetadata.encode(message.botLinkedAccountsMetadata, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
            if (message.richResponseSourcesMetadata != null && Object.hasOwnProperty.call(message, "richResponseSourcesMetadata"))
                $root.proto.BotSourcesMetadata.encode(message.richResponseSourcesMetadata, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
            if (message.aiConversationContext != null && Object.hasOwnProperty.call(message, "aiConversationContext"))
                writer.uint32(/* id 20, wireType 2 =*/162).bytes(message.aiConversationContext);
            if (message.botPromotionMessageMetadata != null && Object.hasOwnProperty.call(message, "botPromotionMessageMetadata"))
                $root.proto.BotPromotionMessageMetadata.encode(message.botPromotionMessageMetadata, writer.uint32(/* id 21, wireType 2 =*/170).fork()).ldelim();
            if (message.botModeSelectionMetadata != null && Object.hasOwnProperty.call(message, "botModeSelectionMetadata"))
                $root.proto.BotModeSelectionMetadata.encode(message.botModeSelectionMetadata, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
            if (message.botQuotaMetadata != null && Object.hasOwnProperty.call(message, "botQuotaMetadata"))
                $root.proto.BotQuotaMetadata.encode(message.botQuotaMetadata, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.botAgeCollectionMetadata != null && Object.hasOwnProperty.call(message, "botAgeCollectionMetadata"))
                $root.proto.BotAgeCollectionMetadata.encode(message.botAgeCollectionMetadata, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotMetadata message, length delimited. Does not implicitly {@link proto.BotMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMetadata
         * @static
         * @param {proto.IBotMetadata} message BotMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMetadata} BotMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.avatarMetadata = $root.proto.BotAvatarMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        message.personaId = reader.string();
                        break;
                    }
                case 3: {
                        message.pluginMetadata = $root.proto.BotPluginMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 4: {
                        message.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 5: {
                        message.invokerJid = reader.string();
                        break;
                    }
                case 6: {
                        message.sessionMetadata = $root.proto.BotSessionMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 7: {
                        message.memuMetadata = $root.proto.BotMemuMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 8: {
                        message.timezone = reader.string();
                        break;
                    }
                case 9: {
                        message.reminderMetadata = $root.proto.BotReminderMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 10: {
                        message.modelMetadata = $root.proto.BotModelMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 11: {
                        message.messageDisclaimerText = reader.string();
                        break;
                    }
                case 12: {
                        message.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 13: {
                        message.capabilityMetadata = $root.proto.BotCapabilityMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 14: {
                        message.imagineMetadata = $root.proto.BotImagineMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 15: {
                        message.memoryMetadata = $root.proto.BotMemoryMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 16: {
                        message.renderingMetadata = $root.proto.BotRenderingMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 17: {
                        message.botMetricsMetadata = $root.proto.BotMetricsMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 18: {
                        message.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 19: {
                        message.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 20: {
                        message.aiConversationContext = reader.bytes();
                        break;
                    }
                case 21: {
                        message.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 22: {
                        message.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 23: {
                        message.botQuotaMetadata = $root.proto.BotQuotaMetadata.decode(reader, reader.uint32());
                        break;
                    }
                case 24: {
                        message.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.decode(reader, reader.uint32());
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMetadata} BotMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMetadata message.
         * @function verify
         * @memberof proto.BotMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.avatarMetadata != null && message.hasOwnProperty("avatarMetadata")) {
                properties._avatarMetadata = 1;
                {
                    let error = $root.proto.BotAvatarMetadata.verify(message.avatarMetadata);
                    if (error)
                        return "avatarMetadata." + error;
                }
            }
            if (message.personaId != null && message.hasOwnProperty("personaId")) {
                properties._personaId = 1;
                if (!$util.isString(message.personaId))
                    return "personaId: string expected";
            }
            if (message.pluginMetadata != null && message.hasOwnProperty("pluginMetadata")) {
                properties._pluginMetadata = 1;
                {
                    let error = $root.proto.BotPluginMetadata.verify(message.pluginMetadata);
                    if (error)
                        return "pluginMetadata." + error;
                }
            }
            if (message.suggestedPromptMetadata != null && message.hasOwnProperty("suggestedPromptMetadata")) {
                properties._suggestedPromptMetadata = 1;
                {
                    let error = $root.proto.BotSuggestedPromptMetadata.verify(message.suggestedPromptMetadata);
                    if (error)
                        return "suggestedPromptMetadata." + error;
                }
            }
            if (message.invokerJid != null && message.hasOwnProperty("invokerJid")) {
                properties._invokerJid = 1;
                if (!$util.isString(message.invokerJid))
                    return "invokerJid: string expected";
            }
            if (message.sessionMetadata != null && message.hasOwnProperty("sessionMetadata")) {
                properties._sessionMetadata = 1;
                {
                    let error = $root.proto.BotSessionMetadata.verify(message.sessionMetadata);
                    if (error)
                        return "sessionMetadata." + error;
                }
            }
            if (message.memuMetadata != null && message.hasOwnProperty("memuMetadata")) {
                properties._memuMetadata = 1;
                {
                    let error = $root.proto.BotMemuMetadata.verify(message.memuMetadata);
                    if (error)
                        return "memuMetadata." + error;
                }
            }
            if (message.timezone != null && message.hasOwnProperty("timezone")) {
                properties._timezone = 1;
                if (!$util.isString(message.timezone))
                    return "timezone: string expected";
            }
            if (message.reminderMetadata != null && message.hasOwnProperty("reminderMetadata")) {
                properties._reminderMetadata = 1;
                {
                    let error = $root.proto.BotReminderMetadata.verify(message.reminderMetadata);
                    if (error)
                        return "reminderMetadata." + error;
                }
            }
            if (message.modelMetadata != null && message.hasOwnProperty("modelMetadata")) {
                properties._modelMetadata = 1;
                {
                    let error = $root.proto.BotModelMetadata.verify(message.modelMetadata);
                    if (error)
                        return "modelMetadata." + error;
                }
            }
            if (message.messageDisclaimerText != null && message.hasOwnProperty("messageDisclaimerText")) {
                properties._messageDisclaimerText = 1;
                if (!$util.isString(message.messageDisclaimerText))
                    return "messageDisclaimerText: string expected";
            }
            if (message.progressIndicatorMetadata != null && message.hasOwnProperty("progressIndicatorMetadata")) {
                properties._progressIndicatorMetadata = 1;
                {
                    let error = $root.proto.BotProgressIndicatorMetadata.verify(message.progressIndicatorMetadata);
                    if (error)
                        return "progressIndicatorMetadata." + error;
                }
            }
            if (message.capabilityMetadata != null && message.hasOwnProperty("capabilityMetadata")) {
                properties._capabilityMetadata = 1;
                {
                    let error = $root.proto.BotCapabilityMetadata.verify(message.capabilityMetadata);
                    if (error)
                        return "capabilityMetadata." + error;
                }
            }
            if (message.imagineMetadata != null && message.hasOwnProperty("imagineMetadata")) {
                properties._imagineMetadata = 1;
                {
                    let error = $root.proto.BotImagineMetadata.verify(message.imagineMetadata);
                    if (error)
                        return "imagineMetadata." + error;
                }
            }
            if (message.memoryMetadata != null && message.hasOwnProperty("memoryMetadata")) {
                properties._memoryMetadata = 1;
                {
                    let error = $root.proto.BotMemoryMetadata.verify(message.memoryMetadata);
                    if (error)
                        return "memoryMetadata." + error;
                }
            }
            if (message.renderingMetadata != null && message.hasOwnProperty("renderingMetadata")) {
                properties._renderingMetadata = 1;
                {
                    let error = $root.proto.BotRenderingMetadata.verify(message.renderingMetadata);
                    if (error)
                        return "renderingMetadata." + error;
                }
            }
            if (message.botMetricsMetadata != null && message.hasOwnProperty("botMetricsMetadata")) {
                properties._botMetricsMetadata = 1;
                {
                    let error = $root.proto.BotMetricsMetadata.verify(message.botMetricsMetadata);
                    if (error)
                        return "botMetricsMetadata." + error;
                }
            }
            if (message.botLinkedAccountsMetadata != null && message.hasOwnProperty("botLinkedAccountsMetadata")) {
                properties._botLinkedAccountsMetadata = 1;
                {
                    let error = $root.proto.BotLinkedAccountsMetadata.verify(message.botLinkedAccountsMetadata);
                    if (error)
                        return "botLinkedAccountsMetadata." + error;
                }
            }
            if (message.richResponseSourcesMetadata != null && message.hasOwnProperty("richResponseSourcesMetadata")) {
                properties._richResponseSourcesMetadata = 1;
                {
                    let error = $root.proto.BotSourcesMetadata.verify(message.richResponseSourcesMetadata);
                    if (error)
                        return "richResponseSourcesMetadata." + error;
                }
            }
            if (message.aiConversationContext != null && message.hasOwnProperty("aiConversationContext")) {
                properties._aiConversationContext = 1;
                if (!(message.aiConversationContext && typeof message.aiConversationContext.length === "number" || $util.isString(message.aiConversationContext)))
                    return "aiConversationContext: buffer expected";
            }
            if (message.botPromotionMessageMetadata != null && message.hasOwnProperty("botPromotionMessageMetadata")) {
                properties._botPromotionMessageMetadata = 1;
                {
                    let error = $root.proto.BotPromotionMessageMetadata.verify(message.botPromotionMessageMetadata);
                    if (error)
                        return "botPromotionMessageMetadata." + error;
                }
            }
            if (message.botModeSelectionMetadata != null && message.hasOwnProperty("botModeSelectionMetadata")) {
                properties._botModeSelectionMetadata = 1;
                {
                    let error = $root.proto.BotModeSelectionMetadata.verify(message.botModeSelectionMetadata);
                    if (error)
                        return "botModeSelectionMetadata." + error;
                }
            }
            if (message.botQuotaMetadata != null && message.hasOwnProperty("botQuotaMetadata")) {
                properties._botQuotaMetadata = 1;
                {
                    let error = $root.proto.BotQuotaMetadata.verify(message.botQuotaMetadata);
                    if (error)
                        return "botQuotaMetadata." + error;
                }
            }
            if (message.botAgeCollectionMetadata != null && message.hasOwnProperty("botAgeCollectionMetadata")) {
                properties._botAgeCollectionMetadata = 1;
                {
                    let error = $root.proto.BotAgeCollectionMetadata.verify(message.botAgeCollectionMetadata);
                    if (error)
                        return "botAgeCollectionMetadata." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMetadata} BotMetadata
         */
        BotMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMetadata)
                return object;
            let message = new $root.proto.BotMetadata();
            if (object.avatarMetadata != null) {
                if (typeof object.avatarMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.avatarMetadata: object expected");
                message.avatarMetadata = $root.proto.BotAvatarMetadata.fromObject(object.avatarMetadata);
            }
            if (object.personaId != null)
                message.personaId = String(object.personaId);
            if (object.pluginMetadata != null) {
                if (typeof object.pluginMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.pluginMetadata: object expected");
                message.pluginMetadata = $root.proto.BotPluginMetadata.fromObject(object.pluginMetadata);
            }
            if (object.suggestedPromptMetadata != null) {
                if (typeof object.suggestedPromptMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.suggestedPromptMetadata: object expected");
                message.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.fromObject(object.suggestedPromptMetadata);
            }
            if (object.invokerJid != null)
                message.invokerJid = String(object.invokerJid);
            if (object.sessionMetadata != null) {
                if (typeof object.sessionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.sessionMetadata: object expected");
                message.sessionMetadata = $root.proto.BotSessionMetadata.fromObject(object.sessionMetadata);
            }
            if (object.memuMetadata != null) {
                if (typeof object.memuMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memuMetadata: object expected");
                message.memuMetadata = $root.proto.BotMemuMetadata.fromObject(object.memuMetadata);
            }
            if (object.timezone != null)
                message.timezone = String(object.timezone);
            if (object.reminderMetadata != null) {
                if (typeof object.reminderMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.reminderMetadata: object expected");
                message.reminderMetadata = $root.proto.BotReminderMetadata.fromObject(object.reminderMetadata);
            }
            if (object.modelMetadata != null) {
                if (typeof object.modelMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.modelMetadata: object expected");
                message.modelMetadata = $root.proto.BotModelMetadata.fromObject(object.modelMetadata);
            }
            if (object.messageDisclaimerText != null)
                message.messageDisclaimerText = String(object.messageDisclaimerText);
            if (object.progressIndicatorMetadata != null) {
                if (typeof object.progressIndicatorMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.progressIndicatorMetadata: object expected");
                message.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.fromObject(object.progressIndicatorMetadata);
            }
            if (object.capabilityMetadata != null) {
                if (typeof object.capabilityMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.capabilityMetadata: object expected");
                message.capabilityMetadata = $root.proto.BotCapabilityMetadata.fromObject(object.capabilityMetadata);
            }
            if (object.imagineMetadata != null) {
                if (typeof object.imagineMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.imagineMetadata: object expected");
                message.imagineMetadata = $root.proto.BotImagineMetadata.fromObject(object.imagineMetadata);
            }
            if (object.memoryMetadata != null) {
                if (typeof object.memoryMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.memoryMetadata: object expected");
                message.memoryMetadata = $root.proto.BotMemoryMetadata.fromObject(object.memoryMetadata);
            }
            if (object.renderingMetadata != null) {
                if (typeof object.renderingMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.renderingMetadata: object expected");
                message.renderingMetadata = $root.proto.BotRenderingMetadata.fromObject(object.renderingMetadata);
            }
            if (object.botMetricsMetadata != null) {
                if (typeof object.botMetricsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botMetricsMetadata: object expected");
                message.botMetricsMetadata = $root.proto.BotMetricsMetadata.fromObject(object.botMetricsMetadata);
            }
            if (object.botLinkedAccountsMetadata != null) {
                if (typeof object.botLinkedAccountsMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botLinkedAccountsMetadata: object expected");
                message.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.fromObject(object.botLinkedAccountsMetadata);
            }
            if (object.richResponseSourcesMetadata != null) {
                if (typeof object.richResponseSourcesMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.richResponseSourcesMetadata: object expected");
                message.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.fromObject(object.richResponseSourcesMetadata);
            }
            if (object.aiConversationContext != null)
                if (typeof object.aiConversationContext === "string")
                    $util.base64.decode(object.aiConversationContext, message.aiConversationContext = $util.newBuffer($util.base64.length(object.aiConversationContext)), 0);
                else if (object.aiConversationContext.length >= 0)
                    message.aiConversationContext = object.aiConversationContext;
            if (object.botPromotionMessageMetadata != null) {
                if (typeof object.botPromotionMessageMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botPromotionMessageMetadata: object expected");
                message.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.fromObject(object.botPromotionMessageMetadata);
            }
            if (object.botModeSelectionMetadata != null) {
                if (typeof object.botModeSelectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botModeSelectionMetadata: object expected");
                message.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.fromObject(object.botModeSelectionMetadata);
            }
            if (object.botQuotaMetadata != null) {
                if (typeof object.botQuotaMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botQuotaMetadata: object expected");
                message.botQuotaMetadata = $root.proto.BotQuotaMetadata.fromObject(object.botQuotaMetadata);
            }
            if (object.botAgeCollectionMetadata != null) {
                if (typeof object.botAgeCollectionMetadata !== "object")
                    throw TypeError(".proto.BotMetadata.botAgeCollectionMetadata: object expected");
                message.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.fromObject(object.botAgeCollectionMetadata);
            }
            return message;
        };

        /**
         * Creates a plain object from a BotMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMetadata
         * @static
         * @param {proto.BotMetadata} message BotMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.avatarMetadata != null && message.hasOwnProperty("avatarMetadata")) {
                object.avatarMetadata = $root.proto.BotAvatarMetadata.toObject(message.avatarMetadata, options);
                if (options.oneofs)
                    object._avatarMetadata = "avatarMetadata";
            }
            if (message.personaId != null && message.hasOwnProperty("personaId")) {
                object.personaId = message.personaId;
                if (options.oneofs)
                    object._personaId = "personaId";
            }
            if (message.pluginMetadata != null && message.hasOwnProperty("pluginMetadata")) {
                object.pluginMetadata = $root.proto.BotPluginMetadata.toObject(message.pluginMetadata, options);
                if (options.oneofs)
                    object._pluginMetadata = "pluginMetadata";
            }
            if (message.suggestedPromptMetadata != null && message.hasOwnProperty("suggestedPromptMetadata")) {
                object.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.toObject(message.suggestedPromptMetadata, options);
                if (options.oneofs)
                    object._suggestedPromptMetadata = "suggestedPromptMetadata";
            }
            if (message.invokerJid != null && message.hasOwnProperty("invokerJid")) {
                object.invokerJid = message.invokerJid;
                if (options.oneofs)
                    object._invokerJid = "invokerJid";
            }
            if (message.sessionMetadata != null && message.hasOwnProperty("sessionMetadata")) {
                object.sessionMetadata = $root.proto.BotSessionMetadata.toObject(message.sessionMetadata, options);
                if (options.oneofs)
                    object._sessionMetadata = "sessionMetadata";
            }
            if (message.memuMetadata != null && message.hasOwnProperty("memuMetadata")) {
                object.memuMetadata = $root.proto.BotMemuMetadata.toObject(message.memuMetadata, options);
                if (options.oneofs)
                    object._memuMetadata = "memuMetadata";
            }
            if (message.timezone != null && message.hasOwnProperty("timezone")) {
                object.timezone = message.timezone;
                if (options.oneofs)
                    object._timezone = "timezone";
            }
            if (message.reminderMetadata != null && message.hasOwnProperty("reminderMetadata")) {
                object.reminderMetadata = $root.proto.BotReminderMetadata.toObject(message.reminderMetadata, options);
                if (options.oneofs)
                    object._reminderMetadata = "reminderMetadata";
            }
            if (message.modelMetadata != null && message.hasOwnProperty("modelMetadata")) {
                object.modelMetadata = $root.proto.BotModelMetadata.toObject(message.modelMetadata, options);
                if (options.oneofs)
                    object._modelMetadata = "modelMetadata";
            }
            if (message.messageDisclaimerText != null && message.hasOwnProperty("messageDisclaimerText")) {
                object.messageDisclaimerText = message.messageDisclaimerText;
                if (options.oneofs)
                    object._messageDisclaimerText = "messageDisclaimerText";
            }
            if (message.progressIndicatorMetadata != null && message.hasOwnProperty("progressIndicatorMetadata")) {
                object.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.toObject(message.progressIndicatorMetadata, options);
                if (options.oneofs)
                    object._progressIndicatorMetadata = "progressIndicatorMetadata";
            }
            if (message.capabilityMetadata != null && message.hasOwnProperty("capabilityMetadata")) {
                object.capabilityMetadata = $root.proto.BotCapabilityMetadata.toObject(message.capabilityMetadata, options);
                if (options.oneofs)
                    object._capabilityMetadata = "capabilityMetadata";
            }
            if (message.imagineMetadata != null && message.hasOwnProperty("imagineMetadata")) {
                object.imagineMetadata = $root.proto.BotImagineMetadata.toObject(message.imagineMetadata, options);
                if (options.oneofs)
                    object._imagineMetadata = "imagineMetadata";
            }
            if (message.memoryMetadata != null && message.hasOwnProperty("memoryMetadata")) {
                object.memoryMetadata = $root.proto.BotMemoryMetadata.toObject(message.memoryMetadata, options);
                if (options.oneofs)
                    object._memoryMetadata = "memoryMetadata";
            }
            if (message.renderingMetadata != null && message.hasOwnProperty("renderingMetadata")) {
                object.renderingMetadata = $root.proto.BotRenderingMetadata.toObject(message.renderingMetadata, options);
                if (options.oneofs)
                    object._renderingMetadata = "renderingMetadata";
            }
            if (message.botMetricsMetadata != null && message.hasOwnProperty("botMetricsMetadata")) {
                object.botMetricsMetadata = $root.proto.BotMetricsMetadata.toObject(message.botMetricsMetadata, options);
                if (options.oneofs)
                    object._botMetricsMetadata = "botMetricsMetadata";
            }
            if (message.botLinkedAccountsMetadata != null && message.hasOwnProperty("botLinkedAccountsMetadata")) {
                object.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.toObject(message.botLinkedAccountsMetadata, options);
                if (options.oneofs)
                    object._botLinkedAccountsMetadata = "botLinkedAccountsMetadata";
            }
            if (message.richResponseSourcesMetadata != null && message.hasOwnProperty("richResponseSourcesMetadata")) {
                object.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.toObject(message.richResponseSourcesMetadata, options);
                if (options.oneofs)
                    object._richResponseSourcesMetadata = "richResponseSourcesMetadata";
            }
            if (message.aiConversationContext != null && message.hasOwnProperty("aiConversationContext")) {
                object.aiConversationContext = options.bytes === String ? $util.base64.encode(message.aiConversationContext, 0, message.aiConversationContext.length) : options.bytes === Array ? Array.prototype.slice.call(message.aiConversationContext) : message.aiConversationContext;
                if (options.oneofs)
                    object._aiConversationContext = "aiConversationContext";
            }
            if (message.botPromotionMessageMetadata != null && message.hasOwnProperty("botPromotionMessageMetadata")) {
                object.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.toObject(message.botPromotionMessageMetadata, options);
                if (options.oneofs)
                    object._botPromotionMessageMetadata = "botPromotionMessageMetadata";
            }
            if (message.botModeSelectionMetadata != null && message.hasOwnProperty("botModeSelectionMetadata")) {
                object.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.toObject(message.botModeSelectionMetadata, options);
                if (options.oneofs)
                    object._botModeSelectionMetadata = "botModeSelectionMetadata";
            }
            if (message.botQuotaMetadata != null && message.hasOwnProperty("botQuotaMetadata")) {
                object.botQuotaMetadata = $root.proto.BotQuotaMetadata.toObject(message.botQuotaMetadata, options);
                if (options.oneofs)
                    object._botQuotaMetadata = "botQuotaMetadata";
            }
            if (message.botAgeCollectionMetadata != null && message.hasOwnProperty("botAgeCollectionMetadata")) {
                object.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.toObject(message.botAgeCollectionMetadata, options);
                if (options.oneofs)
                    object._botAgeCollectionMetadata = "botAgeCollectionMetadata";
            }
            return object;
        };

        /**
         * Converts this BotMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMetadata
         * @function getTypeUrl
         * @memberof proto.BotMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetadata";
        };

        return BotMetadata;
    })();

    /**
     * BotMetricsEntryPoint enum.
     * @name proto.BotMetricsEntryPoint
     * @enum {number}
     * @property {number} FAVICON=1 FAVICON value
     * @property {number} CHATLIST=2 CHATLIST value
     * @property {number} AISEARCH_NULL_STATE_PAPER_PLANE=3 AISEARCH_NULL_STATE_PAPER_PLANE value
     * @property {number} AISEARCH_NULL_STATE_SUGGESTION=4 AISEARCH_NULL_STATE_SUGGESTION value
     * @property {number} AISEARCH_TYPE_AHEAD_SUGGESTION=5 AISEARCH_TYPE_AHEAD_SUGGESTION value
     * @property {number} AISEARCH_TYPE_AHEAD_PAPER_PLANE=6 AISEARCH_TYPE_AHEAD_PAPER_PLANE value
     * @property {number} AISEARCH_TYPE_AHEAD_RESULT_CHATLIST=7 AISEARCH_TYPE_AHEAD_RESULT_CHATLIST value
     * @property {number} AISEARCH_TYPE_AHEAD_RESULT_MESSAGES=8 AISEARCH_TYPE_AHEAD_RESULT_MESSAGES value
     * @property {number} AIVOICE_SEARCH_BAR=9 AIVOICE_SEARCH_BAR value
     * @property {number} AIVOICE_FAVICON=10 AIVOICE_FAVICON value
     * @property {number} AISTUDIO=11 AISTUDIO value
     * @property {number} DEEPLINK=12 DEEPLINK value
     * @property {number} NOTIFICATION=13 NOTIFICATION value
     * @property {number} PROFILE_MESSAGE_BUTTON=14 PROFILE_MESSAGE_BUTTON value
     * @property {number} FORWARD=15 FORWARD value
     * @property {number} APP_SHORTCUT=16 APP_SHORTCUT value
     * @property {number} FF_FAMILY=17 FF_FAMILY value
     * @property {number} AI_TAB=18 AI_TAB value
     * @property {number} AI_HOME=19 AI_HOME value
     * @property {number} AI_DEEPLINK_IMMERSIVE=20 AI_DEEPLINK_IMMERSIVE value
     * @property {number} AI_DEEPLINK=21 AI_DEEPLINK value
     * @property {number} META_AI_CHAT_SHORTCUT_AI_STUDIO=22 META_AI_CHAT_SHORTCUT_AI_STUDIO value
     * @property {number} UGC_CHAT_SHORTCUT_AI_STUDIO=23 UGC_CHAT_SHORTCUT_AI_STUDIO value
     * @property {number} NEW_CHAT_AI_STUDIO=24 NEW_CHAT_AI_STUDIO value
     */
    proto.BotMetricsEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "FAVICON"] = 1;
        values[valuesById[2] = "CHATLIST"] = 2;
        values[valuesById[3] = "AISEARCH_NULL_STATE_PAPER_PLANE"] = 3;
        values[valuesById[4] = "AISEARCH_NULL_STATE_SUGGESTION"] = 4;
        values[valuesById[5] = "AISEARCH_TYPE_AHEAD_SUGGESTION"] = 5;
        values[valuesById[6] = "AISEARCH_TYPE_AHEAD_PAPER_PLANE"] = 6;
        values[valuesById[7] = "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST"] = 7;
        values[valuesById[8] = "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES"] = 8;
        values[valuesById[9] = "AIVOICE_SEARCH_BAR"] = 9;
        values[valuesById[10] = "AIVOICE_FAVICON"] = 10;
        values[valuesById[11] = "AISTUDIO"] = 11;
        values[valuesById[12] = "DEEPLINK"] = 12;
        values[valuesById[13] = "NOTIFICATION"] = 13;
        values[valuesById[14] = "PROFILE_MESSAGE_BUTTON"] = 14;
        values[valuesById[15] = "FORWARD"] = 15;
        values[valuesById[16] = "APP_SHORTCUT"] = 16;
        values[valuesById[17] = "FF_FAMILY"] = 17;
        values[valuesById[18] = "AI_TAB"] = 18;
        values[valuesById[19] = "AI_HOME"] = 19;
        values[valuesById[20] = "AI_DEEPLINK_IMMERSIVE"] = 20;
        values[valuesById[21] = "AI_DEEPLINK"] = 21;
        values[valuesById[22] = "META_AI_CHAT_SHORTCUT_AI_STUDIO"] = 22;
        values[valuesById[23] = "UGC_CHAT_SHORTCUT_AI_STUDIO"] = 23;
        values[valuesById[24] = "NEW_CHAT_AI_STUDIO"] = 24;
        return values;
    })();

    proto.BotMetricsMetadata = (function() {

        /**
         * Properties of a BotMetricsMetadata.
         * @memberof proto
         * @interface IBotMetricsMetadata
         * @property {string|null} [destinationId] BotMetricsMetadata destinationId
         * @property {proto.BotMetricsEntryPoint|null} [destinationEntryPoint] BotMetricsMetadata destinationEntryPoint
         * @property {proto.BotMetricsThreadEntryPoint|null} [threadOrigin] BotMetricsMetadata threadOrigin
         */

        /**
         * Constructs a new BotMetricsMetadata.
         * @memberof proto
         * @classdesc Represents a BotMetricsMetadata.
         * @implements IBotMetricsMetadata
         * @constructor
         * @param {proto.IBotMetricsMetadata=} [properties] Properties to set
         */
        function BotMetricsMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotMetricsMetadata destinationId.
         * @member {string|null|undefined} destinationId
         * @memberof proto.BotMetricsMetadata
         * @instance
         */
        BotMetricsMetadata.prototype.destinationId = null;

        /**
         * BotMetricsMetadata destinationEntryPoint.
         * @member {proto.BotMetricsEntryPoint|null|undefined} destinationEntryPoint
         * @memberof proto.BotMetricsMetadata
         * @instance
         */
        BotMetricsMetadata.prototype.destinationEntryPoint = null;

        /**
         * BotMetricsMetadata threadOrigin.
         * @member {proto.BotMetricsThreadEntryPoint|null|undefined} threadOrigin
         * @memberof proto.BotMetricsMetadata
         * @instance
         */
        BotMetricsMetadata.prototype.threadOrigin = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationId", {
            get: $util.oneOfGetter($oneOfFields = ["destinationId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_destinationEntryPoint", {
            get: $util.oneOfGetter($oneOfFields = ["destinationEntryPoint"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotMetricsMetadata.prototype, "_threadOrigin", {
            get: $util.oneOfGetter($oneOfFields = ["threadOrigin"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotMetricsMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {proto.IBotMetricsMetadata=} [properties] Properties to set
         * @returns {proto.BotMetricsMetadata} BotMetricsMetadata instance
         */
        BotMetricsMetadata.create = function create(properties) {
            return new BotMetricsMetadata(properties);
        };

        /**
         * Encodes the specified BotMetricsMetadata message. Does not implicitly {@link proto.BotMetricsMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {proto.IBotMetricsMetadata} message BotMetricsMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMetricsMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.destinationId != null && Object.hasOwnProperty.call(message, "destinationId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.destinationId);
            if (message.destinationEntryPoint != null && Object.hasOwnProperty.call(message, "destinationEntryPoint"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.destinationEntryPoint);
            if (message.threadOrigin != null && Object.hasOwnProperty.call(message, "threadOrigin"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.threadOrigin);
            return writer;
        };

        /**
         * Encodes the specified BotMetricsMetadata message, length delimited. Does not implicitly {@link proto.BotMetricsMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {proto.IBotMetricsMetadata} message BotMetricsMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotMetricsMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotMetricsMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotMetricsMetadata} BotMetricsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMetricsMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotMetricsMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.destinationId = reader.string();
                        break;
                    }
                case 2: {
                        message.destinationEntryPoint = reader.int32();
                        break;
                    }
                case 3: {
                        message.threadOrigin = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotMetricsMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotMetricsMetadata} BotMetricsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotMetricsMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotMetricsMetadata message.
         * @function verify
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotMetricsMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.destinationId != null && message.hasOwnProperty("destinationId")) {
                properties._destinationId = 1;
                if (!$util.isString(message.destinationId))
                    return "destinationId: string expected";
            }
            if (message.destinationEntryPoint != null && message.hasOwnProperty("destinationEntryPoint")) {
                properties._destinationEntryPoint = 1;
                switch (message.destinationEntryPoint) {
                default:
                    return "destinationEntryPoint: enum value expected";
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                case 17:
                case 18:
                case 19:
                case 20:
                case 21:
                case 22:
                case 23:
                case 24:
                    break;
                }
            }
            if (message.threadOrigin != null && message.hasOwnProperty("threadOrigin")) {
                properties._threadOrigin = 1;
                switch (message.threadOrigin) {
                default:
                    return "threadOrigin: enum value expected";
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotMetricsMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotMetricsMetadata} BotMetricsMetadata
         */
        BotMetricsMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotMetricsMetadata)
                return object;
            let message = new $root.proto.BotMetricsMetadata();
            if (object.destinationId != null)
                message.destinationId = String(object.destinationId);
            switch (object.destinationEntryPoint) {
            default:
                if (typeof object.destinationEntryPoint === "number") {
                    message.destinationEntryPoint = object.destinationEntryPoint;
                    break;
                }
                break;
            case "FAVICON":
            case 1:
                message.destinationEntryPoint = 1;
                break;
            case "CHATLIST":
            case 2:
                message.destinationEntryPoint = 2;
                break;
            case "AISEARCH_NULL_STATE_PAPER_PLANE":
            case 3:
                message.destinationEntryPoint = 3;
                break;
            case "AISEARCH_NULL_STATE_SUGGESTION":
            case 4:
                message.destinationEntryPoint = 4;
                break;
            case "AISEARCH_TYPE_AHEAD_SUGGESTION":
            case 5:
                message.destinationEntryPoint = 5;
                break;
            case "AISEARCH_TYPE_AHEAD_PAPER_PLANE":
            case 6:
                message.destinationEntryPoint = 6;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST":
            case 7:
                message.destinationEntryPoint = 7;
                break;
            case "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES":
            case 8:
                message.destinationEntryPoint = 8;
                break;
            case "AIVOICE_SEARCH_BAR":
            case 9:
                message.destinationEntryPoint = 9;
                break;
            case "AIVOICE_FAVICON":
            case 10:
                message.destinationEntryPoint = 10;
                break;
            case "AISTUDIO":
            case 11:
                message.destinationEntryPoint = 11;
                break;
            case "DEEPLINK":
            case 12:
                message.destinationEntryPoint = 12;
                break;
            case "NOTIFICATION":
            case 13:
                message.destinationEntryPoint = 13;
                break;
            case "PROFILE_MESSAGE_BUTTON":
            case 14:
                message.destinationEntryPoint = 14;
                break;
            case "FORWARD":
            case 15:
                message.destinationEntryPoint = 15;
                break;
            case "APP_SHORTCUT":
            case 16:
                message.destinationEntryPoint = 16;
                break;
            case "FF_FAMILY":
            case 17:
                message.destinationEntryPoint = 17;
                break;
            case "AI_TAB":
            case 18:
                message.destinationEntryPoint = 18;
                break;
            case "AI_HOME":
            case 19:
                message.destinationEntryPoint = 19;
                break;
            case "AI_DEEPLINK_IMMERSIVE":
            case 20:
                message.destinationEntryPoint = 20;
                break;
            case "AI_DEEPLINK":
            case 21:
                message.destinationEntryPoint = 21;
                break;
            case "META_AI_CHAT_SHORTCUT_AI_STUDIO":
            case 22:
                message.destinationEntryPoint = 22;
                break;
            case "UGC_CHAT_SHORTCUT_AI_STUDIO":
            case 23:
                message.destinationEntryPoint = 23;
                break;
            case "NEW_CHAT_AI_STUDIO":
            case 24:
                message.destinationEntryPoint = 24;
                break;
            }
            switch (object.threadOrigin) {
            default:
                if (typeof object.threadOrigin === "number") {
                    message.threadOrigin = object.threadOrigin;
                    break;
                }
                break;
            case "AI_TAB_THREAD":
            case 1:
                message.threadOrigin = 1;
                break;
            case "AI_HOME_THREAD":
            case 2:
                message.threadOrigin = 2;
                break;
            case "AI_DEEPLINK_IMMERSIVE_THREAD":
            case 3:
                message.threadOrigin = 3;
                break;
            case "AI_DEEPLINK_THREAD":
            case 4:
                message.threadOrigin = 4;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotMetricsMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {proto.BotMetricsMetadata} message BotMetricsMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotMetricsMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.destinationId != null && message.hasOwnProperty("destinationId")) {
                object.destinationId = message.destinationId;
                if (options.oneofs)
                    object._destinationId = "destinationId";
            }
            if (message.destinationEntryPoint != null && message.hasOwnProperty("destinationEntryPoint")) {
                object.destinationEntryPoint = options.enums === String ? $root.proto.BotMetricsEntryPoint[message.destinationEntryPoint] === undefined ? message.destinationEntryPoint : $root.proto.BotMetricsEntryPoint[message.destinationEntryPoint] : message.destinationEntryPoint;
                if (options.oneofs)
                    object._destinationEntryPoint = "destinationEntryPoint";
            }
            if (message.threadOrigin != null && message.hasOwnProperty("threadOrigin")) {
                object.threadOrigin = options.enums === String ? $root.proto.BotMetricsThreadEntryPoint[message.threadOrigin] === undefined ? message.threadOrigin : $root.proto.BotMetricsThreadEntryPoint[message.threadOrigin] : message.threadOrigin;
                if (options.oneofs)
                    object._threadOrigin = "threadOrigin";
            }
            return object;
        };

        /**
         * Converts this BotMetricsMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotMetricsMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotMetricsMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotMetricsMetadata
         * @function getTypeUrl
         * @memberof proto.BotMetricsMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotMetricsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetricsMetadata";
        };

        return BotMetricsMetadata;
    })();

    /**
     * BotMetricsThreadEntryPoint enum.
     * @name proto.BotMetricsThreadEntryPoint
     * @enum {number}
     * @property {number} AI_TAB_THREAD=1 AI_TAB_THREAD value
     * @property {number} AI_HOME_THREAD=2 AI_HOME_THREAD value
     * @property {number} AI_DEEPLINK_IMMERSIVE_THREAD=3 AI_DEEPLINK_IMMERSIVE_THREAD value
     * @property {number} AI_DEEPLINK_THREAD=4 AI_DEEPLINK_THREAD value
     */
    proto.BotMetricsThreadEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "AI_TAB_THREAD"] = 1;
        values[valuesById[2] = "AI_HOME_THREAD"] = 2;
        values[valuesById[3] = "AI_DEEPLINK_IMMERSIVE_THREAD"] = 3;
        values[valuesById[4] = "AI_DEEPLINK_THREAD"] = 4;
        return values;
    })();

    proto.BotModeSelectionMetadata = (function() {

        /**
         * Properties of a BotModeSelectionMetadata.
         * @memberof proto
         * @interface IBotModeSelectionMetadata
         * @property {Array.<proto.BotModeSelectionMetadata.BotUserSelectionMode>|null} [mode] BotModeSelectionMetadata mode
         */

        /**
         * Constructs a new BotModeSelectionMetadata.
         * @memberof proto
         * @classdesc Represents a BotModeSelectionMetadata.
         * @implements IBotModeSelectionMetadata
         * @constructor
         * @param {proto.IBotModeSelectionMetadata=} [properties] Properties to set
         */
        function BotModeSelectionMetadata(properties) {
            this.mode = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotModeSelectionMetadata mode.
         * @member {Array.<proto.BotModeSelectionMetadata.BotUserSelectionMode>} mode
         * @memberof proto.BotModeSelectionMetadata
         * @instance
         */
        BotModeSelectionMetadata.prototype.mode = $util.emptyArray;

        /**
         * Creates a new BotModeSelectionMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {proto.IBotModeSelectionMetadata=} [properties] Properties to set
         * @returns {proto.BotModeSelectionMetadata} BotModeSelectionMetadata instance
         */
        BotModeSelectionMetadata.create = function create(properties) {
            return new BotModeSelectionMetadata(properties);
        };

        /**
         * Encodes the specified BotModeSelectionMetadata message. Does not implicitly {@link proto.BotModeSelectionMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {proto.IBotModeSelectionMetadata} message BotModeSelectionMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotModeSelectionMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.mode != null && message.mode.length) {
                writer.uint32(/* id 1, wireType 2 =*/10).fork();
                for (let i = 0; i < message.mode.length; ++i)
                    writer.int32(message.mode[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified BotModeSelectionMetadata message, length delimited. Does not implicitly {@link proto.BotModeSelectionMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {proto.IBotModeSelectionMetadata} message BotModeSelectionMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotModeSelectionMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotModeSelectionMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotModeSelectionMetadata} BotModeSelectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotModeSelectionMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotModeSelectionMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.mode && message.mode.length))
                            message.mode = [];
                        if ((tag & 7) === 2) {
                            let end2 = reader.uint32() + reader.pos;
                            while (reader.pos < end2)
                                message.mode.push(reader.int32());
                        } else
                            message.mode.push(reader.int32());
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotModeSelectionMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotModeSelectionMetadata} BotModeSelectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotModeSelectionMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotModeSelectionMetadata message.
         * @function verify
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotModeSelectionMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.mode != null && message.hasOwnProperty("mode")) {
                if (!Array.isArray(message.mode))
                    return "mode: array expected";
                for (let i = 0; i < message.mode.length; ++i)
                    switch (message.mode[i]) {
                    default:
                        return "mode: enum value[] expected";
                    case 0:
                    case 1:
                        break;
                    }
            }
            return null;
        };

        /**
         * Creates a BotModeSelectionMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotModeSelectionMetadata} BotModeSelectionMetadata
         */
        BotModeSelectionMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotModeSelectionMetadata)
                return object;
            let message = new $root.proto.BotModeSelectionMetadata();
            if (object.mode) {
                if (!Array.isArray(object.mode))
                    throw TypeError(".proto.BotModeSelectionMetadata.mode: array expected");
                message.mode = [];
                for (let i = 0; i < object.mode.length; ++i)
                    switch (object.mode[i]) {
                    default:
                        if (typeof object.mode[i] === "number") {
                            message.mode[i] = object.mode[i];
                            break;
                        }
                    case "UNKNOWN_MODE":
                    case 0:
                        message.mode[i] = 0;
                        break;
                    case "REASONING_MODE":
                    case 1:
                        message.mode[i] = 1;
                        break;
                    }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotModeSelectionMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {proto.BotModeSelectionMetadata} message BotModeSelectionMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotModeSelectionMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.mode = [];
            if (message.mode && message.mode.length) {
                object.mode = [];
                for (let j = 0; j < message.mode.length; ++j)
                    object.mode[j] = options.enums === String ? $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[message.mode[j]] === undefined ? message.mode[j] : $root.proto.BotModeSelectionMetadata.BotUserSelectionMode[message.mode[j]] : message.mode[j];
            }
            return object;
        };

        /**
         * Converts this BotModeSelectionMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotModeSelectionMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotModeSelectionMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotModeSelectionMetadata
         * @function getTypeUrl
         * @memberof proto.BotModeSelectionMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotModeSelectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModeSelectionMetadata";
        };

        /**
         * BotUserSelectionMode enum.
         * @name proto.BotModeSelectionMetadata.BotUserSelectionMode
         * @enum {number}
         * @property {number} UNKNOWN_MODE=0 UNKNOWN_MODE value
         * @property {number} REASONING_MODE=1 REASONING_MODE value
         */
        BotModeSelectionMetadata.BotUserSelectionMode = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_MODE"] = 0;
            values[valuesById[1] = "REASONING_MODE"] = 1;
            return values;
        })();

        return BotModeSelectionMetadata;
    })();

    proto.BotModelMetadata = (function() {

        /**
         * Properties of a BotModelMetadata.
         * @memberof proto
         * @interface IBotModelMetadata
         * @property {proto.BotModelMetadata.ModelType|null} [modelType] BotModelMetadata modelType
         * @property {proto.BotModelMetadata.PremiumModelStatus|null} [premiumModelStatus] BotModelMetadata premiumModelStatus
         */

        /**
         * Constructs a new BotModelMetadata.
         * @memberof proto
         * @classdesc Represents a BotModelMetadata.
         * @implements IBotModelMetadata
         * @constructor
         * @param {proto.IBotModelMetadata=} [properties] Properties to set
         */
        function BotModelMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotModelMetadata modelType.
         * @member {proto.BotModelMetadata.ModelType|null|undefined} modelType
         * @memberof proto.BotModelMetadata
         * @instance
         */
        BotModelMetadata.prototype.modelType = null;

        /**
         * BotModelMetadata premiumModelStatus.
         * @member {proto.BotModelMetadata.PremiumModelStatus|null|undefined} premiumModelStatus
         * @memberof proto.BotModelMetadata
         * @instance
         */
        BotModelMetadata.prototype.premiumModelStatus = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_modelType", {
            get: $util.oneOfGetter($oneOfFields = ["modelType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotModelMetadata.prototype, "_premiumModelStatus", {
            get: $util.oneOfGetter($oneOfFields = ["premiumModelStatus"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotModelMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotModelMetadata
         * @static
         * @param {proto.IBotModelMetadata=} [properties] Properties to set
         * @returns {proto.BotModelMetadata} BotModelMetadata instance
         */
        BotModelMetadata.create = function create(properties) {
            return new BotModelMetadata(properties);
        };

        /**
         * Encodes the specified BotModelMetadata message. Does not implicitly {@link proto.BotModelMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotModelMetadata
         * @static
         * @param {proto.IBotModelMetadata} message BotModelMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotModelMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.modelType != null && Object.hasOwnProperty.call(message, "modelType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.modelType);
            if (message.premiumModelStatus != null && Object.hasOwnProperty.call(message, "premiumModelStatus"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.premiumModelStatus);
            return writer;
        };

        /**
         * Encodes the specified BotModelMetadata message, length delimited. Does not implicitly {@link proto.BotModelMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotModelMetadata
         * @static
         * @param {proto.IBotModelMetadata} message BotModelMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotModelMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotModelMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotModelMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotModelMetadata} BotModelMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotModelMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotModelMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.modelType = reader.int32();
                        break;
                    }
                case 2: {
                        message.premiumModelStatus = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotModelMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotModelMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotModelMetadata} BotModelMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotModelMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotModelMetadata message.
         * @function verify
         * @memberof proto.BotModelMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotModelMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.modelType != null && message.hasOwnProperty("modelType")) {
                properties._modelType = 1;
                switch (message.modelType) {
                default:
                    return "modelType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            if (message.premiumModelStatus != null && message.hasOwnProperty("premiumModelStatus")) {
                properties._premiumModelStatus = 1;
                switch (message.premiumModelStatus) {
                default:
                    return "premiumModelStatus: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotModelMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotModelMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotModelMetadata} BotModelMetadata
         */
        BotModelMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotModelMetadata)
                return object;
            let message = new $root.proto.BotModelMetadata();
            switch (object.modelType) {
            default:
                if (typeof object.modelType === "number") {
                    message.modelType = object.modelType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                message.modelType = 0;
                break;
            case "LLAMA_PROD":
            case 1:
                message.modelType = 1;
                break;
            case "LLAMA_PROD_PREMIUM":
            case 2:
                message.modelType = 2;
                break;
            }
            switch (object.premiumModelStatus) {
            default:
                if (typeof object.premiumModelStatus === "number") {
                    message.premiumModelStatus = object.premiumModelStatus;
                    break;
                }
                break;
            case "UNKNOWN_STATUS":
            case 0:
                message.premiumModelStatus = 0;
                break;
            case "AVAILABLE":
            case 1:
                message.premiumModelStatus = 1;
                break;
            case "QUOTA_EXCEED_LIMIT":
            case 2:
                message.premiumModelStatus = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotModelMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotModelMetadata
         * @static
         * @param {proto.BotModelMetadata} message BotModelMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotModelMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.modelType != null && message.hasOwnProperty("modelType")) {
                object.modelType = options.enums === String ? $root.proto.BotModelMetadata.ModelType[message.modelType] === undefined ? message.modelType : $root.proto.BotModelMetadata.ModelType[message.modelType] : message.modelType;
                if (options.oneofs)
                    object._modelType = "modelType";
            }
            if (message.premiumModelStatus != null && message.hasOwnProperty("premiumModelStatus")) {
                object.premiumModelStatus = options.enums === String ? $root.proto.BotModelMetadata.PremiumModelStatus[message.premiumModelStatus] === undefined ? message.premiumModelStatus : $root.proto.BotModelMetadata.PremiumModelStatus[message.premiumModelStatus] : message.premiumModelStatus;
                if (options.oneofs)
                    object._premiumModelStatus = "premiumModelStatus";
            }
            return object;
        };

        /**
         * Converts this BotModelMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotModelMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotModelMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotModelMetadata
         * @function getTypeUrl
         * @memberof proto.BotModelMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotModelMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModelMetadata";
        };

        /**
         * ModelType enum.
         * @name proto.BotModelMetadata.ModelType
         * @enum {number}
         * @property {number} UNKNOWN_TYPE=0 UNKNOWN_TYPE value
         * @property {number} LLAMA_PROD=1 LLAMA_PROD value
         * @property {number} LLAMA_PROD_PREMIUM=2 LLAMA_PROD_PREMIUM value
         */
        BotModelMetadata.ModelType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "LLAMA_PROD"] = 1;
            values[valuesById[2] = "LLAMA_PROD_PREMIUM"] = 2;
            return values;
        })();

        /**
         * PremiumModelStatus enum.
         * @name proto.BotModelMetadata.PremiumModelStatus
         * @enum {number}
         * @property {number} UNKNOWN_STATUS=0 UNKNOWN_STATUS value
         * @property {number} AVAILABLE=1 AVAILABLE value
         * @property {number} QUOTA_EXCEED_LIMIT=2 QUOTA_EXCEED_LIMIT value
         */
        BotModelMetadata.PremiumModelStatus = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_STATUS"] = 0;
            values[valuesById[1] = "AVAILABLE"] = 1;
            values[valuesById[2] = "QUOTA_EXCEED_LIMIT"] = 2;
            return values;
        })();

        return BotModelMetadata;
    })();

    proto.BotPluginMetadata = (function() {

        /**
         * Properties of a BotPluginMetadata.
         * @memberof proto
         * @interface IBotPluginMetadata
         * @property {proto.BotPluginMetadata.SearchProvider|null} [provider] BotPluginMetadata provider
         * @property {proto.BotPluginMetadata.PluginType|null} [pluginType] BotPluginMetadata pluginType
         * @property {string|null} [thumbnailCdnUrl] BotPluginMetadata thumbnailCdnUrl
         * @property {string|null} [profilePhotoCdnUrl] BotPluginMetadata profilePhotoCdnUrl
         * @property {string|null} [searchProviderUrl] BotPluginMetadata searchProviderUrl
         * @property {number|null} [referenceIndex] BotPluginMetadata referenceIndex
         * @property {number|null} [expectedLinksCount] BotPluginMetadata expectedLinksCount
         * @property {string|null} [searchQuery] BotPluginMetadata searchQuery
         * @property {proto.IMessageKey|null} [parentPluginMessageKey] BotPluginMetadata parentPluginMessageKey
         * @property {proto.BotPluginMetadata.PluginType|null} [deprecatedField] BotPluginMetadata deprecatedField
         * @property {proto.BotPluginMetadata.PluginType|null} [parentPluginType] BotPluginMetadata parentPluginType
         * @property {string|null} [faviconCdnUrl] BotPluginMetadata faviconCdnUrl
         */

        /**
         * Constructs a new BotPluginMetadata.
         * @memberof proto
         * @classdesc Represents a BotPluginMetadata.
         * @implements IBotPluginMetadata
         * @constructor
         * @param {proto.IBotPluginMetadata=} [properties] Properties to set
         */
        function BotPluginMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotPluginMetadata provider.
         * @member {proto.BotPluginMetadata.SearchProvider|null|undefined} provider
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.provider = null;

        /**
         * BotPluginMetadata pluginType.
         * @member {proto.BotPluginMetadata.PluginType|null|undefined} pluginType
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.pluginType = null;

        /**
         * BotPluginMetadata thumbnailCdnUrl.
         * @member {string|null|undefined} thumbnailCdnUrl
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.thumbnailCdnUrl = null;

        /**
         * BotPluginMetadata profilePhotoCdnUrl.
         * @member {string|null|undefined} profilePhotoCdnUrl
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.profilePhotoCdnUrl = null;

        /**
         * BotPluginMetadata searchProviderUrl.
         * @member {string|null|undefined} searchProviderUrl
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.searchProviderUrl = null;

        /**
         * BotPluginMetadata referenceIndex.
         * @member {number|null|undefined} referenceIndex
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.referenceIndex = null;

        /**
         * BotPluginMetadata expectedLinksCount.
         * @member {number|null|undefined} expectedLinksCount
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.expectedLinksCount = null;

        /**
         * BotPluginMetadata searchQuery.
         * @member {string|null|undefined} searchQuery
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.searchQuery = null;

        /**
         * BotPluginMetadata parentPluginMessageKey.
         * @member {proto.IMessageKey|null|undefined} parentPluginMessageKey
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.parentPluginMessageKey = null;

        /**
         * BotPluginMetadata deprecatedField.
         * @member {proto.BotPluginMetadata.PluginType|null|undefined} deprecatedField
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.deprecatedField = null;

        /**
         * BotPluginMetadata parentPluginType.
         * @member {proto.BotPluginMetadata.PluginType|null|undefined} parentPluginType
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.parentPluginType = null;

        /**
         * BotPluginMetadata faviconCdnUrl.
         * @member {string|null|undefined} faviconCdnUrl
         * @memberof proto.BotPluginMetadata
         * @instance
         */
        BotPluginMetadata.prototype.faviconCdnUrl = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_provider", {
            get: $util.oneOfGetter($oneOfFields = ["provider"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_pluginType", {
            get: $util.oneOfGetter($oneOfFields = ["pluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_thumbnailCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["thumbnailCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_profilePhotoCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["profilePhotoCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchProviderUrl", {
            get: $util.oneOfGetter($oneOfFields = ["searchProviderUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_referenceIndex", {
            get: $util.oneOfGetter($oneOfFields = ["referenceIndex"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_expectedLinksCount", {
            get: $util.oneOfGetter($oneOfFields = ["expectedLinksCount"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_searchQuery", {
            get: $util.oneOfGetter($oneOfFields = ["searchQuery"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_deprecatedField", {
            get: $util.oneOfGetter($oneOfFields = ["deprecatedField"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_parentPluginType", {
            get: $util.oneOfGetter($oneOfFields = ["parentPluginType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPluginMetadata.prototype, "_faviconCdnUrl", {
            get: $util.oneOfGetter($oneOfFields = ["faviconCdnUrl"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotPluginMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {proto.IBotPluginMetadata=} [properties] Properties to set
         * @returns {proto.BotPluginMetadata} BotPluginMetadata instance
         */
        BotPluginMetadata.create = function create(properties) {
            return new BotPluginMetadata(properties);
        };

        /**
         * Encodes the specified BotPluginMetadata message. Does not implicitly {@link proto.BotPluginMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {proto.IBotPluginMetadata} message BotPluginMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPluginMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.provider != null && Object.hasOwnProperty.call(message, "provider"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.provider);
            if (message.pluginType != null && Object.hasOwnProperty.call(message, "pluginType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pluginType);
            if (message.thumbnailCdnUrl != null && Object.hasOwnProperty.call(message, "thumbnailCdnUrl"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.thumbnailCdnUrl);
            if (message.profilePhotoCdnUrl != null && Object.hasOwnProperty.call(message, "profilePhotoCdnUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.profilePhotoCdnUrl);
            if (message.searchProviderUrl != null && Object.hasOwnProperty.call(message, "searchProviderUrl"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.searchProviderUrl);
            if (message.referenceIndex != null && Object.hasOwnProperty.call(message, "referenceIndex"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.referenceIndex);
            if (message.expectedLinksCount != null && Object.hasOwnProperty.call(message, "expectedLinksCount"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.expectedLinksCount);
            if (message.searchQuery != null && Object.hasOwnProperty.call(message, "searchQuery"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.searchQuery);
            if (message.parentPluginMessageKey != null && Object.hasOwnProperty.call(message, "parentPluginMessageKey"))
                $root.proto.MessageKey.encode(message.parentPluginMessageKey, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            if (message.deprecatedField != null && Object.hasOwnProperty.call(message, "deprecatedField"))
                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.deprecatedField);
            if (message.parentPluginType != null && Object.hasOwnProperty.call(message, "parentPluginType"))
                writer.uint32(/* id 12, wireType 0 =*/96).int32(message.parentPluginType);
            if (message.faviconCdnUrl != null && Object.hasOwnProperty.call(message, "faviconCdnUrl"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.faviconCdnUrl);
            return writer;
        };

        /**
         * Encodes the specified BotPluginMetadata message, length delimited. Does not implicitly {@link proto.BotPluginMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {proto.IBotPluginMetadata} message BotPluginMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPluginMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotPluginMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotPluginMetadata} BotPluginMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPluginMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotPluginMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.provider = reader.int32();
                        break;
                    }
                case 2: {
                        message.pluginType = reader.int32();
                        break;
                    }
                case 3: {
                        message.thumbnailCdnUrl = reader.string();
                        break;
                    }
                case 4: {
                        message.profilePhotoCdnUrl = reader.string();
                        break;
                    }
                case 5: {
                        message.searchProviderUrl = reader.string();
                        break;
                    }
                case 6: {
                        message.referenceIndex = reader.uint32();
                        break;
                    }
                case 7: {
                        message.expectedLinksCount = reader.uint32();
                        break;
                    }
                case 9: {
                        message.searchQuery = reader.string();
                        break;
                    }
                case 10: {
                        message.parentPluginMessageKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                        break;
                    }
                case 11: {
                        message.deprecatedField = reader.int32();
                        break;
                    }
                case 12: {
                        message.parentPluginType = reader.int32();
                        break;
                    }
                case 13: {
                        message.faviconCdnUrl = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotPluginMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotPluginMetadata} BotPluginMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPluginMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotPluginMetadata message.
         * @function verify
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotPluginMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.provider != null && message.hasOwnProperty("provider")) {
                properties._provider = 1;
                switch (message.provider) {
                default:
                    return "provider: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            }
            if (message.pluginType != null && message.hasOwnProperty("pluginType")) {
                properties._pluginType = 1;
                switch (message.pluginType) {
                default:
                    return "pluginType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            if (message.thumbnailCdnUrl != null && message.hasOwnProperty("thumbnailCdnUrl")) {
                properties._thumbnailCdnUrl = 1;
                if (!$util.isString(message.thumbnailCdnUrl))
                    return "thumbnailCdnUrl: string expected";
            }
            if (message.profilePhotoCdnUrl != null && message.hasOwnProperty("profilePhotoCdnUrl")) {
                properties._profilePhotoCdnUrl = 1;
                if (!$util.isString(message.profilePhotoCdnUrl))
                    return "profilePhotoCdnUrl: string expected";
            }
            if (message.searchProviderUrl != null && message.hasOwnProperty("searchProviderUrl")) {
                properties._searchProviderUrl = 1;
                if (!$util.isString(message.searchProviderUrl))
                    return "searchProviderUrl: string expected";
            }
            if (message.referenceIndex != null && message.hasOwnProperty("referenceIndex")) {
                properties._referenceIndex = 1;
                if (!$util.isInteger(message.referenceIndex))
                    return "referenceIndex: integer expected";
            }
            if (message.expectedLinksCount != null && message.hasOwnProperty("expectedLinksCount")) {
                properties._expectedLinksCount = 1;
                if (!$util.isInteger(message.expectedLinksCount))
                    return "expectedLinksCount: integer expected";
            }
            if (message.searchQuery != null && message.hasOwnProperty("searchQuery")) {
                properties._searchQuery = 1;
                if (!$util.isString(message.searchQuery))
                    return "searchQuery: string expected";
            }
            if (message.parentPluginMessageKey != null && message.hasOwnProperty("parentPluginMessageKey")) {
                properties._parentPluginMessageKey = 1;
                {
                    let error = $root.proto.MessageKey.verify(message.parentPluginMessageKey);
                    if (error)
                        return "parentPluginMessageKey." + error;
                }
            }
            if (message.deprecatedField != null && message.hasOwnProperty("deprecatedField")) {
                properties._deprecatedField = 1;
                switch (message.deprecatedField) {
                default:
                    return "deprecatedField: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            if (message.parentPluginType != null && message.hasOwnProperty("parentPluginType")) {
                properties._parentPluginType = 1;
                switch (message.parentPluginType) {
                default:
                    return "parentPluginType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            }
            if (message.faviconCdnUrl != null && message.hasOwnProperty("faviconCdnUrl")) {
                properties._faviconCdnUrl = 1;
                if (!$util.isString(message.faviconCdnUrl))
                    return "faviconCdnUrl: string expected";
            }
            return null;
        };

        /**
         * Creates a BotPluginMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotPluginMetadata} BotPluginMetadata
         */
        BotPluginMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotPluginMetadata)
                return object;
            let message = new $root.proto.BotPluginMetadata();
            switch (object.provider) {
            default:
                if (typeof object.provider === "number") {
                    message.provider = object.provider;
                    break;
                }
                break;
            case "UNKNOWN":
            case 0:
                message.provider = 0;
                break;
            case "BING":
            case 1:
                message.provider = 1;
                break;
            case "GOOGLE":
            case 2:
                message.provider = 2;
                break;
            case "SUPPORT":
            case 3:
                message.provider = 3;
                break;
            }
            switch (object.pluginType) {
            default:
                if (typeof object.pluginType === "number") {
                    message.pluginType = object.pluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                message.pluginType = 0;
                break;
            case "REELS":
            case 1:
                message.pluginType = 1;
                break;
            case "SEARCH":
            case 2:
                message.pluginType = 2;
                break;
            }
            if (object.thumbnailCdnUrl != null)
                message.thumbnailCdnUrl = String(object.thumbnailCdnUrl);
            if (object.profilePhotoCdnUrl != null)
                message.profilePhotoCdnUrl = String(object.profilePhotoCdnUrl);
            if (object.searchProviderUrl != null)
                message.searchProviderUrl = String(object.searchProviderUrl);
            if (object.referenceIndex != null)
                message.referenceIndex = object.referenceIndex >>> 0;
            if (object.expectedLinksCount != null)
                message.expectedLinksCount = object.expectedLinksCount >>> 0;
            if (object.searchQuery != null)
                message.searchQuery = String(object.searchQuery);
            if (object.parentPluginMessageKey != null) {
                if (typeof object.parentPluginMessageKey !== "object")
                    throw TypeError(".proto.BotPluginMetadata.parentPluginMessageKey: object expected");
                message.parentPluginMessageKey = $root.proto.MessageKey.fromObject(object.parentPluginMessageKey);
            }
            switch (object.deprecatedField) {
            default:
                if (typeof object.deprecatedField === "number") {
                    message.deprecatedField = object.deprecatedField;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                message.deprecatedField = 0;
                break;
            case "REELS":
            case 1:
                message.deprecatedField = 1;
                break;
            case "SEARCH":
            case 2:
                message.deprecatedField = 2;
                break;
            }
            switch (object.parentPluginType) {
            default:
                if (typeof object.parentPluginType === "number") {
                    message.parentPluginType = object.parentPluginType;
                    break;
                }
                break;
            case "UNKNOWN_PLUGIN":
            case 0:
                message.parentPluginType = 0;
                break;
            case "REELS":
            case 1:
                message.parentPluginType = 1;
                break;
            case "SEARCH":
            case 2:
                message.parentPluginType = 2;
                break;
            }
            if (object.faviconCdnUrl != null)
                message.faviconCdnUrl = String(object.faviconCdnUrl);
            return message;
        };

        /**
         * Creates a plain object from a BotPluginMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {proto.BotPluginMetadata} message BotPluginMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotPluginMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.provider != null && message.hasOwnProperty("provider")) {
                object.provider = options.enums === String ? $root.proto.BotPluginMetadata.SearchProvider[message.provider] === undefined ? message.provider : $root.proto.BotPluginMetadata.SearchProvider[message.provider] : message.provider;
                if (options.oneofs)
                    object._provider = "provider";
            }
            if (message.pluginType != null && message.hasOwnProperty("pluginType")) {
                object.pluginType = options.enums === String ? $root.proto.BotPluginMetadata.PluginType[message.pluginType] === undefined ? message.pluginType : $root.proto.BotPluginMetadata.PluginType[message.pluginType] : message.pluginType;
                if (options.oneofs)
                    object._pluginType = "pluginType";
            }
            if (message.thumbnailCdnUrl != null && message.hasOwnProperty("thumbnailCdnUrl")) {
                object.thumbnailCdnUrl = message.thumbnailCdnUrl;
                if (options.oneofs)
                    object._thumbnailCdnUrl = "thumbnailCdnUrl";
            }
            if (message.profilePhotoCdnUrl != null && message.hasOwnProperty("profilePhotoCdnUrl")) {
                object.profilePhotoCdnUrl = message.profilePhotoCdnUrl;
                if (options.oneofs)
                    object._profilePhotoCdnUrl = "profilePhotoCdnUrl";
            }
            if (message.searchProviderUrl != null && message.hasOwnProperty("searchProviderUrl")) {
                object.searchProviderUrl = message.searchProviderUrl;
                if (options.oneofs)
                    object._searchProviderUrl = "searchProviderUrl";
            }
            if (message.referenceIndex != null && message.hasOwnProperty("referenceIndex")) {
                object.referenceIndex = message.referenceIndex;
                if (options.oneofs)
                    object._referenceIndex = "referenceIndex";
            }
            if (message.expectedLinksCount != null && message.hasOwnProperty("expectedLinksCount")) {
                object.expectedLinksCount = message.expectedLinksCount;
                if (options.oneofs)
                    object._expectedLinksCount = "expectedLinksCount";
            }
            if (message.searchQuery != null && message.hasOwnProperty("searchQuery")) {
                object.searchQuery = message.searchQuery;
                if (options.oneofs)
                    object._searchQuery = "searchQuery";
            }
            if (message.parentPluginMessageKey != null && message.hasOwnProperty("parentPluginMessageKey")) {
                object.parentPluginMessageKey = $root.proto.MessageKey.toObject(message.parentPluginMessageKey, options);
                if (options.oneofs)
                    object._parentPluginMessageKey = "parentPluginMessageKey";
            }
            if (message.deprecatedField != null && message.hasOwnProperty("deprecatedField")) {
                object.deprecatedField = options.enums === String ? $root.proto.BotPluginMetadata.PluginType[message.deprecatedField] === undefined ? message.deprecatedField : $root.proto.BotPluginMetadata.PluginType[message.deprecatedField] : message.deprecatedField;
                if (options.oneofs)
                    object._deprecatedField = "deprecatedField";
            }
            if (message.parentPluginType != null && message.hasOwnProperty("parentPluginType")) {
                object.parentPluginType = options.enums === String ? $root.proto.BotPluginMetadata.PluginType[message.parentPluginType] === undefined ? message.parentPluginType : $root.proto.BotPluginMetadata.PluginType[message.parentPluginType] : message.parentPluginType;
                if (options.oneofs)
                    object._parentPluginType = "parentPluginType";
            }
            if (message.faviconCdnUrl != null && message.hasOwnProperty("faviconCdnUrl")) {
                object.faviconCdnUrl = message.faviconCdnUrl;
                if (options.oneofs)
                    object._faviconCdnUrl = "faviconCdnUrl";
            }
            return object;
        };

        /**
         * Converts this BotPluginMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotPluginMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotPluginMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotPluginMetadata
         * @function getTypeUrl
         * @memberof proto.BotPluginMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotPluginMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPluginMetadata";
        };

        /**
         * PluginType enum.
         * @name proto.BotPluginMetadata.PluginType
         * @enum {number}
         * @property {number} UNKNOWN_PLUGIN=0 UNKNOWN_PLUGIN value
         * @property {number} REELS=1 REELS value
         * @property {number} SEARCH=2 SEARCH value
         */
        BotPluginMetadata.PluginType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_PLUGIN"] = 0;
            values[valuesById[1] = "REELS"] = 1;
            values[valuesById[2] = "SEARCH"] = 2;
            return values;
        })();

        /**
         * SearchProvider enum.
         * @name proto.BotPluginMetadata.SearchProvider
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} BING=1 BING value
         * @property {number} GOOGLE=2 GOOGLE value
         * @property {number} SUPPORT=3 SUPPORT value
         */
        BotPluginMetadata.SearchProvider = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "BING"] = 1;
            values[valuesById[2] = "GOOGLE"] = 2;
            values[valuesById[3] = "SUPPORT"] = 3;
            return values;
        })();

        return BotPluginMetadata;
    })();

    proto.BotProgressIndicatorMetadata = (function() {

        /**
         * Properties of a BotProgressIndicatorMetadata.
         * @memberof proto
         * @interface IBotProgressIndicatorMetadata
         * @property {string|null} [progressDescription] BotProgressIndicatorMetadata progressDescription
         * @property {Array.<proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata>|null} [stepsMetadata] BotProgressIndicatorMetadata stepsMetadata
         */

        /**
         * Constructs a new BotProgressIndicatorMetadata.
         * @memberof proto
         * @classdesc Represents a BotProgressIndicatorMetadata.
         * @implements IBotProgressIndicatorMetadata
         * @constructor
         * @param {proto.IBotProgressIndicatorMetadata=} [properties] Properties to set
         */
        function BotProgressIndicatorMetadata(properties) {
            this.stepsMetadata = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotProgressIndicatorMetadata progressDescription.
         * @member {string|null|undefined} progressDescription
         * @memberof proto.BotProgressIndicatorMetadata
         * @instance
         */
        BotProgressIndicatorMetadata.prototype.progressDescription = null;

        /**
         * BotProgressIndicatorMetadata stepsMetadata.
         * @member {Array.<proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata>} stepsMetadata
         * @memberof proto.BotProgressIndicatorMetadata
         * @instance
         */
        BotProgressIndicatorMetadata.prototype.stepsMetadata = $util.emptyArray;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotProgressIndicatorMetadata.prototype, "_progressDescription", {
            get: $util.oneOfGetter($oneOfFields = ["progressDescription"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotProgressIndicatorMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {proto.IBotProgressIndicatorMetadata=} [properties] Properties to set
         * @returns {proto.BotProgressIndicatorMetadata} BotProgressIndicatorMetadata instance
         */
        BotProgressIndicatorMetadata.create = function create(properties) {
            return new BotProgressIndicatorMetadata(properties);
        };

        /**
         * Encodes the specified BotProgressIndicatorMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {proto.IBotProgressIndicatorMetadata} message BotProgressIndicatorMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotProgressIndicatorMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.progressDescription != null && Object.hasOwnProperty.call(message, "progressDescription"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.progressDescription);
            if (message.stepsMetadata != null && message.stepsMetadata.length)
                for (let i = 0; i < message.stepsMetadata.length; ++i)
                    $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.encode(message.stepsMetadata[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotProgressIndicatorMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {proto.IBotProgressIndicatorMetadata} message BotProgressIndicatorMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotProgressIndicatorMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotProgressIndicatorMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotProgressIndicatorMetadata} BotProgressIndicatorMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotProgressIndicatorMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotProgressIndicatorMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.progressDescription = reader.string();
                        break;
                    }
                case 2: {
                        if (!(message.stepsMetadata && message.stepsMetadata.length))
                            message.stepsMetadata = [];
                        message.stepsMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotProgressIndicatorMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotProgressIndicatorMetadata} BotProgressIndicatorMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotProgressIndicatorMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotProgressIndicatorMetadata message.
         * @function verify
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotProgressIndicatorMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.progressDescription != null && message.hasOwnProperty("progressDescription")) {
                properties._progressDescription = 1;
                if (!$util.isString(message.progressDescription))
                    return "progressDescription: string expected";
            }
            if (message.stepsMetadata != null && message.hasOwnProperty("stepsMetadata")) {
                if (!Array.isArray(message.stepsMetadata))
                    return "stepsMetadata: array expected";
                for (let i = 0; i < message.stepsMetadata.length; ++i) {
                    let error = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.verify(message.stepsMetadata[i]);
                    if (error)
                        return "stepsMetadata." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotProgressIndicatorMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotProgressIndicatorMetadata} BotProgressIndicatorMetadata
         */
        BotProgressIndicatorMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotProgressIndicatorMetadata)
                return object;
            let message = new $root.proto.BotProgressIndicatorMetadata();
            if (object.progressDescription != null)
                message.progressDescription = String(object.progressDescription);
            if (object.stepsMetadata) {
                if (!Array.isArray(object.stepsMetadata))
                    throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: array expected");
                message.stepsMetadata = [];
                for (let i = 0; i < object.stepsMetadata.length; ++i) {
                    if (typeof object.stepsMetadata[i] !== "object")
                        throw TypeError(".proto.BotProgressIndicatorMetadata.stepsMetadata: object expected");
                    message.stepsMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.fromObject(object.stepsMetadata[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotProgressIndicatorMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {proto.BotProgressIndicatorMetadata} message BotProgressIndicatorMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotProgressIndicatorMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.stepsMetadata = [];
            if (message.progressDescription != null && message.hasOwnProperty("progressDescription")) {
                object.progressDescription = message.progressDescription;
                if (options.oneofs)
                    object._progressDescription = "progressDescription";
            }
            if (message.stepsMetadata && message.stepsMetadata.length) {
                object.stepsMetadata = [];
                for (let j = 0; j < message.stepsMetadata.length; ++j)
                    object.stepsMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.toObject(message.stepsMetadata[j], options);
            }
            return object;
        };

        /**
         * Converts this BotProgressIndicatorMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotProgressIndicatorMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotProgressIndicatorMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotProgressIndicatorMetadata
         * @function getTypeUrl
         * @memberof proto.BotProgressIndicatorMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotProgressIndicatorMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata";
        };

        BotProgressIndicatorMetadata.BotPlanningStepMetadata = (function() {

            /**
             * Properties of a BotPlanningStepMetadata.
             * @memberof proto.BotProgressIndicatorMetadata
             * @interface IBotPlanningStepMetadata
             * @property {string|null} [statusTitle] BotPlanningStepMetadata statusTitle
             * @property {string|null} [statusBody] BotPlanningStepMetadata statusBody
             * @property {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata>|null} [sourcesMetadata] BotPlanningStepMetadata sourcesMetadata
             * @property {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus|null} [status] BotPlanningStepMetadata status
             * @property {boolean|null} [isReasoning] BotPlanningStepMetadata isReasoning
             * @property {boolean|null} [isEnhancedSearch] BotPlanningStepMetadata isEnhancedSearch
             * @property {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata>|null} [sections] BotPlanningStepMetadata sections
             */

            /**
             * Constructs a new BotPlanningStepMetadata.
             * @memberof proto.BotProgressIndicatorMetadata
             * @classdesc Represents a BotPlanningStepMetadata.
             * @implements IBotPlanningStepMetadata
             * @constructor
             * @param {proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata=} [properties] Properties to set
             */
            function BotPlanningStepMetadata(properties) {
                this.sourcesMetadata = [];
                this.sections = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * BotPlanningStepMetadata statusTitle.
             * @member {string|null|undefined} statusTitle
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.statusTitle = null;

            /**
             * BotPlanningStepMetadata statusBody.
             * @member {string|null|undefined} statusBody
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.statusBody = null;

            /**
             * BotPlanningStepMetadata sourcesMetadata.
             * @member {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata>} sourcesMetadata
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.sourcesMetadata = $util.emptyArray;

            /**
             * BotPlanningStepMetadata status.
             * @member {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus|null|undefined} status
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.status = null;

            /**
             * BotPlanningStepMetadata isReasoning.
             * @member {boolean|null|undefined} isReasoning
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.isReasoning = null;

            /**
             * BotPlanningStepMetadata isEnhancedSearch.
             * @member {boolean|null|undefined} isEnhancedSearch
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.isEnhancedSearch = null;

            /**
             * BotPlanningStepMetadata sections.
             * @member {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata>} sections
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             */
            BotPlanningStepMetadata.prototype.sections = $util.emptyArray;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusTitle", {
                get: $util.oneOfGetter($oneOfFields = ["statusTitle"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_statusBody", {
                get: $util.oneOfGetter($oneOfFields = ["statusBody"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_status", {
                get: $util.oneOfGetter($oneOfFields = ["status"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isReasoning", {
                get: $util.oneOfGetter($oneOfFields = ["isReasoning"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotPlanningStepMetadata.prototype, "_isEnhancedSearch", {
                get: $util.oneOfGetter($oneOfFields = ["isEnhancedSearch"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new BotPlanningStepMetadata instance using the specified properties.
             * @function create
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata=} [properties] Properties to set
             * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata} BotPlanningStepMetadata instance
             */
            BotPlanningStepMetadata.create = function create(properties) {
                return new BotPlanningStepMetadata(properties);
            };

            /**
             * Encodes the specified BotPlanningStepMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata} message BotPlanningStepMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            BotPlanningStepMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.statusTitle != null && Object.hasOwnProperty.call(message, "statusTitle"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.statusTitle);
                if (message.statusBody != null && Object.hasOwnProperty.call(message, "statusBody"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.statusBody);
                if (message.sourcesMetadata != null && message.sourcesMetadata.length)
                    for (let i = 0; i < message.sourcesMetadata.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.encode(message.sourcesMetadata[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                    writer.uint32(/* id 4, wireType 0 =*/32).int32(message.status);
                if (message.isReasoning != null && Object.hasOwnProperty.call(message, "isReasoning"))
                    writer.uint32(/* id 5, wireType 0 =*/40).bool(message.isReasoning);
                if (message.isEnhancedSearch != null && Object.hasOwnProperty.call(message, "isEnhancedSearch"))
                    writer.uint32(/* id 6, wireType 0 =*/48).bool(message.isEnhancedSearch);
                if (message.sections != null && message.sections.length)
                    for (let i = 0; i < message.sections.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.encode(message.sections[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified BotPlanningStepMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata} message BotPlanningStepMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            BotPlanningStepMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a BotPlanningStepMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata} BotPlanningStepMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            BotPlanningStepMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.statusTitle = reader.string();
                            break;
                        }
                    case 2: {
                            message.statusBody = reader.string();
                            break;
                        }
                    case 3: {
                            if (!(message.sourcesMetadata && message.sourcesMetadata.length))
                                message.sourcesMetadata = [];
                            message.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.decode(reader, reader.uint32()));
                            break;
                        }
                    case 4: {
                            message.status = reader.int32();
                            break;
                        }
                    case 5: {
                            message.isReasoning = reader.bool();
                            break;
                        }
                    case 6: {
                            message.isEnhancedSearch = reader.bool();
                            break;
                        }
                    case 7: {
                            if (!(message.sections && message.sections.length))
                                message.sections = [];
                            message.sections.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a BotPlanningStepMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata} BotPlanningStepMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            BotPlanningStepMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a BotPlanningStepMetadata message.
             * @function verify
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            BotPlanningStepMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.statusTitle != null && message.hasOwnProperty("statusTitle")) {
                    properties._statusTitle = 1;
                    if (!$util.isString(message.statusTitle))
                        return "statusTitle: string expected";
                }
                if (message.statusBody != null && message.hasOwnProperty("statusBody")) {
                    properties._statusBody = 1;
                    if (!$util.isString(message.statusBody))
                        return "statusBody: string expected";
                }
                if (message.sourcesMetadata != null && message.hasOwnProperty("sourcesMetadata")) {
                    if (!Array.isArray(message.sourcesMetadata))
                        return "sourcesMetadata: array expected";
                    for (let i = 0; i < message.sourcesMetadata.length; ++i) {
                        let error = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.verify(message.sourcesMetadata[i]);
                        if (error)
                            return "sourcesMetadata." + error;
                    }
                }
                if (message.status != null && message.hasOwnProperty("status")) {
                    properties._status = 1;
                    switch (message.status) {
                    default:
                        return "status: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
                }
                if (message.isReasoning != null && message.hasOwnProperty("isReasoning")) {
                    properties._isReasoning = 1;
                    if (typeof message.isReasoning !== "boolean")
                        return "isReasoning: boolean expected";
                }
                if (message.isEnhancedSearch != null && message.hasOwnProperty("isEnhancedSearch")) {
                    properties._isEnhancedSearch = 1;
                    if (typeof message.isEnhancedSearch !== "boolean")
                        return "isEnhancedSearch: boolean expected";
                }
                if (message.sections != null && message.hasOwnProperty("sections")) {
                    if (!Array.isArray(message.sections))
                        return "sections: array expected";
                    for (let i = 0; i < message.sections.length; ++i) {
                        let error = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.verify(message.sections[i]);
                        if (error)
                            return "sections." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a BotPlanningStepMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata} BotPlanningStepMetadata
             */
            BotPlanningStepMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata)
                    return object;
                let message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                if (object.statusTitle != null)
                    message.statusTitle = String(object.statusTitle);
                if (object.statusBody != null)
                    message.statusBody = String(object.statusBody);
                if (object.sourcesMetadata) {
                    if (!Array.isArray(object.sourcesMetadata))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: array expected");
                    message.sourcesMetadata = [];
                    for (let i = 0; i < object.sourcesMetadata.length; ++i) {
                        if (typeof object.sourcesMetadata[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sourcesMetadata: object expected");
                        message.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.fromObject(object.sourcesMetadata[i]);
                    }
                }
                switch (object.status) {
                default:
                    if (typeof object.status === "number") {
                        message.status = object.status;
                        break;
                    }
                    break;
                case "UNKNOWN":
                case 0:
                    message.status = 0;
                    break;
                case "PLANNED":
                case 1:
                    message.status = 1;
                    break;
                case "EXECUTING":
                case 2:
                    message.status = 2;
                    break;
                case "FINISHED":
                case 3:
                    message.status = 3;
                    break;
                }
                if (object.isReasoning != null)
                    message.isReasoning = Boolean(object.isReasoning);
                if (object.isEnhancedSearch != null)
                    message.isEnhancedSearch = Boolean(object.isEnhancedSearch);
                if (object.sections) {
                    if (!Array.isArray(object.sections))
                        throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: array expected");
                    message.sections = [];
                    for (let i = 0; i < object.sections.length; ++i) {
                        if (typeof object.sections[i] !== "object")
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.sections: object expected");
                        message.sections[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.fromObject(object.sections[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a BotPlanningStepMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata} message BotPlanningStepMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            BotPlanningStepMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays || options.defaults) {
                    object.sourcesMetadata = [];
                    object.sections = [];
                }
                if (message.statusTitle != null && message.hasOwnProperty("statusTitle")) {
                    object.statusTitle = message.statusTitle;
                    if (options.oneofs)
                        object._statusTitle = "statusTitle";
                }
                if (message.statusBody != null && message.hasOwnProperty("statusBody")) {
                    object.statusBody = message.statusBody;
                    if (options.oneofs)
                        object._statusBody = "statusBody";
                }
                if (message.sourcesMetadata && message.sourcesMetadata.length) {
                    object.sourcesMetadata = [];
                    for (let j = 0; j < message.sourcesMetadata.length; ++j)
                        object.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.toObject(message.sourcesMetadata[j], options);
                }
                if (message.status != null && message.hasOwnProperty("status")) {
                    object.status = options.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[message.status] === undefined ? message.status : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus[message.status] : message.status;
                    if (options.oneofs)
                        object._status = "status";
                }
                if (message.isReasoning != null && message.hasOwnProperty("isReasoning")) {
                    object.isReasoning = message.isReasoning;
                    if (options.oneofs)
                        object._isReasoning = "isReasoning";
                }
                if (message.isEnhancedSearch != null && message.hasOwnProperty("isEnhancedSearch")) {
                    object.isEnhancedSearch = message.isEnhancedSearch;
                    if (options.oneofs)
                        object._isEnhancedSearch = "isEnhancedSearch";
                }
                if (message.sections && message.sections.length) {
                    object.sections = [];
                    for (let j = 0; j < message.sections.length; ++j)
                        object.sections[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.toObject(message.sections[j], options);
                }
                return object;
            };

            /**
             * Converts this BotPlanningStepMetadata to JSON.
             * @function toJSON
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            BotPlanningStepMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for BotPlanningStepMetadata
             * @function getTypeUrl
             * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            BotPlanningStepMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata";
            };

            BotPlanningStepMetadata.BotPlanningSearchSourceMetadata = (function() {

                /**
                 * Properties of a BotPlanningSearchSourceMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @interface IBotPlanningSearchSourceMetadata
                 * @property {string|null} [title] BotPlanningSearchSourceMetadata title
                 * @property {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider|null} [provider] BotPlanningSearchSourceMetadata provider
                 * @property {string|null} [sourceUrl] BotPlanningSearchSourceMetadata sourceUrl
                 * @property {string|null} [favIconUrl] BotPlanningSearchSourceMetadata favIconUrl
                 */

                /**
                 * Constructs a new BotPlanningSearchSourceMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @classdesc Represents a BotPlanningSearchSourceMetadata.
                 * @implements IBotPlanningSearchSourceMetadata
                 * @constructor
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata=} [properties] Properties to set
                 */
                function BotPlanningSearchSourceMetadata(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * BotPlanningSearchSourceMetadata title.
                 * @member {string|null|undefined} title
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @instance
                 */
                BotPlanningSearchSourceMetadata.prototype.title = null;

                /**
                 * BotPlanningSearchSourceMetadata provider.
                 * @member {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider|null|undefined} provider
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @instance
                 */
                BotPlanningSearchSourceMetadata.prototype.provider = null;

                /**
                 * BotPlanningSearchSourceMetadata sourceUrl.
                 * @member {string|null|undefined} sourceUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @instance
                 */
                BotPlanningSearchSourceMetadata.prototype.sourceUrl = null;

                /**
                 * BotPlanningSearchSourceMetadata favIconUrl.
                 * @member {string|null|undefined} favIconUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @instance
                 */
                BotPlanningSearchSourceMetadata.prototype.favIconUrl = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_title", {
                    get: $util.oneOfGetter($oneOfFields = ["title"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourceMetadata.prototype, "_favIconUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["favIconUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new BotPlanningSearchSourceMetadata instance using the specified properties.
                 * @function create
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata=} [properties] Properties to set
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata} BotPlanningSearchSourceMetadata instance
                 */
                BotPlanningSearchSourceMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourceMetadata(properties);
                };

                /**
                 * Encodes the specified BotPlanningSearchSourceMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata} message BotPlanningSearchSourceMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningSearchSourceMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
                    if (message.provider != null && Object.hasOwnProperty.call(message, "provider"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.provider);
                    if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.sourceUrl);
                    if (message.favIconUrl != null && Object.hasOwnProperty.call(message, "favIconUrl"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.favIconUrl);
                    return writer;
                };

                /**
                 * Encodes the specified BotPlanningSearchSourceMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata} message BotPlanningSearchSourceMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningSearchSourceMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a BotPlanningSearchSourceMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata} BotPlanningSearchSourceMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningSearchSourceMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.title = reader.string();
                                break;
                            }
                        case 2: {
                                message.provider = reader.int32();
                                break;
                            }
                        case 3: {
                                message.sourceUrl = reader.string();
                                break;
                            }
                        case 4: {
                                message.favIconUrl = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a BotPlanningSearchSourceMetadata message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata} BotPlanningSearchSourceMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningSearchSourceMetadata.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a BotPlanningSearchSourceMetadata message.
                 * @function verify
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BotPlanningSearchSourceMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.title != null && message.hasOwnProperty("title")) {
                        properties._title = 1;
                        if (!$util.isString(message.title))
                            return "title: string expected";
                    }
                    if (message.provider != null && message.hasOwnProperty("provider")) {
                        properties._provider = 1;
                        switch (message.provider) {
                        default:
                            return "provider: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    }
                    if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                        properties._sourceUrl = 1;
                        if (!$util.isString(message.sourceUrl))
                            return "sourceUrl: string expected";
                    }
                    if (message.favIconUrl != null && message.hasOwnProperty("favIconUrl")) {
                        properties._favIconUrl = 1;
                        if (!$util.isString(message.favIconUrl))
                            return "favIconUrl: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a BotPlanningSearchSourceMetadata message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata} BotPlanningSearchSourceMetadata
                 */
                BotPlanningSearchSourceMetadata.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata)
                        return object;
                    let message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    if (object.title != null)
                        message.title = String(object.title);
                    switch (object.provider) {
                    default:
                        if (typeof object.provider === "number") {
                            message.provider = object.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN_PROVIDER":
                    case 0:
                        message.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        message.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        message.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        message.provider = 3;
                        break;
                    }
                    if (object.sourceUrl != null)
                        message.sourceUrl = String(object.sourceUrl);
                    if (object.favIconUrl != null)
                        message.favIconUrl = String(object.favIconUrl);
                    return message;
                };

                /**
                 * Creates a plain object from a BotPlanningSearchSourceMetadata message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata} message BotPlanningSearchSourceMetadata
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                BotPlanningSearchSourceMetadata.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.title != null && message.hasOwnProperty("title")) {
                        object.title = message.title;
                        if (options.oneofs)
                            object._title = "title";
                    }
                    if (message.provider != null && message.hasOwnProperty("provider")) {
                        object.provider = options.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[message.provider] === undefined ? message.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider[message.provider] : message.provider;
                        if (options.oneofs)
                            object._provider = "provider";
                    }
                    if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                        object.sourceUrl = message.sourceUrl;
                        if (options.oneofs)
                            object._sourceUrl = "sourceUrl";
                    }
                    if (message.favIconUrl != null && message.hasOwnProperty("favIconUrl")) {
                        object.favIconUrl = message.favIconUrl;
                        if (options.oneofs)
                            object._favIconUrl = "favIconUrl";
                    }
                    return object;
                };

                /**
                 * Converts this BotPlanningSearchSourceMetadata to JSON.
                 * @function toJSON
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                BotPlanningSearchSourceMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for BotPlanningSearchSourceMetadata
                 * @function getTypeUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                BotPlanningSearchSourceMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata";
                };

                return BotPlanningSearchSourceMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata = (function() {

                /**
                 * Properties of a BotPlanningSearchSourcesMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @interface IBotPlanningSearchSourcesMetadata
                 * @property {string|null} [sourceTitle] BotPlanningSearchSourcesMetadata sourceTitle
                 * @property {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider|null} [provider] BotPlanningSearchSourcesMetadata provider
                 * @property {string|null} [sourceUrl] BotPlanningSearchSourcesMetadata sourceUrl
                 */

                /**
                 * Constructs a new BotPlanningSearchSourcesMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @classdesc Represents a BotPlanningSearchSourcesMetadata.
                 * @implements IBotPlanningSearchSourcesMetadata
                 * @constructor
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata=} [properties] Properties to set
                 */
                function BotPlanningSearchSourcesMetadata(properties) {
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * BotPlanningSearchSourcesMetadata sourceTitle.
                 * @member {string|null|undefined} sourceTitle
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @instance
                 */
                BotPlanningSearchSourcesMetadata.prototype.sourceTitle = null;

                /**
                 * BotPlanningSearchSourcesMetadata provider.
                 * @member {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider|null|undefined} provider
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @instance
                 */
                BotPlanningSearchSourcesMetadata.prototype.provider = null;

                /**
                 * BotPlanningSearchSourcesMetadata sourceUrl.
                 * @member {string|null|undefined} sourceUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @instance
                 */
                BotPlanningSearchSourcesMetadata.prototype.sourceUrl = null;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_provider", {
                    get: $util.oneOfGetter($oneOfFields = ["provider"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningSearchSourcesMetadata.prototype, "_sourceUrl", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceUrl"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new BotPlanningSearchSourcesMetadata instance using the specified properties.
                 * @function create
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata=} [properties] Properties to set
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata} BotPlanningSearchSourcesMetadata instance
                 */
                BotPlanningSearchSourcesMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourcesMetadata(properties);
                };

                /**
                 * Encodes the specified BotPlanningSearchSourcesMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata} message BotPlanningSearchSourcesMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningSearchSourcesMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.sourceTitle != null && Object.hasOwnProperty.call(message, "sourceTitle"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.sourceTitle);
                    if (message.provider != null && Object.hasOwnProperty.call(message, "provider"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.provider);
                    if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.sourceUrl);
                    return writer;
                };

                /**
                 * Encodes the specified BotPlanningSearchSourcesMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata} message BotPlanningSearchSourcesMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningSearchSourcesMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a BotPlanningSearchSourcesMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata} BotPlanningSearchSourcesMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningSearchSourcesMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.sourceTitle = reader.string();
                                break;
                            }
                        case 2: {
                                message.provider = reader.int32();
                                break;
                            }
                        case 3: {
                                message.sourceUrl = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a BotPlanningSearchSourcesMetadata message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata} BotPlanningSearchSourcesMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningSearchSourcesMetadata.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a BotPlanningSearchSourcesMetadata message.
                 * @function verify
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BotPlanningSearchSourcesMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.sourceTitle != null && message.hasOwnProperty("sourceTitle")) {
                        properties._sourceTitle = 1;
                        if (!$util.isString(message.sourceTitle))
                            return "sourceTitle: string expected";
                    }
                    if (message.provider != null && message.hasOwnProperty("provider")) {
                        properties._provider = 1;
                        switch (message.provider) {
                        default:
                            return "provider: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    }
                    if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                        properties._sourceUrl = 1;
                        if (!$util.isString(message.sourceUrl))
                            return "sourceUrl: string expected";
                    }
                    return null;
                };

                /**
                 * Creates a BotPlanningSearchSourcesMetadata message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata} BotPlanningSearchSourcesMetadata
                 */
                BotPlanningSearchSourcesMetadata.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata)
                        return object;
                    let message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    if (object.sourceTitle != null)
                        message.sourceTitle = String(object.sourceTitle);
                    switch (object.provider) {
                    default:
                        if (typeof object.provider === "number") {
                            message.provider = object.provider;
                            break;
                        }
                        break;
                    case "UNKNOWN":
                    case 0:
                        message.provider = 0;
                        break;
                    case "OTHER":
                    case 1:
                        message.provider = 1;
                        break;
                    case "GOOGLE":
                    case 2:
                        message.provider = 2;
                        break;
                    case "BING":
                    case 3:
                        message.provider = 3;
                        break;
                    }
                    if (object.sourceUrl != null)
                        message.sourceUrl = String(object.sourceUrl);
                    return message;
                };

                /**
                 * Creates a plain object from a BotPlanningSearchSourcesMetadata message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata} message BotPlanningSearchSourcesMetadata
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                BotPlanningSearchSourcesMetadata.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (message.sourceTitle != null && message.hasOwnProperty("sourceTitle")) {
                        object.sourceTitle = message.sourceTitle;
                        if (options.oneofs)
                            object._sourceTitle = "sourceTitle";
                    }
                    if (message.provider != null && message.hasOwnProperty("provider")) {
                        object.provider = options.enums === String ? $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[message.provider] === undefined ? message.provider : $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider[message.provider] : message.provider;
                        if (options.oneofs)
                            object._provider = "provider";
                    }
                    if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl")) {
                        object.sourceUrl = message.sourceUrl;
                        if (options.oneofs)
                            object._sourceUrl = "sourceUrl";
                    }
                    return object;
                };

                /**
                 * Converts this BotPlanningSearchSourcesMetadata to JSON.
                 * @function toJSON
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                BotPlanningSearchSourcesMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for BotPlanningSearchSourcesMetadata
                 * @function getTypeUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                BotPlanningSearchSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata";
                };

                /**
                 * BotPlanningSearchSourceProvider enum.
                 * @name proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider
                 * @enum {number}
                 * @property {number} UNKNOWN=0 UNKNOWN value
                 * @property {number} OTHER=1 OTHER value
                 * @property {number} GOOGLE=2 GOOGLE value
                 * @property {number} BING=3 BING value
                 */
                BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "OTHER"] = 1;
                    values[valuesById[2] = "GOOGLE"] = 2;
                    values[valuesById[3] = "BING"] = 3;
                    return values;
                })();

                return BotPlanningSearchSourcesMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningStepSectionMetadata = (function() {

                /**
                 * Properties of a BotPlanningStepSectionMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @interface IBotPlanningStepSectionMetadata
                 * @property {string|null} [sectionTitle] BotPlanningStepSectionMetadata sectionTitle
                 * @property {string|null} [sectionBody] BotPlanningStepSectionMetadata sectionBody
                 * @property {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata>|null} [sourcesMetadata] BotPlanningStepSectionMetadata sourcesMetadata
                 */

                /**
                 * Constructs a new BotPlanningStepSectionMetadata.
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata
                 * @classdesc Represents a BotPlanningStepSectionMetadata.
                 * @implements IBotPlanningStepSectionMetadata
                 * @constructor
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata=} [properties] Properties to set
                 */
                function BotPlanningStepSectionMetadata(properties) {
                    this.sourcesMetadata = [];
                    if (properties)
                        for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * BotPlanningStepSectionMetadata sectionTitle.
                 * @member {string|null|undefined} sectionTitle
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @instance
                 */
                BotPlanningStepSectionMetadata.prototype.sectionTitle = null;

                /**
                 * BotPlanningStepSectionMetadata sectionBody.
                 * @member {string|null|undefined} sectionBody
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @instance
                 */
                BotPlanningStepSectionMetadata.prototype.sectionBody = null;

                /**
                 * BotPlanningStepSectionMetadata sourcesMetadata.
                 * @member {Array.<proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata>} sourcesMetadata
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @instance
                 */
                BotPlanningStepSectionMetadata.prototype.sourcesMetadata = $util.emptyArray;

                // OneOf field names bound to virtual getters and setters
                let $oneOfFields;

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionTitle", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionTitle"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                // Virtual OneOf for proto3 optional field
                Object.defineProperty(BotPlanningStepSectionMetadata.prototype, "_sectionBody", {
                    get: $util.oneOfGetter($oneOfFields = ["sectionBody"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new BotPlanningStepSectionMetadata instance using the specified properties.
                 * @function create
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata=} [properties] Properties to set
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata} BotPlanningStepSectionMetadata instance
                 */
                BotPlanningStepSectionMetadata.create = function create(properties) {
                    return new BotPlanningStepSectionMetadata(properties);
                };

                /**
                 * Encodes the specified BotPlanningStepSectionMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata} message BotPlanningStepSectionMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningStepSectionMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.sectionTitle != null && Object.hasOwnProperty.call(message, "sectionTitle"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.sectionTitle);
                    if (message.sectionBody != null && Object.hasOwnProperty.call(message, "sectionBody"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.sectionBody);
                    if (message.sourcesMetadata != null && message.sourcesMetadata.length)
                        for (let i = 0; i < message.sourcesMetadata.length; ++i)
                            $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.encode(message.sourcesMetadata[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified BotPlanningStepSectionMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata} message BotPlanningStepSectionMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BotPlanningStepSectionMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a BotPlanningStepSectionMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata} BotPlanningStepSectionMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningStepSectionMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    while (reader.pos < end) {
                        let tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.sectionTitle = reader.string();
                                break;
                            }
                        case 2: {
                                message.sectionBody = reader.string();
                                break;
                            }
                        case 3: {
                                if (!(message.sourcesMetadata && message.sourcesMetadata.length))
                                    message.sourcesMetadata = [];
                                message.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.decode(reader, reader.uint32()));
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a BotPlanningStepSectionMetadata message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata} BotPlanningStepSectionMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BotPlanningStepSectionMetadata.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a BotPlanningStepSectionMetadata message.
                 * @function verify
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BotPlanningStepSectionMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    let properties = {};
                    if (message.sectionTitle != null && message.hasOwnProperty("sectionTitle")) {
                        properties._sectionTitle = 1;
                        if (!$util.isString(message.sectionTitle))
                            return "sectionTitle: string expected";
                    }
                    if (message.sectionBody != null && message.hasOwnProperty("sectionBody")) {
                        properties._sectionBody = 1;
                        if (!$util.isString(message.sectionBody))
                            return "sectionBody: string expected";
                    }
                    if (message.sourcesMetadata != null && message.hasOwnProperty("sourcesMetadata")) {
                        if (!Array.isArray(message.sourcesMetadata))
                            return "sourcesMetadata: array expected";
                        for (let i = 0; i < message.sourcesMetadata.length; ++i) {
                            let error = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.verify(message.sourcesMetadata[i]);
                            if (error)
                                return "sourcesMetadata." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a BotPlanningStepSectionMetadata message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata} BotPlanningStepSectionMetadata
                 */
                BotPlanningStepSectionMetadata.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata)
                        return object;
                    let message = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    if (object.sectionTitle != null)
                        message.sectionTitle = String(object.sectionTitle);
                    if (object.sectionBody != null)
                        message.sectionBody = String(object.sectionBody);
                    if (object.sourcesMetadata) {
                        if (!Array.isArray(object.sourcesMetadata))
                            throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: array expected");
                        message.sourcesMetadata = [];
                        for (let i = 0; i < object.sourcesMetadata.length; ++i) {
                            if (typeof object.sourcesMetadata[i] !== "object")
                                throw TypeError(".proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.sourcesMetadata: object expected");
                            message.sourcesMetadata[i] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.fromObject(object.sourcesMetadata[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a BotPlanningStepSectionMetadata message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata} message BotPlanningStepSectionMetadata
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                BotPlanningStepSectionMetadata.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    let object = {};
                    if (options.arrays || options.defaults)
                        object.sourcesMetadata = [];
                    if (message.sectionTitle != null && message.hasOwnProperty("sectionTitle")) {
                        object.sectionTitle = message.sectionTitle;
                        if (options.oneofs)
                            object._sectionTitle = "sectionTitle";
                    }
                    if (message.sectionBody != null && message.hasOwnProperty("sectionBody")) {
                        object.sectionBody = message.sectionBody;
                        if (options.oneofs)
                            object._sectionBody = "sectionBody";
                    }
                    if (message.sourcesMetadata && message.sourcesMetadata.length) {
                        object.sourcesMetadata = [];
                        for (let j = 0; j < message.sourcesMetadata.length; ++j)
                            object.sourcesMetadata[j] = $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.toObject(message.sourcesMetadata[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this BotPlanningStepSectionMetadata to JSON.
                 * @function toJSON
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                BotPlanningStepSectionMetadata.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Gets the default type url for BotPlanningStepSectionMetadata
                 * @function getTypeUrl
                 * @memberof proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                BotPlanningStepSectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata";
                };

                return BotPlanningStepSectionMetadata;
            })();

            /**
             * BotSearchSourceProvider enum.
             * @name proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider
             * @enum {number}
             * @property {number} UNKNOWN_PROVIDER=0 UNKNOWN_PROVIDER value
             * @property {number} OTHER=1 OTHER value
             * @property {number} GOOGLE=2 GOOGLE value
             * @property {number} BING=3 BING value
             */
            BotPlanningStepMetadata.BotSearchSourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_PROVIDER"] = 0;
                values[valuesById[1] = "OTHER"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "BING"] = 3;
                return values;
            })();

            /**
             * PlanningStepStatus enum.
             * @name proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus
             * @enum {number}
             * @property {number} UNKNOWN=0 UNKNOWN value
             * @property {number} PLANNED=1 PLANNED value
             * @property {number} EXECUTING=2 EXECUTING value
             * @property {number} FINISHED=3 FINISHED value
             */
            BotPlanningStepMetadata.PlanningStepStatus = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "PLANNED"] = 1;
                values[valuesById[2] = "EXECUTING"] = 2;
                values[valuesById[3] = "FINISHED"] = 3;
                return values;
            })();

            return BotPlanningStepMetadata;
        })();

        return BotProgressIndicatorMetadata;
    })();

    proto.BotPromotionMessageMetadata = (function() {

        /**
         * Properties of a BotPromotionMessageMetadata.
         * @memberof proto
         * @interface IBotPromotionMessageMetadata
         * @property {proto.BotPromotionMessageMetadata.BotPromotionType|null} [promotionType] BotPromotionMessageMetadata promotionType
         * @property {string|null} [buttonTitle] BotPromotionMessageMetadata buttonTitle
         */

        /**
         * Constructs a new BotPromotionMessageMetadata.
         * @memberof proto
         * @classdesc Represents a BotPromotionMessageMetadata.
         * @implements IBotPromotionMessageMetadata
         * @constructor
         * @param {proto.IBotPromotionMessageMetadata=} [properties] Properties to set
         */
        function BotPromotionMessageMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotPromotionMessageMetadata promotionType.
         * @member {proto.BotPromotionMessageMetadata.BotPromotionType|null|undefined} promotionType
         * @memberof proto.BotPromotionMessageMetadata
         * @instance
         */
        BotPromotionMessageMetadata.prototype.promotionType = null;

        /**
         * BotPromotionMessageMetadata buttonTitle.
         * @member {string|null|undefined} buttonTitle
         * @memberof proto.BotPromotionMessageMetadata
         * @instance
         */
        BotPromotionMessageMetadata.prototype.buttonTitle = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_promotionType", {
            get: $util.oneOfGetter($oneOfFields = ["promotionType"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromotionMessageMetadata.prototype, "_buttonTitle", {
            get: $util.oneOfGetter($oneOfFields = ["buttonTitle"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotPromotionMessageMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {proto.IBotPromotionMessageMetadata=} [properties] Properties to set
         * @returns {proto.BotPromotionMessageMetadata} BotPromotionMessageMetadata instance
         */
        BotPromotionMessageMetadata.create = function create(properties) {
            return new BotPromotionMessageMetadata(properties);
        };

        /**
         * Encodes the specified BotPromotionMessageMetadata message. Does not implicitly {@link proto.BotPromotionMessageMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {proto.IBotPromotionMessageMetadata} message BotPromotionMessageMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromotionMessageMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.promotionType != null && Object.hasOwnProperty.call(message, "promotionType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.promotionType);
            if (message.buttonTitle != null && Object.hasOwnProperty.call(message, "buttonTitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.buttonTitle);
            return writer;
        };

        /**
         * Encodes the specified BotPromotionMessageMetadata message, length delimited. Does not implicitly {@link proto.BotPromotionMessageMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {proto.IBotPromotionMessageMetadata} message BotPromotionMessageMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromotionMessageMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotPromotionMessageMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotPromotionMessageMetadata} BotPromotionMessageMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromotionMessageMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotPromotionMessageMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.promotionType = reader.int32();
                        break;
                    }
                case 2: {
                        message.buttonTitle = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotPromotionMessageMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotPromotionMessageMetadata} BotPromotionMessageMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromotionMessageMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotPromotionMessageMetadata message.
         * @function verify
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotPromotionMessageMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.promotionType != null && message.hasOwnProperty("promotionType")) {
                properties._promotionType = 1;
                switch (message.promotionType) {
                default:
                    return "promotionType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            }
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle")) {
                properties._buttonTitle = 1;
                if (!$util.isString(message.buttonTitle))
                    return "buttonTitle: string expected";
            }
            return null;
        };

        /**
         * Creates a BotPromotionMessageMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotPromotionMessageMetadata} BotPromotionMessageMetadata
         */
        BotPromotionMessageMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotPromotionMessageMetadata)
                return object;
            let message = new $root.proto.BotPromotionMessageMetadata();
            switch (object.promotionType) {
            default:
                if (typeof object.promotionType === "number") {
                    message.promotionType = object.promotionType;
                    break;
                }
                break;
            case "UNKNOWN_TYPE":
            case 0:
                message.promotionType = 0;
                break;
            case "C50":
            case 1:
                message.promotionType = 1;
                break;
            }
            if (object.buttonTitle != null)
                message.buttonTitle = String(object.buttonTitle);
            return message;
        };

        /**
         * Creates a plain object from a BotPromotionMessageMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {proto.BotPromotionMessageMetadata} message BotPromotionMessageMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotPromotionMessageMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.promotionType != null && message.hasOwnProperty("promotionType")) {
                object.promotionType = options.enums === String ? $root.proto.BotPromotionMessageMetadata.BotPromotionType[message.promotionType] === undefined ? message.promotionType : $root.proto.BotPromotionMessageMetadata.BotPromotionType[message.promotionType] : message.promotionType;
                if (options.oneofs)
                    object._promotionType = "promotionType";
            }
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle")) {
                object.buttonTitle = message.buttonTitle;
                if (options.oneofs)
                    object._buttonTitle = "buttonTitle";
            }
            return object;
        };

        /**
         * Converts this BotPromotionMessageMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotPromotionMessageMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotPromotionMessageMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotPromotionMessageMetadata
         * @function getTypeUrl
         * @memberof proto.BotPromotionMessageMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotPromotionMessageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromotionMessageMetadata";
        };

        /**
         * BotPromotionType enum.
         * @name proto.BotPromotionMessageMetadata.BotPromotionType
         * @enum {number}
         * @property {number} UNKNOWN_TYPE=0 UNKNOWN_TYPE value
         * @property {number} C50=1 C50 value
         */
        BotPromotionMessageMetadata.BotPromotionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "C50"] = 1;
            return values;
        })();

        return BotPromotionMessageMetadata;
    })();

    proto.BotPromptSuggestion = (function() {

        /**
         * Properties of a BotPromptSuggestion.
         * @memberof proto
         * @interface IBotPromptSuggestion
         * @property {string|null} [prompt] BotPromptSuggestion prompt
         * @property {string|null} [promptId] BotPromptSuggestion promptId
         */

        /**
         * Constructs a new BotPromptSuggestion.
         * @memberof proto
         * @classdesc Represents a BotPromptSuggestion.
         * @implements IBotPromptSuggestion
         * @constructor
         * @param {proto.IBotPromptSuggestion=} [properties] Properties to set
         */
        function BotPromptSuggestion(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotPromptSuggestion prompt.
         * @member {string|null|undefined} prompt
         * @memberof proto.BotPromptSuggestion
         * @instance
         */
        BotPromptSuggestion.prototype.prompt = null;

        /**
         * BotPromptSuggestion promptId.
         * @member {string|null|undefined} promptId
         * @memberof proto.BotPromptSuggestion
         * @instance
         */
        BotPromptSuggestion.prototype.promptId = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_prompt", {
            get: $util.oneOfGetter($oneOfFields = ["prompt"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotPromptSuggestion.prototype, "_promptId", {
            get: $util.oneOfGetter($oneOfFields = ["promptId"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotPromptSuggestion instance using the specified properties.
         * @function create
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {proto.IBotPromptSuggestion=} [properties] Properties to set
         * @returns {proto.BotPromptSuggestion} BotPromptSuggestion instance
         */
        BotPromptSuggestion.create = function create(properties) {
            return new BotPromptSuggestion(properties);
        };

        /**
         * Encodes the specified BotPromptSuggestion message. Does not implicitly {@link proto.BotPromptSuggestion.verify|verify} messages.
         * @function encode
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {proto.IBotPromptSuggestion} message BotPromptSuggestion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromptSuggestion.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.prompt != null && Object.hasOwnProperty.call(message, "prompt"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.prompt);
            if (message.promptId != null && Object.hasOwnProperty.call(message, "promptId"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.promptId);
            return writer;
        };

        /**
         * Encodes the specified BotPromptSuggestion message, length delimited. Does not implicitly {@link proto.BotPromptSuggestion.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {proto.IBotPromptSuggestion} message BotPromptSuggestion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromptSuggestion.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotPromptSuggestion message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotPromptSuggestion} BotPromptSuggestion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromptSuggestion.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotPromptSuggestion();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.prompt = reader.string();
                        break;
                    }
                case 2: {
                        message.promptId = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotPromptSuggestion message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotPromptSuggestion} BotPromptSuggestion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromptSuggestion.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotPromptSuggestion message.
         * @function verify
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotPromptSuggestion.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.prompt != null && message.hasOwnProperty("prompt")) {
                properties._prompt = 1;
                if (!$util.isString(message.prompt))
                    return "prompt: string expected";
            }
            if (message.promptId != null && message.hasOwnProperty("promptId")) {
                properties._promptId = 1;
                if (!$util.isString(message.promptId))
                    return "promptId: string expected";
            }
            return null;
        };

        /**
         * Creates a BotPromptSuggestion message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotPromptSuggestion} BotPromptSuggestion
         */
        BotPromptSuggestion.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotPromptSuggestion)
                return object;
            let message = new $root.proto.BotPromptSuggestion();
            if (object.prompt != null)
                message.prompt = String(object.prompt);
            if (object.promptId != null)
                message.promptId = String(object.promptId);
            return message;
        };

        /**
         * Creates a plain object from a BotPromptSuggestion message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {proto.BotPromptSuggestion} message BotPromptSuggestion
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotPromptSuggestion.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.prompt != null && message.hasOwnProperty("prompt")) {
                object.prompt = message.prompt;
                if (options.oneofs)
                    object._prompt = "prompt";
            }
            if (message.promptId != null && message.hasOwnProperty("promptId")) {
                object.promptId = message.promptId;
                if (options.oneofs)
                    object._promptId = "promptId";
            }
            return object;
        };

        /**
         * Converts this BotPromptSuggestion to JSON.
         * @function toJSON
         * @memberof proto.BotPromptSuggestion
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotPromptSuggestion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotPromptSuggestion
         * @function getTypeUrl
         * @memberof proto.BotPromptSuggestion
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotPromptSuggestion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestion";
        };

        return BotPromptSuggestion;
    })();

    proto.BotPromptSuggestions = (function() {

        /**
         * Properties of a BotPromptSuggestions.
         * @memberof proto
         * @interface IBotPromptSuggestions
         * @property {Array.<proto.IBotPromptSuggestion>|null} [suggestions] BotPromptSuggestions suggestions
         */

        /**
         * Constructs a new BotPromptSuggestions.
         * @memberof proto
         * @classdesc Represents a BotPromptSuggestions.
         * @implements IBotPromptSuggestions
         * @constructor
         * @param {proto.IBotPromptSuggestions=} [properties] Properties to set
         */
        function BotPromptSuggestions(properties) {
            this.suggestions = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotPromptSuggestions suggestions.
         * @member {Array.<proto.IBotPromptSuggestion>} suggestions
         * @memberof proto.BotPromptSuggestions
         * @instance
         */
        BotPromptSuggestions.prototype.suggestions = $util.emptyArray;

        /**
         * Creates a new BotPromptSuggestions instance using the specified properties.
         * @function create
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {proto.IBotPromptSuggestions=} [properties] Properties to set
         * @returns {proto.BotPromptSuggestions} BotPromptSuggestions instance
         */
        BotPromptSuggestions.create = function create(properties) {
            return new BotPromptSuggestions(properties);
        };

        /**
         * Encodes the specified BotPromptSuggestions message. Does not implicitly {@link proto.BotPromptSuggestions.verify|verify} messages.
         * @function encode
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {proto.IBotPromptSuggestions} message BotPromptSuggestions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromptSuggestions.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.suggestions != null && message.suggestions.length)
                for (let i = 0; i < message.suggestions.length; ++i)
                    $root.proto.BotPromptSuggestion.encode(message.suggestions[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotPromptSuggestions message, length delimited. Does not implicitly {@link proto.BotPromptSuggestions.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {proto.IBotPromptSuggestions} message BotPromptSuggestions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotPromptSuggestions.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotPromptSuggestions message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotPromptSuggestions} BotPromptSuggestions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromptSuggestions.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotPromptSuggestions();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.suggestions && message.suggestions.length))
                            message.suggestions = [];
                        message.suggestions.push($root.proto.BotPromptSuggestion.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotPromptSuggestions message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotPromptSuggestions} BotPromptSuggestions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotPromptSuggestions.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotPromptSuggestions message.
         * @function verify
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotPromptSuggestions.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.suggestions != null && message.hasOwnProperty("suggestions")) {
                if (!Array.isArray(message.suggestions))
                    return "suggestions: array expected";
                for (let i = 0; i < message.suggestions.length; ++i) {
                    let error = $root.proto.BotPromptSuggestion.verify(message.suggestions[i]);
                    if (error)
                        return "suggestions." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotPromptSuggestions message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotPromptSuggestions} BotPromptSuggestions
         */
        BotPromptSuggestions.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotPromptSuggestions)
                return object;
            let message = new $root.proto.BotPromptSuggestions();
            if (object.suggestions) {
                if (!Array.isArray(object.suggestions))
                    throw TypeError(".proto.BotPromptSuggestions.suggestions: array expected");
                message.suggestions = [];
                for (let i = 0; i < object.suggestions.length; ++i) {
                    if (typeof object.suggestions[i] !== "object")
                        throw TypeError(".proto.BotPromptSuggestions.suggestions: object expected");
                    message.suggestions[i] = $root.proto.BotPromptSuggestion.fromObject(object.suggestions[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotPromptSuggestions message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {proto.BotPromptSuggestions} message BotPromptSuggestions
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotPromptSuggestions.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.suggestions = [];
            if (message.suggestions && message.suggestions.length) {
                object.suggestions = [];
                for (let j = 0; j < message.suggestions.length; ++j)
                    object.suggestions[j] = $root.proto.BotPromptSuggestion.toObject(message.suggestions[j], options);
            }
            return object;
        };

        /**
         * Converts this BotPromptSuggestions to JSON.
         * @function toJSON
         * @memberof proto.BotPromptSuggestions
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotPromptSuggestions.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotPromptSuggestions
         * @function getTypeUrl
         * @memberof proto.BotPromptSuggestions
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotPromptSuggestions.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestions";
        };

        return BotPromptSuggestions;
    })();

    proto.BotQuotaMetadata = (function() {

        /**
         * Properties of a BotQuotaMetadata.
         * @memberof proto
         * @interface IBotQuotaMetadata
         * @property {Array.<proto.BotQuotaMetadata.IBotFeatureQuotaMetadata>|null} [botFeatureQuotaMetadata] BotQuotaMetadata botFeatureQuotaMetadata
         */

        /**
         * Constructs a new BotQuotaMetadata.
         * @memberof proto
         * @classdesc Represents a BotQuotaMetadata.
         * @implements IBotQuotaMetadata
         * @constructor
         * @param {proto.IBotQuotaMetadata=} [properties] Properties to set
         */
        function BotQuotaMetadata(properties) {
            this.botFeatureQuotaMetadata = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotQuotaMetadata botFeatureQuotaMetadata.
         * @member {Array.<proto.BotQuotaMetadata.IBotFeatureQuotaMetadata>} botFeatureQuotaMetadata
         * @memberof proto.BotQuotaMetadata
         * @instance
         */
        BotQuotaMetadata.prototype.botFeatureQuotaMetadata = $util.emptyArray;

        /**
         * Creates a new BotQuotaMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {proto.IBotQuotaMetadata=} [properties] Properties to set
         * @returns {proto.BotQuotaMetadata} BotQuotaMetadata instance
         */
        BotQuotaMetadata.create = function create(properties) {
            return new BotQuotaMetadata(properties);
        };

        /**
         * Encodes the specified BotQuotaMetadata message. Does not implicitly {@link proto.BotQuotaMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {proto.IBotQuotaMetadata} message BotQuotaMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotQuotaMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.botFeatureQuotaMetadata != null && message.botFeatureQuotaMetadata.length)
                for (let i = 0; i < message.botFeatureQuotaMetadata.length; ++i)
                    $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.encode(message.botFeatureQuotaMetadata[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotQuotaMetadata message, length delimited. Does not implicitly {@link proto.BotQuotaMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {proto.IBotQuotaMetadata} message BotQuotaMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotQuotaMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotQuotaMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotQuotaMetadata} BotQuotaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotQuotaMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotQuotaMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.botFeatureQuotaMetadata && message.botFeatureQuotaMetadata.length))
                            message.botFeatureQuotaMetadata = [];
                        message.botFeatureQuotaMetadata.push($root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotQuotaMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotQuotaMetadata} BotQuotaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotQuotaMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotQuotaMetadata message.
         * @function verify
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotQuotaMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.botFeatureQuotaMetadata != null && message.hasOwnProperty("botFeatureQuotaMetadata")) {
                if (!Array.isArray(message.botFeatureQuotaMetadata))
                    return "botFeatureQuotaMetadata: array expected";
                for (let i = 0; i < message.botFeatureQuotaMetadata.length; ++i) {
                    let error = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.verify(message.botFeatureQuotaMetadata[i]);
                    if (error)
                        return "botFeatureQuotaMetadata." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotQuotaMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotQuotaMetadata} BotQuotaMetadata
         */
        BotQuotaMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotQuotaMetadata)
                return object;
            let message = new $root.proto.BotQuotaMetadata();
            if (object.botFeatureQuotaMetadata) {
                if (!Array.isArray(object.botFeatureQuotaMetadata))
                    throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: array expected");
                message.botFeatureQuotaMetadata = [];
                for (let i = 0; i < object.botFeatureQuotaMetadata.length; ++i) {
                    if (typeof object.botFeatureQuotaMetadata[i] !== "object")
                        throw TypeError(".proto.BotQuotaMetadata.botFeatureQuotaMetadata: object expected");
                    message.botFeatureQuotaMetadata[i] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.fromObject(object.botFeatureQuotaMetadata[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotQuotaMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {proto.BotQuotaMetadata} message BotQuotaMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotQuotaMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.botFeatureQuotaMetadata = [];
            if (message.botFeatureQuotaMetadata && message.botFeatureQuotaMetadata.length) {
                object.botFeatureQuotaMetadata = [];
                for (let j = 0; j < message.botFeatureQuotaMetadata.length; ++j)
                    object.botFeatureQuotaMetadata[j] = $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.toObject(message.botFeatureQuotaMetadata[j], options);
            }
            return object;
        };

        /**
         * Converts this BotQuotaMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotQuotaMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotQuotaMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotQuotaMetadata
         * @function getTypeUrl
         * @memberof proto.BotQuotaMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotQuotaMetadata";
        };

        BotQuotaMetadata.BotFeatureQuotaMetadata = (function() {

            /**
             * Properties of a BotFeatureQuotaMetadata.
             * @memberof proto.BotQuotaMetadata
             * @interface IBotFeatureQuotaMetadata
             * @property {proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType|null} [featureType] BotFeatureQuotaMetadata featureType
             * @property {number|null} [remainingQuota] BotFeatureQuotaMetadata remainingQuota
             * @property {number|Long|null} [expirationTimestamp] BotFeatureQuotaMetadata expirationTimestamp
             */

            /**
             * Constructs a new BotFeatureQuotaMetadata.
             * @memberof proto.BotQuotaMetadata
             * @classdesc Represents a BotFeatureQuotaMetadata.
             * @implements IBotFeatureQuotaMetadata
             * @constructor
             * @param {proto.BotQuotaMetadata.IBotFeatureQuotaMetadata=} [properties] Properties to set
             */
            function BotFeatureQuotaMetadata(properties) {
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * BotFeatureQuotaMetadata featureType.
             * @member {proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType|null|undefined} featureType
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @instance
             */
            BotFeatureQuotaMetadata.prototype.featureType = null;

            /**
             * BotFeatureQuotaMetadata remainingQuota.
             * @member {number|null|undefined} remainingQuota
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @instance
             */
            BotFeatureQuotaMetadata.prototype.remainingQuota = null;

            /**
             * BotFeatureQuotaMetadata expirationTimestamp.
             * @member {number|Long|null|undefined} expirationTimestamp
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @instance
             */
            BotFeatureQuotaMetadata.prototype.expirationTimestamp = null;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_featureType", {
                get: $util.oneOfGetter($oneOfFields = ["featureType"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_remainingQuota", {
                get: $util.oneOfGetter($oneOfFields = ["remainingQuota"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(BotFeatureQuotaMetadata.prototype, "_expirationTimestamp", {
                get: $util.oneOfGetter($oneOfFields = ["expirationTimestamp"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new BotFeatureQuotaMetadata instance using the specified properties.
             * @function create
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {proto.BotQuotaMetadata.IBotFeatureQuotaMetadata=} [properties] Properties to set
             * @returns {proto.BotQuotaMetadata.BotFeatureQuotaMetadata} BotFeatureQuotaMetadata instance
             */
            BotFeatureQuotaMetadata.create = function create(properties) {
                return new BotFeatureQuotaMetadata(properties);
            };

            /**
             * Encodes the specified BotFeatureQuotaMetadata message. Does not implicitly {@link proto.BotQuotaMetadata.BotFeatureQuotaMetadata.verify|verify} messages.
             * @function encode
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {proto.BotQuotaMetadata.IBotFeatureQuotaMetadata} message BotFeatureQuotaMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            BotFeatureQuotaMetadata.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.featureType != null && Object.hasOwnProperty.call(message, "featureType"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.featureType);
                if (message.remainingQuota != null && Object.hasOwnProperty.call(message, "remainingQuota"))
                    writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.remainingQuota);
                if (message.expirationTimestamp != null && Object.hasOwnProperty.call(message, "expirationTimestamp"))
                    writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.expirationTimestamp);
                return writer;
            };

            /**
             * Encodes the specified BotFeatureQuotaMetadata message, length delimited. Does not implicitly {@link proto.BotQuotaMetadata.BotFeatureQuotaMetadata.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {proto.BotQuotaMetadata.IBotFeatureQuotaMetadata} message BotFeatureQuotaMetadata message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            BotFeatureQuotaMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a BotFeatureQuotaMetadata message from the specified reader or buffer.
             * @function decode
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.BotQuotaMetadata.BotFeatureQuotaMetadata} BotFeatureQuotaMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            BotFeatureQuotaMetadata.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.featureType = reader.int32();
                            break;
                        }
                    case 2: {
                            message.remainingQuota = reader.uint32();
                            break;
                        }
                    case 3: {
                            message.expirationTimestamp = reader.uint64();
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a BotFeatureQuotaMetadata message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.BotQuotaMetadata.BotFeatureQuotaMetadata} BotFeatureQuotaMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            BotFeatureQuotaMetadata.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a BotFeatureQuotaMetadata message.
             * @function verify
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            BotFeatureQuotaMetadata.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.featureType != null && message.hasOwnProperty("featureType")) {
                    properties._featureType = 1;
                    switch (message.featureType) {
                    default:
                        return "featureType: enum value expected";
                    case 0:
                    case 1:
                        break;
                    }
                }
                if (message.remainingQuota != null && message.hasOwnProperty("remainingQuota")) {
                    properties._remainingQuota = 1;
                    if (!$util.isInteger(message.remainingQuota))
                        return "remainingQuota: integer expected";
                }
                if (message.expirationTimestamp != null && message.hasOwnProperty("expirationTimestamp")) {
                    properties._expirationTimestamp = 1;
                    if (!$util.isInteger(message.expirationTimestamp) && !(message.expirationTimestamp && $util.isInteger(message.expirationTimestamp.low) && $util.isInteger(message.expirationTimestamp.high)))
                        return "expirationTimestamp: integer|Long expected";
                }
                return null;
            };

            /**
             * Creates a BotFeatureQuotaMetadata message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.BotQuotaMetadata.BotFeatureQuotaMetadata} BotFeatureQuotaMetadata
             */
            BotFeatureQuotaMetadata.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata)
                    return object;
                let message = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                switch (object.featureType) {
                default:
                    if (typeof object.featureType === "number") {
                        message.featureType = object.featureType;
                        break;
                    }
                    break;
                case "UNKNOWN_FEATURE":
                case 0:
                    message.featureType = 0;
                    break;
                case "REASONING_FEATURE":
                case 1:
                    message.featureType = 1;
                    break;
                }
                if (object.remainingQuota != null)
                    message.remainingQuota = object.remainingQuota >>> 0;
                if (object.expirationTimestamp != null)
                    if ($util.Long)
                        (message.expirationTimestamp = $util.Long.fromValue(object.expirationTimestamp)).unsigned = true;
                    else if (typeof object.expirationTimestamp === "string")
                        message.expirationTimestamp = parseInt(object.expirationTimestamp, 10);
                    else if (typeof object.expirationTimestamp === "number")
                        message.expirationTimestamp = object.expirationTimestamp;
                    else if (typeof object.expirationTimestamp === "object")
                        message.expirationTimestamp = new $util.LongBits(object.expirationTimestamp.low >>> 0, object.expirationTimestamp.high >>> 0).toNumber(true);
                return message;
            };

            /**
             * Creates a plain object from a BotFeatureQuotaMetadata message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {proto.BotQuotaMetadata.BotFeatureQuotaMetadata} message BotFeatureQuotaMetadata
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            BotFeatureQuotaMetadata.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (message.featureType != null && message.hasOwnProperty("featureType")) {
                    object.featureType = options.enums === String ? $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[message.featureType] === undefined ? message.featureType : $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType[message.featureType] : message.featureType;
                    if (options.oneofs)
                        object._featureType = "featureType";
                }
                if (message.remainingQuota != null && message.hasOwnProperty("remainingQuota")) {
                    object.remainingQuota = message.remainingQuota;
                    if (options.oneofs)
                        object._remainingQuota = "remainingQuota";
                }
                if (message.expirationTimestamp != null && message.hasOwnProperty("expirationTimestamp")) {
                    if (typeof message.expirationTimestamp === "number")
                        object.expirationTimestamp = options.longs === String ? String(message.expirationTimestamp) : message.expirationTimestamp;
                    else
                        object.expirationTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.expirationTimestamp) : options.longs === Number ? new $util.LongBits(message.expirationTimestamp.low >>> 0, message.expirationTimestamp.high >>> 0).toNumber(true) : message.expirationTimestamp;
                    if (options.oneofs)
                        object._expirationTimestamp = "expirationTimestamp";
                }
                return object;
            };

            /**
             * Converts this BotFeatureQuotaMetadata to JSON.
             * @function toJSON
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            BotFeatureQuotaMetadata.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for BotFeatureQuotaMetadata
             * @function getTypeUrl
             * @memberof proto.BotQuotaMetadata.BotFeatureQuotaMetadata
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            BotFeatureQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotQuotaMetadata.BotFeatureQuotaMetadata";
            };

            /**
             * BotFeatureType enum.
             * @name proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType
             * @enum {number}
             * @property {number} UNKNOWN_FEATURE=0 UNKNOWN_FEATURE value
             * @property {number} REASONING_FEATURE=1 REASONING_FEATURE value
             */
            BotFeatureQuotaMetadata.BotFeatureType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_FEATURE"] = 0;
                values[valuesById[1] = "REASONING_FEATURE"] = 1;
                return values;
            })();

            return BotFeatureQuotaMetadata;
        })();

        return BotQuotaMetadata;
    })();

    proto.BotReminderMetadata = (function() {

        /**
         * Properties of a BotReminderMetadata.
         * @memberof proto
         * @interface IBotReminderMetadata
         * @property {proto.IMessageKey|null} [requestMessageKey] BotReminderMetadata requestMessageKey
         * @property {proto.BotReminderMetadata.ReminderAction|null} [action] BotReminderMetadata action
         * @property {string|null} [name] BotReminderMetadata name
         * @property {number|Long|null} [nextTriggerTimestamp] BotReminderMetadata nextTriggerTimestamp
         * @property {proto.BotReminderMetadata.ReminderFrequency|null} [frequency] BotReminderMetadata frequency
         */

        /**
         * Constructs a new BotReminderMetadata.
         * @memberof proto
         * @classdesc Represents a BotReminderMetadata.
         * @implements IBotReminderMetadata
         * @constructor
         * @param {proto.IBotReminderMetadata=} [properties] Properties to set
         */
        function BotReminderMetadata(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotReminderMetadata requestMessageKey.
         * @member {proto.IMessageKey|null|undefined} requestMessageKey
         * @memberof proto.BotReminderMetadata
         * @instance
         */
        BotReminderMetadata.prototype.requestMessageKey = null;

        /**
         * BotReminderMetadata action.
         * @member {proto.BotReminderMetadata.ReminderAction|null|undefined} action
         * @memberof proto.BotReminderMetadata
         * @instance
         */
        BotReminderMetadata.prototype.action = null;

        /**
         * BotReminderMetadata name.
         * @member {string|null|undefined} name
         * @memberof proto.BotReminderMetadata
         * @instance
         */
        BotReminderMetadata.prototype.name = null;

        /**
         * BotReminderMetadata nextTriggerTimestamp.
         * @member {number|Long|null|undefined} nextTriggerTimestamp
         * @memberof proto.BotReminderMetadata
         * @instance
         */
        BotReminderMetadata.prototype.nextTriggerTimestamp = null;

        /**
         * BotReminderMetadata frequency.
         * @member {proto.BotReminderMetadata.ReminderFrequency|null|undefined} frequency
         * @memberof proto.BotReminderMetadata
         * @instance
         */
        BotReminderMetadata.prototype.frequency = null;

        // OneOf field names bound to virtual getters and setters
        let $oneOfFields;

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_requestMessageKey", {
            get: $util.oneOfGetter($oneOfFields = ["requestMessageKey"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_action", {
            get: $util.oneOfGetter($oneOfFields = ["action"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_name", {
            get: $util.oneOfGetter($oneOfFields = ["name"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_nextTriggerTimestamp", {
            get: $util.oneOfGetter($oneOfFields = ["nextTriggerTimestamp"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        // Virtual OneOf for proto3 optional field
        Object.defineProperty(BotReminderMetadata.prototype, "_frequency", {
            get: $util.oneOfGetter($oneOfFields = ["frequency"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new BotReminderMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {proto.IBotReminderMetadata=} [properties] Properties to set
         * @returns {proto.BotReminderMetadata} BotReminderMetadata instance
         */
        BotReminderMetadata.create = function create(properties) {
            return new BotReminderMetadata(properties);
        };

        /**
         * Encodes the specified BotReminderMetadata message. Does not implicitly {@link proto.BotReminderMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {proto.IBotReminderMetadata} message BotReminderMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotReminderMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.requestMessageKey != null && Object.hasOwnProperty.call(message, "requestMessageKey"))
                $root.proto.MessageKey.encode(message.requestMessageKey, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.action != null && Object.hasOwnProperty.call(message, "action"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.action);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
            if (message.nextTriggerTimestamp != null && Object.hasOwnProperty.call(message, "nextTriggerTimestamp"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.nextTriggerTimestamp);
            if (message.frequency != null && Object.hasOwnProperty.call(message, "frequency"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.frequency);
            return writer;
        };

        /**
         * Encodes the specified BotReminderMetadata message, length delimited. Does not implicitly {@link proto.BotReminderMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {proto.IBotReminderMetadata} message BotReminderMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotReminderMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotReminderMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotReminderMetadata} BotReminderMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotReminderMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotReminderMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.requestMessageKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        message.action = reader.int32();
                        break;
                    }
                case 3: {
                        message.name = reader.string();
                        break;
                    }
                case 4: {
                        message.nextTriggerTimestamp = reader.uint64();
                        break;
                    }
                case 5: {
                        message.frequency = reader.int32();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotReminderMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotReminderMetadata} BotReminderMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotReminderMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotReminderMetadata message.
         * @function verify
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotReminderMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            let properties = {};
            if (message.requestMessageKey != null && message.hasOwnProperty("requestMessageKey")) {
                properties._requestMessageKey = 1;
                {
                    let error = $root.proto.MessageKey.verify(message.requestMessageKey);
                    if (error)
                        return "requestMessageKey." + error;
                }
            }
            if (message.action != null && message.hasOwnProperty("action")) {
                properties._action = 1;
                switch (message.action) {
                default:
                    return "action: enum value expected";
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            }
            if (message.name != null && message.hasOwnProperty("name")) {
                properties._name = 1;
                if (!$util.isString(message.name))
                    return "name: string expected";
            }
            if (message.nextTriggerTimestamp != null && message.hasOwnProperty("nextTriggerTimestamp")) {
                properties._nextTriggerTimestamp = 1;
                if (!$util.isInteger(message.nextTriggerTimestamp) && !(message.nextTriggerTimestamp && $util.isInteger(message.nextTriggerTimestamp.low) && $util.isInteger(message.nextTriggerTimestamp.high)))
                    return "nextTriggerTimestamp: integer|Long expected";
            }
            if (message.frequency != null && message.hasOwnProperty("frequency")) {
                properties._frequency = 1;
                switch (message.frequency) {
                default:
                    return "frequency: enum value expected";
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            }
            return null;
        };

        /**
         * Creates a BotReminderMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotReminderMetadata} BotReminderMetadata
         */
        BotReminderMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotReminderMetadata)
                return object;
            let message = new $root.proto.BotReminderMetadata();
            if (object.requestMessageKey != null) {
                if (typeof object.requestMessageKey !== "object")
                    throw TypeError(".proto.BotReminderMetadata.requestMessageKey: object expected");
                message.requestMessageKey = $root.proto.MessageKey.fromObject(object.requestMessageKey);
            }
            switch (object.action) {
            default:
                if (typeof object.action === "number") {
                    message.action = object.action;
                    break;
                }
                break;
            case "NOTIFY":
            case 1:
                message.action = 1;
                break;
            case "CREATE":
            case 2:
                message.action = 2;
                break;
            case "DELETE":
            case 3:
                message.action = 3;
                break;
            case "UPDATE":
            case 4:
                message.action = 4;
                break;
            }
            if (object.name != null)
                message.name = String(object.name);
            if (object.nextTriggerTimestamp != null)
                if ($util.Long)
                    (message.nextTriggerTimestamp = $util.Long.fromValue(object.nextTriggerTimestamp)).unsigned = true;
                else if (typeof object.nextTriggerTimestamp === "string")
                    message.nextTriggerTimestamp = parseInt(object.nextTriggerTimestamp, 10);
                else if (typeof object.nextTriggerTimestamp === "number")
                    message.nextTriggerTimestamp = object.nextTriggerTimestamp;
                else if (typeof object.nextTriggerTimestamp === "object")
                    message.nextTriggerTimestamp = new $util.LongBits(object.nextTriggerTimestamp.low >>> 0, object.nextTriggerTimestamp.high >>> 0).toNumber(true);
            switch (object.frequency) {
            default:
                if (typeof object.frequency === "number") {
                    message.frequency = object.frequency;
                    break;
                }
                break;
            case "ONCE":
            case 1:
                message.frequency = 1;
                break;
            case "DAILY":
            case 2:
                message.frequency = 2;
                break;
            case "WEEKLY":
            case 3:
                message.frequency = 3;
                break;
            case "BIWEEKLY":
            case 4:
                message.frequency = 4;
                break;
            case "MONTHLY":
            case 5:
                message.frequency = 5;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BotReminderMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {proto.BotReminderMetadata} message BotReminderMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotReminderMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (message.requestMessageKey != null && message.hasOwnProperty("requestMessageKey")) {
                object.requestMessageKey = $root.proto.MessageKey.toObject(message.requestMessageKey, options);
                if (options.oneofs)
                    object._requestMessageKey = "requestMessageKey";
            }
            if (message.action != null && message.hasOwnProperty("action")) {
                object.action = options.enums === String ? $root.proto.BotReminderMetadata.ReminderAction[message.action] === undefined ? message.action : $root.proto.BotReminderMetadata.ReminderAction[message.action] : message.action;
                if (options.oneofs)
                    object._action = "action";
            }
            if (message.name != null && message.hasOwnProperty("name")) {
                object.name = message.name;
                if (options.oneofs)
                    object._name = "name";
            }
            if (message.nextTriggerTimestamp != null && message.hasOwnProperty("nextTriggerTimestamp")) {
                if (typeof message.nextTriggerTimestamp === "number")
                    object.nextTriggerTimestamp = options.longs === String ? String(message.nextTriggerTimestamp) : message.nextTriggerTimestamp;
                else
                    object.nextTriggerTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.nextTriggerTimestamp) : options.longs === Number ? new $util.LongBits(message.nextTriggerTimestamp.low >>> 0, message.nextTriggerTimestamp.high >>> 0).toNumber(true) : message.nextTriggerTimestamp;
                if (options.oneofs)
                    object._nextTriggerTimestamp = "nextTriggerTimestamp";
            }
            if (message.frequency != null && message.hasOwnProperty("frequency")) {
                object.frequency = options.enums === String ? $root.proto.BotReminderMetadata.ReminderFrequency[message.frequency] === undefined ? message.frequency : $root.proto.BotReminderMetadata.ReminderFrequency[message.frequency] : message.frequency;
                if (options.oneofs)
                    object._frequency = "frequency";
            }
            return object;
        };

        /**
         * Converts this BotReminderMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotReminderMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotReminderMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotReminderMetadata
         * @function getTypeUrl
         * @memberof proto.BotReminderMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotReminderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotReminderMetadata";
        };

        /**
         * ReminderAction enum.
         * @name proto.BotReminderMetadata.ReminderAction
         * @enum {number}
         * @property {number} NOTIFY=1 NOTIFY value
         * @property {number} CREATE=2 CREATE value
         * @property {number} DELETE=3 DELETE value
         * @property {number} UPDATE=4 UPDATE value
         */
        BotReminderMetadata.ReminderAction = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "NOTIFY"] = 1;
            values[valuesById[2] = "CREATE"] = 2;
            values[valuesById[3] = "DELETE"] = 3;
            values[valuesById[4] = "UPDATE"] = 4;
            return values;
        })();

        /**
         * ReminderFrequency enum.
         * @name proto.BotReminderMetadata.ReminderFrequency
         * @enum {number}
         * @property {number} ONCE=1 ONCE value
         * @property {number} DAILY=2 DAILY value
         * @property {number} WEEKLY=3 WEEKLY value
         * @property {number} BIWEEKLY=4 BIWEEKLY value
         * @property {number} MONTHLY=5 MONTHLY value
         */
        BotReminderMetadata.ReminderFrequency = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "ONCE"] = 1;
            values[valuesById[2] = "DAILY"] = 2;
            values[valuesById[3] = "WEEKLY"] = 3;
            values[valuesById[4] = "BIWEEKLY"] = 4;
            values[valuesById[5] = "MONTHLY"] = 5;
            return values;
        })();

        return BotReminderMetadata;
    })();

    proto.BotRenderingMetadata = (function() {

        /**
         * Properties of a BotRenderingMetadata.
         * @memberof proto
         * @interface IBotRenderingMetadata
         * @property {Array.<proto.BotRenderingMetadata.IKeyword>|null} [keywords] BotRenderingMetadata keywords
         */

        /**
         * Constructs a new BotRenderingMetadata.
         * @memberof proto
         * @classdesc Represents a BotRenderingMetadata.
         * @implements IBotRenderingMetadata
         * @constructor
         * @param {proto.IBotRenderingMetadata=} [properties] Properties to set
         */
        function BotRenderingMetadata(properties) {
            this.keywords = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BotRenderingMetadata keywords.
         * @member {Array.<proto.BotRenderingMetadata.IKeyword>} keywords
         * @memberof proto.BotRenderingMetadata
         * @instance
         */
        BotRenderingMetadata.prototype.keywords = $util.emptyArray;

        /**
         * Creates a new BotRenderingMetadata instance using the specified properties.
         * @function create
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {proto.IBotRenderingMetadata=} [properties] Properties to set
         * @returns {proto.BotRenderingMetadata} BotRenderingMetadata instance
         */
        BotRenderingMetadata.create = function create(properties) {
            return new BotRenderingMetadata(properties);
        };

        /**
         * Encodes the specified BotRenderingMetadata message. Does not implicitly {@link proto.BotRenderingMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {proto.IBotRenderingMetadata} message BotRenderingMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotRenderingMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keywords != null && message.keywords.length)
                for (let i = 0; i < message.keywords.length; ++i)
                    $root.proto.BotRenderingMetadata.Keyword.encode(message.keywords[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified BotRenderingMetadata message, length delimited. Does not implicitly {@link proto.BotRenderingMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {proto.IBotRenderingMetadata} message BotRenderingMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BotRenderingMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BotRenderingMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BotRenderingMetadata} BotRenderingMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotRenderingMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotRenderingMetadata();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        if (!(message.keywords && message.keywords.length))
                            message.keywords = [];
                        message.keywords.push($root.proto.BotRenderingMetadata.Keyword.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BotRenderingMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BotRenderingMetadata} BotRenderingMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BotRenderingMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BotRenderingMetadata message.
         * @function verify
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BotRenderingMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keywords != null && message.hasOwnProperty("keywords")) {
                if (!Array.isArray(message.keywords))
                    return "keywords: array expected";
                for (let i = 0; i < message.keywords.length; ++i) {
                    let error = $root.proto.BotRenderingMetadata.Keyword.verify(message.keywords[i]);
                    if (error)
                        return "keywords." + error;
                }
            }
            return null;
        };

        /**
         * Creates a BotRenderingMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BotRenderingMetadata} BotRenderingMetadata
         */
        BotRenderingMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BotRenderingMetadata)
                return object;
            let message = new $root.proto.BotRenderingMetadata();
            if (object.keywords) {
                if (!Array.isArray(object.keywords))
                    throw TypeError(".proto.BotRenderingMetadata.keywords: array expected");
                message.keywords = [];
                for (let i = 0; i < object.keywords.length; ++i) {
                    if (typeof object.keywords[i] !== "object")
                        throw TypeError(".proto.BotRenderingMetadata.keywords: object expected");
                    message.keywords[i] = $root.proto.BotRenderingMetadata.Keyword.fromObject(object.keywords[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a BotRenderingMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {proto.BotRenderingMetadata} message BotRenderingMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BotRenderingMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.keywords = [];
            if (message.keywords && message.keywords.length) {
                object.keywords = [];
                for (let j = 0; j < message.keywords.length; ++j)
                    object.keywords[j] = $root.proto.BotRenderingMetadata.Keyword.toObject(message.keywords[j], options);
            }
            return object;
        };

        /**
         * Converts this BotRenderingMetadata to JSON.
         * @function toJSON
         * @memberof proto.BotRenderingMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BotRenderingMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for BotRenderingMetadata
         * @function getTypeUrl
         * @memberof proto.BotRenderingMetadata
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        BotRenderingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotRenderingMetadata";
        };

        BotRenderingMetadata.Keyword = (function() {

            /**
             * Properties of a Keyword.
             * @memberof proto.BotRenderingMetadata
             * @interface IKeyword
             * @property {string|null} [value] Keyword value
             * @property {Array.<string>|null} [associatedPrompts] Keyword associatedPrompts
             */

            /**
             * Constructs a new Keyword.
             * @memberof proto.BotRenderingMetadata
             * @classdesc Represents a Keyword.
             * @implements IKeyword
             * @constructor
             * @param {proto.BotRenderingMetadata.IKeyword=} [properties] Properties to set
             */
            function Keyword(properties) {
                this.associatedPrompts = [];
                if (properties)
                    for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * Keyword value.
             * @member {string|null|undefined} value
             * @memberof proto.BotRenderingMetadata.Keyword
             * @instance
             */
            Keyword.prototype.value = null;

            /**
             * Keyword associatedPrompts.
             * @member {Array.<string>} associatedPrompts
             * @memberof proto.BotRenderingMetadata.Keyword
             * @instance
             */
            Keyword.prototype.associatedPrompts = $util.emptyArray;

            // OneOf field names bound to virtual getters and setters
            let $oneOfFields;

            // Virtual OneOf for proto3 optional field
            Object.defineProperty(Keyword.prototype, "_value", {
                get: $util.oneOfGetter($oneOfFields = ["value"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            /**
             * Creates a new Keyword instance using the specified properties.
             * @function create
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {proto.BotRenderingMetadata.IKeyword=} [properties] Properties to set
             * @returns {proto.BotRenderingMetadata.Keyword} Keyword instance
             */
            Keyword.create = function create(properties) {
                return new Keyword(properties);
            };

            /**
             * Encodes the specified Keyword message. Does not implicitly {@link proto.BotRenderingMetadata.Keyword.verify|verify} messages.
             * @function encode
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {proto.BotRenderingMetadata.IKeyword} message Keyword message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            Keyword.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.value);
                if (message.associatedPrompts != null && message.associatedPrompts.length)
                    for (let i = 0; i < message.associatedPrompts.length; ++i)
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.associatedPrompts[i]);
                return writer;
            };

            /**
             * Encodes the specified Keyword message, length delimited. Does not implicitly {@link proto.BotRenderingMetadata.Keyword.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {proto.BotRenderingMetadata.IKeyword} message Keyword message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            Keyword.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a Keyword message from the specified reader or buffer.
             * @function decode
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.BotRenderingMetadata.Keyword} Keyword
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            Keyword.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                let end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BotRenderingMetadata.Keyword();
                while (reader.pos < end) {
                    let tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            message.value = reader.string();
                            break;
                        }
                    case 2: {
                            if (!(message.associatedPrompts && message.associatedPrompts.length))
                                message.associatedPrompts = [];
                            message.associatedPrompts.push(reader.string());
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a Keyword message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.BotRenderingMetadata.Keyword} Keyword
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            Keyword.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a Keyword message.
             * @function verify
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            Keyword.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                let properties = {};
                if (message.value != null && message.hasOwnProperty("value")) {
                    properties._value = 1;
                    if (!$util.isString(message.value))
                        return "value: string expected";
                }
                if (message.associatedPrompts != null && message.hasOwnProperty("associatedPrompts")) {
                    if (!Array.isArray(message.associatedPrompts))
                        return "associatedPrompts: array expected";
                    for (let i = 0; i < message.associatedPrompts.length; ++i)
                        if (!$util.isString(message.associatedPrompts[i]))
                            return "associatedPrompts: string[] expected";
                }
                return null;
            };

            /**
             * Creates a Keyword message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.BotRenderingMetadata.Keyword} Keyword
             */
            Keyword.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.BotRenderingMetadata.Keyword)
                    return object;
                let message = new $root.proto.BotRenderingMetadata.Keyword();
                if (object.value != null)
                    message.value = String(object.value);
                if (object.associatedPrompts) {
                    if (!Array.isArray(object.associatedPrompts))
                        throw TypeError(".proto.BotRenderingMetadata.Keyword.associatedPrompts: array expected");
                    message.associatedPrompts = [];
                    for (let i = 0; i < object.associatedPrompts.length; ++i)
                        message.associatedPrompts[i] = String(object.associatedPrompts[i]);
                }
                return message;
            };

            /**
             * Creates a plain object from a Keyword message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.BotRenderingMetadata.Keyword
             * @static
             * @param {proto.BotRenderingMetadata.Keyword} message Keyword
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            Keyword.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                let object = {};
                if (options.arrays 